/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralbenefits;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.partnercentralbenefits.model.AccessDeniedException;
import software.amazon.awssdk.services.partnercentralbenefits.model.AmendBenefitApplicationRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.AmendBenefitApplicationResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.AssociateBenefitApplicationResourceRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.AssociateBenefitApplicationResourceResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.CancelBenefitApplicationRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.CancelBenefitApplicationResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.ConflictException;
import software.amazon.awssdk.services.partnercentralbenefits.model.CreateBenefitApplicationRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.CreateBenefitApplicationResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.DisassociateBenefitApplicationResourceRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.DisassociateBenefitApplicationResourceResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.GetBenefitAllocationRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.GetBenefitAllocationResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.GetBenefitApplicationRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.GetBenefitApplicationResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.GetBenefitRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.GetBenefitResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.InternalServerException;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitAllocationsRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitAllocationsResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitApplicationsRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitApplicationsResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitsRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitsResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.PartnerCentralBenefitsException;
import software.amazon.awssdk.services.partnercentralbenefits.model.RecallBenefitApplicationRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.RecallBenefitApplicationResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.ResourceNotFoundException;
import software.amazon.awssdk.services.partnercentralbenefits.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.partnercentralbenefits.model.SubmitBenefitApplicationRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.SubmitBenefitApplicationResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.TagResourceRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.TagResourceResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.ThrottlingException;
import software.amazon.awssdk.services.partnercentralbenefits.model.UntagResourceRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.UntagResourceResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.UpdateBenefitApplicationRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.UpdateBenefitApplicationResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.ValidationException;
import software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitAllocationsIterable;
import software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitApplicationsIterable;
import software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitsIterable;

/**
 * Service client for accessing PartnerCentral Benefits. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * AWS Partner Central Benefits Service provides APIs for managing partner benefits, applications, and allocations
 * within the AWS Partner Network ecosystem.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface PartnerCentralBenefitsClient extends AwsClient {
    String SERVICE_NAME = "partnercentral-benefits";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "partnercentral-benefits";

    /**
     * <p>
     * Modifies an existing benefit application by applying amendments to specific fields while maintaining revision
     * control.
     * </p>
     *
     * @param amendBenefitApplicationRequest
     * @return Result of the AmendBenefitApplication operation returned by the service.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ConflictException
     *         Thrown when the request conflicts with the current state of the resource, such as attempting to modify a
     *         resource that has been changed by another process.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.AmendBenefitApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/AmendBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default AmendBenefitApplicationResponse amendBenefitApplication(AmendBenefitApplicationRequest amendBenefitApplicationRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ConflictException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralBenefitsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies an existing benefit application by applying amendments to specific fields while maintaining revision
     * control.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AmendBenefitApplicationRequest.Builder} avoiding
     * the need to create one manually via {@link AmendBenefitApplicationRequest#builder()}
     * </p>
     *
     * @param amendBenefitApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.AmendBenefitApplicationRequest.Builder}
     *        to create a request.
     * @return Result of the AmendBenefitApplication operation returned by the service.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ConflictException
     *         Thrown when the request conflicts with the current state of the resource, such as attempting to modify a
     *         resource that has been changed by another process.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.AmendBenefitApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/AmendBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default AmendBenefitApplicationResponse amendBenefitApplication(
            Consumer<AmendBenefitApplicationRequest.Builder> amendBenefitApplicationRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ConflictException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralBenefitsException {
        return amendBenefitApplication(AmendBenefitApplicationRequest.builder().applyMutation(amendBenefitApplicationRequest)
                .build());
    }

    /**
     * <p>
     * Links an AWS resource to an existing benefit application for tracking and management purposes.
     * </p>
     *
     * @param associateBenefitApplicationResourceRequest
     * @return Result of the AssociateBenefitApplicationResource operation returned by the service.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ConflictException
     *         Thrown when the request conflicts with the current state of the resource, such as attempting to modify a
     *         resource that has been changed by another process.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.AssociateBenefitApplicationResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/AssociateBenefitApplicationResource"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateBenefitApplicationResourceResponse associateBenefitApplicationResource(
            AssociateBenefitApplicationResourceRequest associateBenefitApplicationResourceRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ConflictException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralBenefitsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Links an AWS resource to an existing benefit application for tracking and management purposes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateBenefitApplicationResourceRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateBenefitApplicationResourceRequest#builder()}
     * </p>
     *
     * @param associateBenefitApplicationResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.AssociateBenefitApplicationResourceRequest.Builder}
     *        to create a request.
     * @return Result of the AssociateBenefitApplicationResource operation returned by the service.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ConflictException
     *         Thrown when the request conflicts with the current state of the resource, such as attempting to modify a
     *         resource that has been changed by another process.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.AssociateBenefitApplicationResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/AssociateBenefitApplicationResource"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateBenefitApplicationResourceResponse associateBenefitApplicationResource(
            Consumer<AssociateBenefitApplicationResourceRequest.Builder> associateBenefitApplicationResourceRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ConflictException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralBenefitsException {
        return associateBenefitApplicationResource(AssociateBenefitApplicationResourceRequest.builder()
                .applyMutation(associateBenefitApplicationResourceRequest).build());
    }

    /**
     * <p>
     * Cancels a benefit application that is currently in progress, preventing further processing.
     * </p>
     *
     * @param cancelBenefitApplicationRequest
     * @return Result of the CancelBenefitApplication operation returned by the service.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ConflictException
     *         Thrown when the request conflicts with the current state of the resource, such as attempting to modify a
     *         resource that has been changed by another process.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.CancelBenefitApplication
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/CancelBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelBenefitApplicationResponse cancelBenefitApplication(
            CancelBenefitApplicationRequest cancelBenefitApplicationRequest) throws ValidationException, AccessDeniedException,
            InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, PartnerCentralBenefitsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a benefit application that is currently in progress, preventing further processing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelBenefitApplicationRequest.Builder} avoiding
     * the need to create one manually via {@link CancelBenefitApplicationRequest#builder()}
     * </p>
     *
     * @param cancelBenefitApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.CancelBenefitApplicationRequest.Builder}
     *        to create a request.
     * @return Result of the CancelBenefitApplication operation returned by the service.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ConflictException
     *         Thrown when the request conflicts with the current state of the resource, such as attempting to modify a
     *         resource that has been changed by another process.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.CancelBenefitApplication
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/CancelBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelBenefitApplicationResponse cancelBenefitApplication(
            Consumer<CancelBenefitApplicationRequest.Builder> cancelBenefitApplicationRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, PartnerCentralBenefitsException {
        return cancelBenefitApplication(CancelBenefitApplicationRequest.builder().applyMutation(cancelBenefitApplicationRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new benefit application for a partner to request access to AWS benefits and programs.
     * </p>
     *
     * @param createBenefitApplicationRequest
     * @return Result of the CreateBenefitApplication operation returned by the service.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ConflictException
     *         Thrown when the request conflicts with the current state of the resource, such as attempting to modify a
     *         resource that has been changed by another process.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.CreateBenefitApplication
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/CreateBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBenefitApplicationResponse createBenefitApplication(
            CreateBenefitApplicationRequest createBenefitApplicationRequest) throws ValidationException, AccessDeniedException,
            InternalServerException, ConflictException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, PartnerCentralBenefitsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new benefit application for a partner to request access to AWS benefits and programs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBenefitApplicationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateBenefitApplicationRequest#builder()}
     * </p>
     *
     * @param createBenefitApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.CreateBenefitApplicationRequest.Builder}
     *        to create a request.
     * @return Result of the CreateBenefitApplication operation returned by the service.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ConflictException
     *         Thrown when the request conflicts with the current state of the resource, such as attempting to modify a
     *         resource that has been changed by another process.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.CreateBenefitApplication
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/CreateBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBenefitApplicationResponse createBenefitApplication(
            Consumer<CreateBenefitApplicationRequest.Builder> createBenefitApplicationRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ConflictException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralBenefitsException {
        return createBenefitApplication(CreateBenefitApplicationRequest.builder().applyMutation(createBenefitApplicationRequest)
                .build());
    }

    /**
     * <p>
     * Removes the association between an AWS resource and a benefit application.
     * </p>
     *
     * @param disassociateBenefitApplicationResourceRequest
     * @return Result of the DisassociateBenefitApplicationResource operation returned by the service.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ConflictException
     *         Thrown when the request conflicts with the current state of the resource, such as attempting to modify a
     *         resource that has been changed by another process.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.DisassociateBenefitApplicationResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/DisassociateBenefitApplicationResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateBenefitApplicationResourceResponse disassociateBenefitApplicationResource(
            DisassociateBenefitApplicationResourceRequest disassociateBenefitApplicationResourceRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ConflictException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralBenefitsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the association between an AWS resource and a benefit application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateBenefitApplicationResourceRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateBenefitApplicationResourceRequest#builder()}
     * </p>
     *
     * @param disassociateBenefitApplicationResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.DisassociateBenefitApplicationResourceRequest.Builder}
     *        to create a request.
     * @return Result of the DisassociateBenefitApplicationResource operation returned by the service.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ConflictException
     *         Thrown when the request conflicts with the current state of the resource, such as attempting to modify a
     *         resource that has been changed by another process.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.DisassociateBenefitApplicationResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/DisassociateBenefitApplicationResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateBenefitApplicationResourceResponse disassociateBenefitApplicationResource(
            Consumer<DisassociateBenefitApplicationResourceRequest.Builder> disassociateBenefitApplicationResourceRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ConflictException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralBenefitsException {
        return disassociateBenefitApplicationResource(DisassociateBenefitApplicationResourceRequest.builder()
                .applyMutation(disassociateBenefitApplicationResourceRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed information about a specific benefit available in the partner catalog.
     * </p>
     *
     * @param getBenefitRequest
     * @return Result of the GetBenefit operation returned by the service.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.GetBenefit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/GetBenefit"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBenefitResponse getBenefit(GetBenefitRequest getBenefitRequest) throws ValidationException, AccessDeniedException,
            InternalServerException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralBenefitsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed information about a specific benefit available in the partner catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBenefitRequest.Builder} avoiding the need to
     * create one manually via {@link GetBenefitRequest#builder()}
     * </p>
     *
     * @param getBenefitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.GetBenefitRequest.Builder} to create a
     *        request.
     * @return Result of the GetBenefit operation returned by the service.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.GetBenefit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/GetBenefit"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBenefitResponse getBenefit(Consumer<GetBenefitRequest.Builder> getBenefitRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, PartnerCentralBenefitsException {
        return getBenefit(GetBenefitRequest.builder().applyMutation(getBenefitRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed information about a specific benefit allocation that has been granted to a partner.
     * </p>
     *
     * @param getBenefitAllocationRequest
     * @return Result of the GetBenefitAllocation operation returned by the service.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.GetBenefitAllocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/GetBenefitAllocation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBenefitAllocationResponse getBenefitAllocation(GetBenefitAllocationRequest getBenefitAllocationRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, PartnerCentralBenefitsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed information about a specific benefit allocation that has been granted to a partner.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBenefitAllocationRequest.Builder} avoiding the
     * need to create one manually via {@link GetBenefitAllocationRequest#builder()}
     * </p>
     *
     * @param getBenefitAllocationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.GetBenefitAllocationRequest.Builder}
     *        to create a request.
     * @return Result of the GetBenefitAllocation operation returned by the service.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.GetBenefitAllocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/GetBenefitAllocation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBenefitAllocationResponse getBenefitAllocation(
            Consumer<GetBenefitAllocationRequest.Builder> getBenefitAllocationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, PartnerCentralBenefitsException {
        return getBenefitAllocation(GetBenefitAllocationRequest.builder().applyMutation(getBenefitAllocationRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed information about a specific benefit application.
     * </p>
     *
     * @param getBenefitApplicationRequest
     * @return Result of the GetBenefitApplication operation returned by the service.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ConflictException
     *         Thrown when the request conflicts with the current state of the resource, such as attempting to modify a
     *         resource that has been changed by another process.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.GetBenefitApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/GetBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBenefitApplicationResponse getBenefitApplication(GetBenefitApplicationRequest getBenefitApplicationRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ConflictException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            PartnerCentralBenefitsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed information about a specific benefit application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBenefitApplicationRequest.Builder} avoiding the
     * need to create one manually via {@link GetBenefitApplicationRequest#builder()}
     * </p>
     *
     * @param getBenefitApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.GetBenefitApplicationRequest.Builder}
     *        to create a request.
     * @return Result of the GetBenefitApplication operation returned by the service.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ConflictException
     *         Thrown when the request conflicts with the current state of the resource, such as attempting to modify a
     *         resource that has been changed by another process.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.GetBenefitApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/GetBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBenefitApplicationResponse getBenefitApplication(
            Consumer<GetBenefitApplicationRequest.Builder> getBenefitApplicationRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, PartnerCentralBenefitsException {
        return getBenefitApplication(GetBenefitApplicationRequest.builder().applyMutation(getBenefitApplicationRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of benefit allocations based on specified filter criteria.
     * </p>
     *
     * @param listBenefitAllocationsRequest
     * @return Result of the ListBenefitAllocations operation returned by the service.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.ListBenefitAllocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/ListBenefitAllocations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBenefitAllocationsResponse listBenefitAllocations(ListBenefitAllocationsRequest listBenefitAllocationsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, PartnerCentralBenefitsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of benefit allocations based on specified filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBenefitAllocationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBenefitAllocationsRequest#builder()}
     * </p>
     *
     * @param listBenefitAllocationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitAllocationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListBenefitAllocations operation returned by the service.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.ListBenefitAllocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/ListBenefitAllocations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBenefitAllocationsResponse listBenefitAllocations(
            Consumer<ListBenefitAllocationsRequest.Builder> listBenefitAllocationsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, PartnerCentralBenefitsException {
        return listBenefitAllocations(ListBenefitAllocationsRequest.builder().applyMutation(listBenefitAllocationsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBenefitAllocations(software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitAllocationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitAllocationsIterable responses = client.listBenefitAllocationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitAllocationsIterable responses = client
     *             .listBenefitAllocationsPaginator(request);
     *     for (software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitAllocationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitAllocationsIterable responses = client.listBenefitAllocationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBenefitAllocations(software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitAllocationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBenefitAllocationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.ListBenefitAllocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/ListBenefitAllocations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBenefitAllocationsIterable listBenefitAllocationsPaginator(
            ListBenefitAllocationsRequest listBenefitAllocationsRequest) throws AccessDeniedException, ValidationException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            PartnerCentralBenefitsException {
        return new ListBenefitAllocationsIterable(this, listBenefitAllocationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBenefitAllocations(software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitAllocationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitAllocationsIterable responses = client.listBenefitAllocationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitAllocationsIterable responses = client
     *             .listBenefitAllocationsPaginator(request);
     *     for (software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitAllocationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitAllocationsIterable responses = client.listBenefitAllocationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBenefitAllocations(software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitAllocationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBenefitAllocationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBenefitAllocationsRequest#builder()}
     * </p>
     *
     * @param listBenefitAllocationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitAllocationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.ListBenefitAllocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/ListBenefitAllocations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBenefitAllocationsIterable listBenefitAllocationsPaginator(
            Consumer<ListBenefitAllocationsRequest.Builder> listBenefitAllocationsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, PartnerCentralBenefitsException {
        return listBenefitAllocationsPaginator(ListBenefitAllocationsRequest.builder()
                .applyMutation(listBenefitAllocationsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of benefit applications based on specified filter criteria.
     * </p>
     *
     * @param listBenefitApplicationsRequest
     * @return Result of the ListBenefitApplications operation returned by the service.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.ListBenefitApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/ListBenefitApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBenefitApplicationsResponse listBenefitApplications(ListBenefitApplicationsRequest listBenefitApplicationsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralBenefitsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of benefit applications based on specified filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBenefitApplicationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListBenefitApplicationsRequest#builder()}
     * </p>
     *
     * @param listBenefitApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitApplicationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListBenefitApplications operation returned by the service.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.ListBenefitApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/ListBenefitApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBenefitApplicationsResponse listBenefitApplications(
            Consumer<ListBenefitApplicationsRequest.Builder> listBenefitApplicationsRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, PartnerCentralBenefitsException {
        return listBenefitApplications(ListBenefitApplicationsRequest.builder().applyMutation(listBenefitApplicationsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBenefitApplications(software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitApplicationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitApplicationsIterable responses = client.listBenefitApplicationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitApplicationsIterable responses = client
     *             .listBenefitApplicationsPaginator(request);
     *     for (software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitApplicationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitApplicationsIterable responses = client.listBenefitApplicationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBenefitApplications(software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBenefitApplicationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.ListBenefitApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/ListBenefitApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBenefitApplicationsIterable listBenefitApplicationsPaginator(
            ListBenefitApplicationsRequest listBenefitApplicationsRequest) throws ValidationException, AccessDeniedException,
            InternalServerException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralBenefitsException {
        return new ListBenefitApplicationsIterable(this, listBenefitApplicationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBenefitApplications(software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitApplicationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitApplicationsIterable responses = client.listBenefitApplicationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitApplicationsIterable responses = client
     *             .listBenefitApplicationsPaginator(request);
     *     for (software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitApplicationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitApplicationsIterable responses = client.listBenefitApplicationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBenefitApplications(software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitApplicationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBenefitApplicationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListBenefitApplicationsRequest#builder()}
     * </p>
     *
     * @param listBenefitApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitApplicationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.ListBenefitApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/ListBenefitApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBenefitApplicationsIterable listBenefitApplicationsPaginator(
            Consumer<ListBenefitApplicationsRequest.Builder> listBenefitApplicationsRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, PartnerCentralBenefitsException {
        return listBenefitApplicationsPaginator(ListBenefitApplicationsRequest.builder()
                .applyMutation(listBenefitApplicationsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of available benefits based on specified filter criteria.
     * </p>
     *
     * @param listBenefitsRequest
     * @return Result of the ListBenefits operation returned by the service.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.ListBenefits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/ListBenefits"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBenefitsResponse listBenefits(ListBenefitsRequest listBenefitsRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, PartnerCentralBenefitsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of available benefits based on specified filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBenefitsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBenefitsRequest#builder()}
     * </p>
     *
     * @param listBenefitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitsRequest.Builder} to create
     *        a request.
     * @return Result of the ListBenefits operation returned by the service.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.ListBenefits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/ListBenefits"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBenefitsResponse listBenefits(Consumer<ListBenefitsRequest.Builder> listBenefitsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralBenefitsException {
        return listBenefits(ListBenefitsRequest.builder().applyMutation(listBenefitsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBenefits(software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitsIterable responses = client.listBenefitsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitsIterable responses = client
     *             .listBenefitsPaginator(request);
     *     for (software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitsIterable responses = client.listBenefitsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBenefits(software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBenefitsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.ListBenefits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/ListBenefits"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBenefitsIterable listBenefitsPaginator(ListBenefitsRequest listBenefitsRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, PartnerCentralBenefitsException {
        return new ListBenefitsIterable(this, listBenefitsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBenefits(software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitsIterable responses = client.listBenefitsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitsIterable responses = client
     *             .listBenefitsPaginator(request);
     *     for (software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitsIterable responses = client.listBenefitsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBenefits(software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBenefitsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBenefitsRequest#builder()}
     * </p>
     *
     * @param listBenefitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.ListBenefits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/ListBenefits"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBenefitsIterable listBenefitsPaginator(Consumer<ListBenefitsRequest.Builder> listBenefitsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralBenefitsException {
        return listBenefitsPaginator(ListBenefitsRequest.builder().applyMutation(listBenefitsRequest).build());
    }

    /**
     * <p>
     * Retrieves all tags associated with a specific resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralBenefitsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all tags associated with a specific resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, PartnerCentralBenefitsException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Recalls a submitted benefit application, returning it to draft status for further modifications.
     * </p>
     *
     * @param recallBenefitApplicationRequest
     * @return Result of the RecallBenefitApplication operation returned by the service.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ConflictException
     *         Thrown when the request conflicts with the current state of the resource, such as attempting to modify a
     *         resource that has been changed by another process.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.RecallBenefitApplication
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/RecallBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default RecallBenefitApplicationResponse recallBenefitApplication(
            RecallBenefitApplicationRequest recallBenefitApplicationRequest) throws ValidationException, AccessDeniedException,
            InternalServerException, ConflictException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, PartnerCentralBenefitsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Recalls a submitted benefit application, returning it to draft status for further modifications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RecallBenefitApplicationRequest.Builder} avoiding
     * the need to create one manually via {@link RecallBenefitApplicationRequest#builder()}
     * </p>
     *
     * @param recallBenefitApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.RecallBenefitApplicationRequest.Builder}
     *        to create a request.
     * @return Result of the RecallBenefitApplication operation returned by the service.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ConflictException
     *         Thrown when the request conflicts with the current state of the resource, such as attempting to modify a
     *         resource that has been changed by another process.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.RecallBenefitApplication
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/RecallBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default RecallBenefitApplicationResponse recallBenefitApplication(
            Consumer<RecallBenefitApplicationRequest.Builder> recallBenefitApplicationRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ConflictException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralBenefitsException {
        return recallBenefitApplication(RecallBenefitApplicationRequest.builder().applyMutation(recallBenefitApplicationRequest)
                .build());
    }

    /**
     * <p>
     * Submits a benefit application for review and processing by AWS.
     * </p>
     *
     * @param submitBenefitApplicationRequest
     * @return Result of the SubmitBenefitApplication operation returned by the service.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ConflictException
     *         Thrown when the request conflicts with the current state of the resource, such as attempting to modify a
     *         resource that has been changed by another process.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.SubmitBenefitApplication
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/SubmitBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default SubmitBenefitApplicationResponse submitBenefitApplication(
            SubmitBenefitApplicationRequest submitBenefitApplicationRequest) throws AccessDeniedException, ValidationException,
            InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, PartnerCentralBenefitsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Submits a benefit application for review and processing by AWS.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SubmitBenefitApplicationRequest.Builder} avoiding
     * the need to create one manually via {@link SubmitBenefitApplicationRequest#builder()}
     * </p>
     *
     * @param submitBenefitApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.SubmitBenefitApplicationRequest.Builder}
     *        to create a request.
     * @return Result of the SubmitBenefitApplication operation returned by the service.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ConflictException
     *         Thrown when the request conflicts with the current state of the resource, such as attempting to modify a
     *         resource that has been changed by another process.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.SubmitBenefitApplication
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/SubmitBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default SubmitBenefitApplicationResponse submitBenefitApplication(
            Consumer<SubmitBenefitApplicationRequest.Builder> submitBenefitApplicationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, PartnerCentralBenefitsException {
        return submitBenefitApplication(SubmitBenefitApplicationRequest.builder().applyMutation(submitBenefitApplicationRequest)
                .build());
    }

    /**
     * <p>
     * Adds or updates tags for a specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ConflictException
     *         Thrown when the request conflicts with the current state of the resource, such as attempting to modify a
     *         resource that has been changed by another process.
     * @throws ServiceQuotaExceededException
     *         Thrown when the request would exceed the service quotas or limits for the account.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            PartnerCentralBenefitsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates tags for a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.TagResourceRequest.Builder} to create
     *        a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ConflictException
     *         Thrown when the request conflicts with the current state of the resource, such as attempting to modify a
     *         resource that has been changed by another process.
     * @throws ServiceQuotaExceededException
     *         Thrown when the request would exceed the service quotas or limits for the account.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ConflictException,
            ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, PartnerCentralBenefitsException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes specified tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ConflictException
     *         Thrown when the request conflicts with the current state of the resource, such as attempting to modify a
     *         resource that has been changed by another process.
     * @throws ServiceQuotaExceededException
     *         Thrown when the request would exceed the service quotas or limits for the account.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            PartnerCentralBenefitsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes specified tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.UntagResourceRequest.Builder} to
     *        create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ConflictException
     *         Thrown when the request conflicts with the current state of the resource, such as attempting to modify a
     *         resource that has been changed by another process.
     * @throws ServiceQuotaExceededException
     *         Thrown when the request would exceed the service quotas or limits for the account.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ConflictException,
            ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, PartnerCentralBenefitsException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing benefit application with new information while maintaining revision control.
     * </p>
     *
     * @param updateBenefitApplicationRequest
     * @return Result of the UpdateBenefitApplication operation returned by the service.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ConflictException
     *         Thrown when the request conflicts with the current state of the resource, such as attempting to modify a
     *         resource that has been changed by another process.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.UpdateBenefitApplication
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/UpdateBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBenefitApplicationResponse updateBenefitApplication(
            UpdateBenefitApplicationRequest updateBenefitApplicationRequest) throws ValidationException, AccessDeniedException,
            InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, PartnerCentralBenefitsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing benefit application with new information while maintaining revision control.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBenefitApplicationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateBenefitApplicationRequest#builder()}
     * </p>
     *
     * @param updateBenefitApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.UpdateBenefitApplicationRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateBenefitApplication operation returned by the service.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ConflictException
     *         Thrown when the request conflicts with the current state of the resource, such as attempting to modify a
     *         resource that has been changed by another process.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.UpdateBenefitApplication
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/UpdateBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBenefitApplicationResponse updateBenefitApplication(
            Consumer<UpdateBenefitApplicationRequest.Builder> updateBenefitApplicationRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, PartnerCentralBenefitsException {
        return updateBenefitApplication(UpdateBenefitApplicationRequest.builder().applyMutation(updateBenefitApplicationRequest)
                .build());
    }

    /**
     * Create a {@link PartnerCentralBenefitsClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static PartnerCentralBenefitsClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link PartnerCentralBenefitsClient}.
     */
    static PartnerCentralBenefitsClientBuilder builder() {
        return new DefaultPartnerCentralBenefitsClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default PartnerCentralBenefitsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
