/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralbenefits;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.partnercentralbenefits.model.AmendBenefitApplicationRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.AmendBenefitApplicationResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.AssociateBenefitApplicationResourceRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.AssociateBenefitApplicationResourceResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.CancelBenefitApplicationRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.CancelBenefitApplicationResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.CreateBenefitApplicationRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.CreateBenefitApplicationResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.DisassociateBenefitApplicationResourceRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.DisassociateBenefitApplicationResourceResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.GetBenefitAllocationRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.GetBenefitAllocationResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.GetBenefitApplicationRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.GetBenefitApplicationResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.GetBenefitRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.GetBenefitResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitAllocationsRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitAllocationsResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitApplicationsRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitApplicationsResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitsRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitsResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.RecallBenefitApplicationRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.RecallBenefitApplicationResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.SubmitBenefitApplicationRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.SubmitBenefitApplicationResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.TagResourceRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.TagResourceResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.UntagResourceRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.UntagResourceResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.UpdateBenefitApplicationRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.UpdateBenefitApplicationResponse;
import software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitAllocationsPublisher;
import software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitApplicationsPublisher;
import software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitsPublisher;

/**
 * Service client for accessing PartnerCentral Benefits asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * AWS Partner Central Benefits Service provides APIs for managing partner benefits, applications, and allocations
 * within the AWS Partner Network ecosystem.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface PartnerCentralBenefitsAsyncClient extends AwsClient {
    String SERVICE_NAME = "partnercentral-benefits";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "partnercentral-benefits";

    /**
     * <p>
     * Modifies an existing benefit application by applying amendments to specific fields while maintaining revision
     * control.
     * </p>
     *
     * @param amendBenefitApplicationRequest
     * @return A Java Future containing the result of the AmendBenefitApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ConflictException Thrown when the request conflicts with the current state of the resource, such as
     *         attempting to modify a resource that has been changed by another process.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.AmendBenefitApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/AmendBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AmendBenefitApplicationResponse> amendBenefitApplication(
            AmendBenefitApplicationRequest amendBenefitApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies an existing benefit application by applying amendments to specific fields while maintaining revision
     * control.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AmendBenefitApplicationRequest.Builder} avoiding
     * the need to create one manually via {@link AmendBenefitApplicationRequest#builder()}
     * </p>
     *
     * @param amendBenefitApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.AmendBenefitApplicationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AmendBenefitApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ConflictException Thrown when the request conflicts with the current state of the resource, such as
     *         attempting to modify a resource that has been changed by another process.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.AmendBenefitApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/AmendBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AmendBenefitApplicationResponse> amendBenefitApplication(
            Consumer<AmendBenefitApplicationRequest.Builder> amendBenefitApplicationRequest) {
        return amendBenefitApplication(AmendBenefitApplicationRequest.builder().applyMutation(amendBenefitApplicationRequest)
                .build());
    }

    /**
     * <p>
     * Links an AWS resource to an existing benefit application for tracking and management purposes.
     * </p>
     *
     * @param associateBenefitApplicationResourceRequest
     * @return A Java Future containing the result of the AssociateBenefitApplicationResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ConflictException Thrown when the request conflicts with the current state of the resource, such as
     *         attempting to modify a resource that has been changed by another process.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.AssociateBenefitApplicationResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/AssociateBenefitApplicationResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateBenefitApplicationResourceResponse> associateBenefitApplicationResource(
            AssociateBenefitApplicationResourceRequest associateBenefitApplicationResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Links an AWS resource to an existing benefit application for tracking and management purposes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateBenefitApplicationResourceRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateBenefitApplicationResourceRequest#builder()}
     * </p>
     *
     * @param associateBenefitApplicationResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.AssociateBenefitApplicationResourceRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AssociateBenefitApplicationResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ConflictException Thrown when the request conflicts with the current state of the resource, such as
     *         attempting to modify a resource that has been changed by another process.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.AssociateBenefitApplicationResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/AssociateBenefitApplicationResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateBenefitApplicationResourceResponse> associateBenefitApplicationResource(
            Consumer<AssociateBenefitApplicationResourceRequest.Builder> associateBenefitApplicationResourceRequest) {
        return associateBenefitApplicationResource(AssociateBenefitApplicationResourceRequest.builder()
                .applyMutation(associateBenefitApplicationResourceRequest).build());
    }

    /**
     * <p>
     * Cancels a benefit application that is currently in progress, preventing further processing.
     * </p>
     *
     * @param cancelBenefitApplicationRequest
     * @return A Java Future containing the result of the CancelBenefitApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ConflictException Thrown when the request conflicts with the current state of the resource, such as
     *         attempting to modify a resource that has been changed by another process.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.CancelBenefitApplication
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/CancelBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelBenefitApplicationResponse> cancelBenefitApplication(
            CancelBenefitApplicationRequest cancelBenefitApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a benefit application that is currently in progress, preventing further processing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelBenefitApplicationRequest.Builder} avoiding
     * the need to create one manually via {@link CancelBenefitApplicationRequest#builder()}
     * </p>
     *
     * @param cancelBenefitApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.CancelBenefitApplicationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CancelBenefitApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ConflictException Thrown when the request conflicts with the current state of the resource, such as
     *         attempting to modify a resource that has been changed by another process.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.CancelBenefitApplication
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/CancelBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelBenefitApplicationResponse> cancelBenefitApplication(
            Consumer<CancelBenefitApplicationRequest.Builder> cancelBenefitApplicationRequest) {
        return cancelBenefitApplication(CancelBenefitApplicationRequest.builder().applyMutation(cancelBenefitApplicationRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new benefit application for a partner to request access to AWS benefits and programs.
     * </p>
     *
     * @param createBenefitApplicationRequest
     * @return A Java Future containing the result of the CreateBenefitApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ConflictException Thrown when the request conflicts with the current state of the resource, such as
     *         attempting to modify a resource that has been changed by another process.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.CreateBenefitApplication
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/CreateBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateBenefitApplicationResponse> createBenefitApplication(
            CreateBenefitApplicationRequest createBenefitApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new benefit application for a partner to request access to AWS benefits and programs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBenefitApplicationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateBenefitApplicationRequest#builder()}
     * </p>
     *
     * @param createBenefitApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.CreateBenefitApplicationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateBenefitApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ConflictException Thrown when the request conflicts with the current state of the resource, such as
     *         attempting to modify a resource that has been changed by another process.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.CreateBenefitApplication
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/CreateBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateBenefitApplicationResponse> createBenefitApplication(
            Consumer<CreateBenefitApplicationRequest.Builder> createBenefitApplicationRequest) {
        return createBenefitApplication(CreateBenefitApplicationRequest.builder().applyMutation(createBenefitApplicationRequest)
                .build());
    }

    /**
     * <p>
     * Removes the association between an AWS resource and a benefit application.
     * </p>
     *
     * @param disassociateBenefitApplicationResourceRequest
     * @return A Java Future containing the result of the DisassociateBenefitApplicationResource operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ConflictException Thrown when the request conflicts with the current state of the resource, such as
     *         attempting to modify a resource that has been changed by another process.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.DisassociateBenefitApplicationResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/DisassociateBenefitApplicationResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateBenefitApplicationResourceResponse> disassociateBenefitApplicationResource(
            DisassociateBenefitApplicationResourceRequest disassociateBenefitApplicationResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the association between an AWS resource and a benefit application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateBenefitApplicationResourceRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateBenefitApplicationResourceRequest#builder()}
     * </p>
     *
     * @param disassociateBenefitApplicationResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.DisassociateBenefitApplicationResourceRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisassociateBenefitApplicationResource operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ConflictException Thrown when the request conflicts with the current state of the resource, such as
     *         attempting to modify a resource that has been changed by another process.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.DisassociateBenefitApplicationResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/DisassociateBenefitApplicationResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateBenefitApplicationResourceResponse> disassociateBenefitApplicationResource(
            Consumer<DisassociateBenefitApplicationResourceRequest.Builder> disassociateBenefitApplicationResourceRequest) {
        return disassociateBenefitApplicationResource(DisassociateBenefitApplicationResourceRequest.builder()
                .applyMutation(disassociateBenefitApplicationResourceRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed information about a specific benefit available in the partner catalog.
     * </p>
     *
     * @param getBenefitRequest
     * @return A Java Future containing the result of the GetBenefit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.GetBenefit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/GetBenefit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBenefitResponse> getBenefit(GetBenefitRequest getBenefitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed information about a specific benefit available in the partner catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBenefitRequest.Builder} avoiding the need to
     * create one manually via {@link GetBenefitRequest#builder()}
     * </p>
     *
     * @param getBenefitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.GetBenefitRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetBenefit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.GetBenefit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/GetBenefit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBenefitResponse> getBenefit(Consumer<GetBenefitRequest.Builder> getBenefitRequest) {
        return getBenefit(GetBenefitRequest.builder().applyMutation(getBenefitRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed information about a specific benefit allocation that has been granted to a partner.
     * </p>
     *
     * @param getBenefitAllocationRequest
     * @return A Java Future containing the result of the GetBenefitAllocation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.GetBenefitAllocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/GetBenefitAllocation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBenefitAllocationResponse> getBenefitAllocation(
            GetBenefitAllocationRequest getBenefitAllocationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed information about a specific benefit allocation that has been granted to a partner.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBenefitAllocationRequest.Builder} avoiding the
     * need to create one manually via {@link GetBenefitAllocationRequest#builder()}
     * </p>
     *
     * @param getBenefitAllocationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.GetBenefitAllocationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetBenefitAllocation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.GetBenefitAllocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/GetBenefitAllocation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBenefitAllocationResponse> getBenefitAllocation(
            Consumer<GetBenefitAllocationRequest.Builder> getBenefitAllocationRequest) {
        return getBenefitAllocation(GetBenefitAllocationRequest.builder().applyMutation(getBenefitAllocationRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed information about a specific benefit application.
     * </p>
     *
     * @param getBenefitApplicationRequest
     * @return A Java Future containing the result of the GetBenefitApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ConflictException Thrown when the request conflicts with the current state of the resource, such as
     *         attempting to modify a resource that has been changed by another process.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.GetBenefitApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/GetBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBenefitApplicationResponse> getBenefitApplication(
            GetBenefitApplicationRequest getBenefitApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed information about a specific benefit application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBenefitApplicationRequest.Builder} avoiding the
     * need to create one manually via {@link GetBenefitApplicationRequest#builder()}
     * </p>
     *
     * @param getBenefitApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.GetBenefitApplicationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetBenefitApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ConflictException Thrown when the request conflicts with the current state of the resource, such as
     *         attempting to modify a resource that has been changed by another process.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.GetBenefitApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/GetBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBenefitApplicationResponse> getBenefitApplication(
            Consumer<GetBenefitApplicationRequest.Builder> getBenefitApplicationRequest) {
        return getBenefitApplication(GetBenefitApplicationRequest.builder().applyMutation(getBenefitApplicationRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of benefit allocations based on specified filter criteria.
     * </p>
     *
     * @param listBenefitAllocationsRequest
     * @return A Java Future containing the result of the ListBenefitAllocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.ListBenefitAllocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/ListBenefitAllocations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBenefitAllocationsResponse> listBenefitAllocations(
            ListBenefitAllocationsRequest listBenefitAllocationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of benefit allocations based on specified filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBenefitAllocationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBenefitAllocationsRequest#builder()}
     * </p>
     *
     * @param listBenefitAllocationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitAllocationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListBenefitAllocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.ListBenefitAllocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/ListBenefitAllocations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBenefitAllocationsResponse> listBenefitAllocations(
            Consumer<ListBenefitAllocationsRequest.Builder> listBenefitAllocationsRequest) {
        return listBenefitAllocations(ListBenefitAllocationsRequest.builder().applyMutation(listBenefitAllocationsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBenefitAllocations(software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitAllocationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitAllocationsPublisher publisher = client.listBenefitAllocationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitAllocationsPublisher publisher = client.listBenefitAllocationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitAllocationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitAllocationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBenefitAllocations(software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitAllocationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBenefitAllocationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.ListBenefitAllocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/ListBenefitAllocations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBenefitAllocationsPublisher listBenefitAllocationsPaginator(
            ListBenefitAllocationsRequest listBenefitAllocationsRequest) {
        return new ListBenefitAllocationsPublisher(this, listBenefitAllocationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBenefitAllocations(software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitAllocationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitAllocationsPublisher publisher = client.listBenefitAllocationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitAllocationsPublisher publisher = client.listBenefitAllocationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitAllocationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitAllocationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBenefitAllocations(software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitAllocationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBenefitAllocationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBenefitAllocationsRequest#builder()}
     * </p>
     *
     * @param listBenefitAllocationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitAllocationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.ListBenefitAllocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/ListBenefitAllocations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBenefitAllocationsPublisher listBenefitAllocationsPaginator(
            Consumer<ListBenefitAllocationsRequest.Builder> listBenefitAllocationsRequest) {
        return listBenefitAllocationsPaginator(ListBenefitAllocationsRequest.builder()
                .applyMutation(listBenefitAllocationsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of benefit applications based on specified filter criteria.
     * </p>
     *
     * @param listBenefitApplicationsRequest
     * @return A Java Future containing the result of the ListBenefitApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.ListBenefitApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/ListBenefitApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBenefitApplicationsResponse> listBenefitApplications(
            ListBenefitApplicationsRequest listBenefitApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of benefit applications based on specified filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBenefitApplicationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListBenefitApplicationsRequest#builder()}
     * </p>
     *
     * @param listBenefitApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitApplicationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListBenefitApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.ListBenefitApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/ListBenefitApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBenefitApplicationsResponse> listBenefitApplications(
            Consumer<ListBenefitApplicationsRequest.Builder> listBenefitApplicationsRequest) {
        return listBenefitApplications(ListBenefitApplicationsRequest.builder().applyMutation(listBenefitApplicationsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBenefitApplications(software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitApplicationsPublisher publisher = client.listBenefitApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitApplicationsPublisher publisher = client.listBenefitApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBenefitApplications(software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBenefitApplicationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.ListBenefitApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/ListBenefitApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBenefitApplicationsPublisher listBenefitApplicationsPaginator(
            ListBenefitApplicationsRequest listBenefitApplicationsRequest) {
        return new ListBenefitApplicationsPublisher(this, listBenefitApplicationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBenefitApplications(software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitApplicationsPublisher publisher = client.listBenefitApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitApplicationsPublisher publisher = client.listBenefitApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBenefitApplications(software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitApplicationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBenefitApplicationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListBenefitApplicationsRequest#builder()}
     * </p>
     *
     * @param listBenefitApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitApplicationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.ListBenefitApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/ListBenefitApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBenefitApplicationsPublisher listBenefitApplicationsPaginator(
            Consumer<ListBenefitApplicationsRequest.Builder> listBenefitApplicationsRequest) {
        return listBenefitApplicationsPaginator(ListBenefitApplicationsRequest.builder()
                .applyMutation(listBenefitApplicationsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of available benefits based on specified filter criteria.
     * </p>
     *
     * @param listBenefitsRequest
     * @return A Java Future containing the result of the ListBenefits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.ListBenefits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/ListBenefits"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBenefitsResponse> listBenefits(ListBenefitsRequest listBenefitsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of available benefits based on specified filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBenefitsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBenefitsRequest#builder()}
     * </p>
     *
     * @param listBenefitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListBenefits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.ListBenefits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/ListBenefits"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBenefitsResponse> listBenefits(Consumer<ListBenefitsRequest.Builder> listBenefitsRequest) {
        return listBenefits(ListBenefitsRequest.builder().applyMutation(listBenefitsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBenefits(software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitsPublisher publisher = client.listBenefitsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitsPublisher publisher = client.listBenefitsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBenefits(software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBenefitsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.ListBenefits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/ListBenefits"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBenefitsPublisher listBenefitsPaginator(ListBenefitsRequest listBenefitsRequest) {
        return new ListBenefitsPublisher(this, listBenefitsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBenefits(software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitsPublisher publisher = client.listBenefitsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralbenefits.paginators.ListBenefitsPublisher publisher = client.listBenefitsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBenefits(software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBenefitsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBenefitsRequest#builder()}
     * </p>
     *
     * @param listBenefitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.ListBenefits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/ListBenefits"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBenefitsPublisher listBenefitsPaginator(Consumer<ListBenefitsRequest.Builder> listBenefitsRequest) {
        return listBenefitsPaginator(ListBenefitsRequest.builder().applyMutation(listBenefitsRequest).build());
    }

    /**
     * <p>
     * Retrieves all tags associated with a specific resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all tags associated with a specific resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Recalls a submitted benefit application, returning it to draft status for further modifications.
     * </p>
     *
     * @param recallBenefitApplicationRequest
     * @return A Java Future containing the result of the RecallBenefitApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ConflictException Thrown when the request conflicts with the current state of the resource, such as
     *         attempting to modify a resource that has been changed by another process.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.RecallBenefitApplication
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/RecallBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RecallBenefitApplicationResponse> recallBenefitApplication(
            RecallBenefitApplicationRequest recallBenefitApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Recalls a submitted benefit application, returning it to draft status for further modifications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RecallBenefitApplicationRequest.Builder} avoiding
     * the need to create one manually via {@link RecallBenefitApplicationRequest#builder()}
     * </p>
     *
     * @param recallBenefitApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.RecallBenefitApplicationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the RecallBenefitApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ConflictException Thrown when the request conflicts with the current state of the resource, such as
     *         attempting to modify a resource that has been changed by another process.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.RecallBenefitApplication
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/RecallBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RecallBenefitApplicationResponse> recallBenefitApplication(
            Consumer<RecallBenefitApplicationRequest.Builder> recallBenefitApplicationRequest) {
        return recallBenefitApplication(RecallBenefitApplicationRequest.builder().applyMutation(recallBenefitApplicationRequest)
                .build());
    }

    /**
     * <p>
     * Submits a benefit application for review and processing by AWS.
     * </p>
     *
     * @param submitBenefitApplicationRequest
     * @return A Java Future containing the result of the SubmitBenefitApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ConflictException Thrown when the request conflicts with the current state of the resource, such as
     *         attempting to modify a resource that has been changed by another process.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.SubmitBenefitApplication
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/SubmitBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SubmitBenefitApplicationResponse> submitBenefitApplication(
            SubmitBenefitApplicationRequest submitBenefitApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Submits a benefit application for review and processing by AWS.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SubmitBenefitApplicationRequest.Builder} avoiding
     * the need to create one manually via {@link SubmitBenefitApplicationRequest#builder()}
     * </p>
     *
     * @param submitBenefitApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.SubmitBenefitApplicationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the SubmitBenefitApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ConflictException Thrown when the request conflicts with the current state of the resource, such as
     *         attempting to modify a resource that has been changed by another process.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.SubmitBenefitApplication
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/SubmitBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SubmitBenefitApplicationResponse> submitBenefitApplication(
            Consumer<SubmitBenefitApplicationRequest.Builder> submitBenefitApplicationRequest) {
        return submitBenefitApplication(SubmitBenefitApplicationRequest.builder().applyMutation(submitBenefitApplicationRequest)
                .build());
    }

    /**
     * <p>
     * Adds or updates tags for a specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ConflictException Thrown when the request conflicts with the current state of the resource, such as
     *         attempting to modify a resource that has been changed by another process.</li>
     *         <li>ServiceQuotaExceededException Thrown when the request would exceed the service quotas or limits for
     *         the account.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates tags for a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.TagResourceRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ConflictException Thrown when the request conflicts with the current state of the resource, such as
     *         attempting to modify a resource that has been changed by another process.</li>
     *         <li>ServiceQuotaExceededException Thrown when the request would exceed the service quotas or limits for
     *         the account.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes specified tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ConflictException Thrown when the request conflicts with the current state of the resource, such as
     *         attempting to modify a resource that has been changed by another process.</li>
     *         <li>ServiceQuotaExceededException Thrown when the request would exceed the service quotas or limits for
     *         the account.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes specified tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.UntagResourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ConflictException Thrown when the request conflicts with the current state of the resource, such as
     *         attempting to modify a resource that has been changed by another process.</li>
     *         <li>ServiceQuotaExceededException Thrown when the request would exceed the service quotas or limits for
     *         the account.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing benefit application with new information while maintaining revision control.
     * </p>
     *
     * @param updateBenefitApplicationRequest
     * @return A Java Future containing the result of the UpdateBenefitApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ConflictException Thrown when the request conflicts with the current state of the resource, such as
     *         attempting to modify a resource that has been changed by another process.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.UpdateBenefitApplication
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/UpdateBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateBenefitApplicationResponse> updateBenefitApplication(
            UpdateBenefitApplicationRequest updateBenefitApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing benefit application with new information while maintaining revision control.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBenefitApplicationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateBenefitApplicationRequest#builder()}
     * </p>
     *
     * @param updateBenefitApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.UpdateBenefitApplicationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateBenefitApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Thrown when the request contains invalid parameters or fails input validation
     *         requirements.</li>
     *         <li>AccessDeniedException Thrown when the caller does not have sufficient permissions to perform the
     *         requested operation.</li>
     *         <li>InternalServerException Thrown when an unexpected error occurs on the server side during request
     *         processing.</li>
     *         <li>ConflictException Thrown when the request conflicts with the current state of the resource, such as
     *         attempting to modify a resource that has been changed by another process.</li>
     *         <li>ResourceNotFoundException Thrown when the requested resource cannot be found or does not exist.</li>
     *         <li>ThrottlingException Thrown when the request rate exceeds the allowed limits and the request is being
     *         throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralBenefitsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralBenefitsAsyncClient.UpdateBenefitApplication
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/UpdateBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateBenefitApplicationResponse> updateBenefitApplication(
            Consumer<UpdateBenefitApplicationRequest.Builder> updateBenefitApplicationRequest) {
        return updateBenefitApplication(UpdateBenefitApplicationRequest.builder().applyMutation(updateBenefitApplicationRequest)
                .build());
    }

    @Override
    default PartnerCentralBenefitsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link PartnerCentralBenefitsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static PartnerCentralBenefitsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link PartnerCentralBenefitsAsyncClient}.
     */
    static PartnerCentralBenefitsAsyncClientBuilder builder() {
        return new DefaultPartnerCentralBenefitsAsyncClientBuilder();
    }
}
