/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralbenefits;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.partnercentralbenefits.internal.PartnerCentralBenefitsServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.partnercentralbenefits.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.partnercentralbenefits.model.AccessDeniedException;
import software.amazon.awssdk.services.partnercentralbenefits.model.AmendBenefitApplicationRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.AmendBenefitApplicationResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.AssociateBenefitApplicationResourceRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.AssociateBenefitApplicationResourceResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.CancelBenefitApplicationRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.CancelBenefitApplicationResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.ConflictException;
import software.amazon.awssdk.services.partnercentralbenefits.model.CreateBenefitApplicationRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.CreateBenefitApplicationResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.DisassociateBenefitApplicationResourceRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.DisassociateBenefitApplicationResourceResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.GetBenefitAllocationRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.GetBenefitAllocationResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.GetBenefitApplicationRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.GetBenefitApplicationResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.GetBenefitRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.GetBenefitResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.InternalServerException;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitAllocationsRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitAllocationsResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitApplicationsRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitApplicationsResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitsRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitsResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.PartnerCentralBenefitsException;
import software.amazon.awssdk.services.partnercentralbenefits.model.RecallBenefitApplicationRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.RecallBenefitApplicationResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.ResourceNotFoundException;
import software.amazon.awssdk.services.partnercentralbenefits.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.partnercentralbenefits.model.SubmitBenefitApplicationRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.SubmitBenefitApplicationResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.TagResourceRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.TagResourceResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.ThrottlingException;
import software.amazon.awssdk.services.partnercentralbenefits.model.UntagResourceRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.UntagResourceResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.UpdateBenefitApplicationRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.UpdateBenefitApplicationResponse;
import software.amazon.awssdk.services.partnercentralbenefits.model.ValidationException;
import software.amazon.awssdk.services.partnercentralbenefits.transform.AmendBenefitApplicationRequestMarshaller;
import software.amazon.awssdk.services.partnercentralbenefits.transform.AssociateBenefitApplicationResourceRequestMarshaller;
import software.amazon.awssdk.services.partnercentralbenefits.transform.CancelBenefitApplicationRequestMarshaller;
import software.amazon.awssdk.services.partnercentralbenefits.transform.CreateBenefitApplicationRequestMarshaller;
import software.amazon.awssdk.services.partnercentralbenefits.transform.DisassociateBenefitApplicationResourceRequestMarshaller;
import software.amazon.awssdk.services.partnercentralbenefits.transform.GetBenefitAllocationRequestMarshaller;
import software.amazon.awssdk.services.partnercentralbenefits.transform.GetBenefitApplicationRequestMarshaller;
import software.amazon.awssdk.services.partnercentralbenefits.transform.GetBenefitRequestMarshaller;
import software.amazon.awssdk.services.partnercentralbenefits.transform.ListBenefitAllocationsRequestMarshaller;
import software.amazon.awssdk.services.partnercentralbenefits.transform.ListBenefitApplicationsRequestMarshaller;
import software.amazon.awssdk.services.partnercentralbenefits.transform.ListBenefitsRequestMarshaller;
import software.amazon.awssdk.services.partnercentralbenefits.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.partnercentralbenefits.transform.RecallBenefitApplicationRequestMarshaller;
import software.amazon.awssdk.services.partnercentralbenefits.transform.SubmitBenefitApplicationRequestMarshaller;
import software.amazon.awssdk.services.partnercentralbenefits.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.partnercentralbenefits.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.partnercentralbenefits.transform.UpdateBenefitApplicationRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link PartnerCentralBenefitsClient}.
 *
 * @see PartnerCentralBenefitsClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultPartnerCentralBenefitsClient implements PartnerCentralBenefitsClient {
    private static final Logger log = Logger.loggerFor(DefaultPartnerCentralBenefitsClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultPartnerCentralBenefitsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "PartnerCentral_Benefits" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Modifies an existing benefit application by applying amendments to specific fields while maintaining revision
     * control.
     * </p>
     *
     * @param amendBenefitApplicationRequest
     * @return Result of the AmendBenefitApplication operation returned by the service.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ConflictException
     *         Thrown when the request conflicts with the current state of the resource, such as attempting to modify a
     *         resource that has been changed by another process.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.AmendBenefitApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/AmendBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AmendBenefitApplicationResponse amendBenefitApplication(AmendBenefitApplicationRequest amendBenefitApplicationRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ConflictException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralBenefitsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AmendBenefitApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AmendBenefitApplicationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(amendBenefitApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, amendBenefitApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Benefits");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AmendBenefitApplication");

            return clientHandler
                    .execute(new ClientExecutionParams<AmendBenefitApplicationRequest, AmendBenefitApplicationResponse>()
                            .withOperationName("AmendBenefitApplication").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(amendBenefitApplicationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AmendBenefitApplicationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Links an AWS resource to an existing benefit application for tracking and management purposes.
     * </p>
     *
     * @param associateBenefitApplicationResourceRequest
     * @return Result of the AssociateBenefitApplicationResource operation returned by the service.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ConflictException
     *         Thrown when the request conflicts with the current state of the resource, such as attempting to modify a
     *         resource that has been changed by another process.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.AssociateBenefitApplicationResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/AssociateBenefitApplicationResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateBenefitApplicationResourceResponse associateBenefitApplicationResource(
            AssociateBenefitApplicationResourceRequest associateBenefitApplicationResourceRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ConflictException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralBenefitsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateBenefitApplicationResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateBenefitApplicationResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateBenefitApplicationResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateBenefitApplicationResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Benefits");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateBenefitApplicationResource");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateBenefitApplicationResourceRequest, AssociateBenefitApplicationResourceResponse>()
                            .withOperationName("AssociateBenefitApplicationResource").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateBenefitApplicationResourceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateBenefitApplicationResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels a benefit application that is currently in progress, preventing further processing.
     * </p>
     *
     * @param cancelBenefitApplicationRequest
     * @return Result of the CancelBenefitApplication operation returned by the service.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ConflictException
     *         Thrown when the request conflicts with the current state of the resource, such as attempting to modify a
     *         resource that has been changed by another process.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.CancelBenefitApplication
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/CancelBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CancelBenefitApplicationResponse cancelBenefitApplication(
            CancelBenefitApplicationRequest cancelBenefitApplicationRequest) throws ValidationException, AccessDeniedException,
            InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, PartnerCentralBenefitsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelBenefitApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CancelBenefitApplicationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelBenefitApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelBenefitApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Benefits");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelBenefitApplication");

            return clientHandler
                    .execute(new ClientExecutionParams<CancelBenefitApplicationRequest, CancelBenefitApplicationResponse>()
                            .withOperationName("CancelBenefitApplication").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(cancelBenefitApplicationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CancelBenefitApplicationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new benefit application for a partner to request access to AWS benefits and programs.
     * </p>
     *
     * @param createBenefitApplicationRequest
     * @return Result of the CreateBenefitApplication operation returned by the service.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ConflictException
     *         Thrown when the request conflicts with the current state of the resource, such as attempting to modify a
     *         resource that has been changed by another process.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.CreateBenefitApplication
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/CreateBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateBenefitApplicationResponse createBenefitApplication(
            CreateBenefitApplicationRequest createBenefitApplicationRequest) throws ValidationException, AccessDeniedException,
            InternalServerException, ConflictException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, PartnerCentralBenefitsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBenefitApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateBenefitApplicationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBenefitApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBenefitApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Benefits");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBenefitApplication");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateBenefitApplicationRequest, CreateBenefitApplicationResponse>()
                            .withOperationName("CreateBenefitApplication").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createBenefitApplicationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateBenefitApplicationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the association between an AWS resource and a benefit application.
     * </p>
     *
     * @param disassociateBenefitApplicationResourceRequest
     * @return Result of the DisassociateBenefitApplicationResource operation returned by the service.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ConflictException
     *         Thrown when the request conflicts with the current state of the resource, such as attempting to modify a
     *         resource that has been changed by another process.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.DisassociateBenefitApplicationResource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/DisassociateBenefitApplicationResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateBenefitApplicationResourceResponse disassociateBenefitApplicationResource(
            DisassociateBenefitApplicationResourceRequest disassociateBenefitApplicationResourceRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ConflictException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralBenefitsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateBenefitApplicationResourceResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DisassociateBenefitApplicationResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateBenefitApplicationResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateBenefitApplicationResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Benefits");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateBenefitApplicationResource");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateBenefitApplicationResourceRequest, DisassociateBenefitApplicationResourceResponse>()
                            .withOperationName("DisassociateBenefitApplicationResource").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(disassociateBenefitApplicationResourceRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateBenefitApplicationResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves detailed information about a specific benefit available in the partner catalog.
     * </p>
     *
     * @param getBenefitRequest
     * @return Result of the GetBenefit operation returned by the service.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.GetBenefit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/GetBenefit"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetBenefitResponse getBenefit(GetBenefitRequest getBenefitRequest) throws ValidationException, AccessDeniedException,
            InternalServerException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralBenefitsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetBenefitResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetBenefitResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBenefitRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBenefitRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Benefits");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBenefit");

            return clientHandler.execute(new ClientExecutionParams<GetBenefitRequest, GetBenefitResponse>()
                    .withOperationName("GetBenefit").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getBenefitRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetBenefitRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves detailed information about a specific benefit allocation that has been granted to a partner.
     * </p>
     *
     * @param getBenefitAllocationRequest
     * @return Result of the GetBenefitAllocation operation returned by the service.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.GetBenefitAllocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/GetBenefitAllocation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetBenefitAllocationResponse getBenefitAllocation(GetBenefitAllocationRequest getBenefitAllocationRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, PartnerCentralBenefitsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetBenefitAllocationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetBenefitAllocationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBenefitAllocationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBenefitAllocationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Benefits");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBenefitAllocation");

            return clientHandler.execute(new ClientExecutionParams<GetBenefitAllocationRequest, GetBenefitAllocationResponse>()
                    .withOperationName("GetBenefitAllocation").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getBenefitAllocationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetBenefitAllocationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves detailed information about a specific benefit application.
     * </p>
     *
     * @param getBenefitApplicationRequest
     * @return Result of the GetBenefitApplication operation returned by the service.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ConflictException
     *         Thrown when the request conflicts with the current state of the resource, such as attempting to modify a
     *         resource that has been changed by another process.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.GetBenefitApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/GetBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetBenefitApplicationResponse getBenefitApplication(GetBenefitApplicationRequest getBenefitApplicationRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ConflictException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            PartnerCentralBenefitsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetBenefitApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetBenefitApplicationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBenefitApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBenefitApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Benefits");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBenefitApplication");

            return clientHandler.execute(new ClientExecutionParams<GetBenefitApplicationRequest, GetBenefitApplicationResponse>()
                    .withOperationName("GetBenefitApplication").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getBenefitApplicationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetBenefitApplicationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a paginated list of benefit allocations based on specified filter criteria.
     * </p>
     *
     * @param listBenefitAllocationsRequest
     * @return Result of the ListBenefitAllocations operation returned by the service.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.ListBenefitAllocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/ListBenefitAllocations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListBenefitAllocationsResponse listBenefitAllocations(ListBenefitAllocationsRequest listBenefitAllocationsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, PartnerCentralBenefitsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBenefitAllocationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListBenefitAllocationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBenefitAllocationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBenefitAllocationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Benefits");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBenefitAllocations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListBenefitAllocationsRequest, ListBenefitAllocationsResponse>()
                            .withOperationName("ListBenefitAllocations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listBenefitAllocationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListBenefitAllocationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a paginated list of benefit applications based on specified filter criteria.
     * </p>
     *
     * @param listBenefitApplicationsRequest
     * @return Result of the ListBenefitApplications operation returned by the service.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.ListBenefitApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/ListBenefitApplications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListBenefitApplicationsResponse listBenefitApplications(ListBenefitApplicationsRequest listBenefitApplicationsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralBenefitsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBenefitApplicationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListBenefitApplicationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBenefitApplicationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBenefitApplicationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Benefits");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBenefitApplications");

            return clientHandler
                    .execute(new ClientExecutionParams<ListBenefitApplicationsRequest, ListBenefitApplicationsResponse>()
                            .withOperationName("ListBenefitApplications").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listBenefitApplicationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListBenefitApplicationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a paginated list of available benefits based on specified filter criteria.
     * </p>
     *
     * @param listBenefitsRequest
     * @return Result of the ListBenefits operation returned by the service.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.ListBenefits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/ListBenefits"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListBenefitsResponse listBenefits(ListBenefitsRequest listBenefitsRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, PartnerCentralBenefitsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBenefitsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListBenefitsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBenefitsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBenefitsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Benefits");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBenefits");

            return clientHandler.execute(new ClientExecutionParams<ListBenefitsRequest, ListBenefitsResponse>()
                    .withOperationName("ListBenefits").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listBenefitsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListBenefitsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves all tags associated with a specific resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralBenefitsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Benefits");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Recalls a submitted benefit application, returning it to draft status for further modifications.
     * </p>
     *
     * @param recallBenefitApplicationRequest
     * @return Result of the RecallBenefitApplication operation returned by the service.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ConflictException
     *         Thrown when the request conflicts with the current state of the resource, such as attempting to modify a
     *         resource that has been changed by another process.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.RecallBenefitApplication
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/RecallBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RecallBenefitApplicationResponse recallBenefitApplication(
            RecallBenefitApplicationRequest recallBenefitApplicationRequest) throws ValidationException, AccessDeniedException,
            InternalServerException, ConflictException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, PartnerCentralBenefitsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RecallBenefitApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RecallBenefitApplicationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(recallBenefitApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, recallBenefitApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Benefits");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RecallBenefitApplication");

            return clientHandler
                    .execute(new ClientExecutionParams<RecallBenefitApplicationRequest, RecallBenefitApplicationResponse>()
                            .withOperationName("RecallBenefitApplication").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(recallBenefitApplicationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RecallBenefitApplicationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Submits a benefit application for review and processing by AWS.
     * </p>
     *
     * @param submitBenefitApplicationRequest
     * @return Result of the SubmitBenefitApplication operation returned by the service.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ConflictException
     *         Thrown when the request conflicts with the current state of the resource, such as attempting to modify a
     *         resource that has been changed by another process.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.SubmitBenefitApplication
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/SubmitBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SubmitBenefitApplicationResponse submitBenefitApplication(
            SubmitBenefitApplicationRequest submitBenefitApplicationRequest) throws AccessDeniedException, ValidationException,
            InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, PartnerCentralBenefitsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SubmitBenefitApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, SubmitBenefitApplicationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(submitBenefitApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, submitBenefitApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Benefits");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SubmitBenefitApplication");

            return clientHandler
                    .execute(new ClientExecutionParams<SubmitBenefitApplicationRequest, SubmitBenefitApplicationResponse>()
                            .withOperationName("SubmitBenefitApplication").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(submitBenefitApplicationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new SubmitBenefitApplicationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds or updates tags for a specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ConflictException
     *         Thrown when the request conflicts with the current state of the resource, such as attempting to modify a
     *         resource that has been changed by another process.
     * @throws ServiceQuotaExceededException
     *         Thrown when the request would exceed the service quotas or limits for the account.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            PartnerCentralBenefitsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Benefits");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes specified tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ConflictException
     *         Thrown when the request conflicts with the current state of the resource, such as attempting to modify a
     *         resource that has been changed by another process.
     * @throws ServiceQuotaExceededException
     *         Thrown when the request would exceed the service quotas or limits for the account.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            PartnerCentralBenefitsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Benefits");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing benefit application with new information while maintaining revision control.
     * </p>
     *
     * @param updateBenefitApplicationRequest
     * @return Result of the UpdateBenefitApplication operation returned by the service.
     * @throws ValidationException
     *         Thrown when the request contains invalid parameters or fails input validation requirements.
     * @throws AccessDeniedException
     *         Thrown when the caller does not have sufficient permissions to perform the requested operation.
     * @throws InternalServerException
     *         Thrown when an unexpected error occurs on the server side during request processing.
     * @throws ConflictException
     *         Thrown when the request conflicts with the current state of the resource, such as attempting to modify a
     *         resource that has been changed by another process.
     * @throws ResourceNotFoundException
     *         Thrown when the requested resource cannot be found or does not exist.
     * @throws ThrottlingException
     *         Thrown when the request rate exceeds the allowed limits and the request is being throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralBenefitsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralBenefitsClient.UpdateBenefitApplication
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-benefits-2018-05-10/UpdateBenefitApplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateBenefitApplicationResponse updateBenefitApplication(
            UpdateBenefitApplicationRequest updateBenefitApplicationRequest) throws ValidationException, AccessDeniedException,
            InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, PartnerCentralBenefitsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateBenefitApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateBenefitApplicationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateBenefitApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBenefitApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Benefits");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBenefitApplication");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateBenefitApplicationRequest, UpdateBenefitApplicationResponse>()
                            .withOperationName("UpdateBenefitApplication").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateBenefitApplicationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateBenefitApplicationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        PartnerCentralBenefitsServiceClientConfigurationBuilder serviceConfigBuilder = new PartnerCentralBenefitsServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder.clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(PartnerCentralBenefitsException::builder).protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.0");
    }

    @Override
    public final PartnerCentralBenefitsServiceClientConfiguration serviceClientConfiguration() {
        return new PartnerCentralBenefitsServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
