/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralaccount.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralaccount.model.PartnerCentralAccountResponse;
import software.amazon.awssdk.services.partnercentralaccount.model.PartnerDomain;
import software.amazon.awssdk.services.partnercentralaccount.model.PartnerDomainListCopier;
import software.amazon.awssdk.services.partnercentralaccount.model.PartnerProfile;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPartnerResponse
extends PartnerCentralAccountResponse
implements ToCopyableBuilder<Builder, GetPartnerResponse> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(GetPartnerResponse.getter(GetPartnerResponse::catalog)).setter(GetPartnerResponse.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetPartnerResponse.getter(GetPartnerResponse::arn)).setter(GetPartnerResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(GetPartnerResponse.getter(GetPartnerResponse::id)).setter(GetPartnerResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> LEGAL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LegalName").getter(GetPartnerResponse.getter(GetPartnerResponse::legalName)).setter(GetPartnerResponse.setter(Builder::legalName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LegalName").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(GetPartnerResponse.getter(GetPartnerResponse::createdAt)).setter(GetPartnerResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<PartnerProfile> PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Profile").getter(GetPartnerResponse.getter(GetPartnerResponse::profile)).setter(GetPartnerResponse.setter(Builder::profile)).constructor(PartnerProfile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Profile").build()}).build();
    private static final SdkField<List<PartnerDomain>> AWS_TRAINING_CERTIFICATION_EMAIL_DOMAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AwsTrainingCertificationEmailDomains").getter(GetPartnerResponse.getter(GetPartnerResponse::awsTrainingCertificationEmailDomains)).setter(GetPartnerResponse.setter(Builder::awsTrainingCertificationEmailDomains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsTrainingCertificationEmailDomains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PartnerDomain::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, ARN_FIELD, ID_FIELD, LEGAL_NAME_FIELD, CREATED_AT_FIELD, PROFILE_FIELD, AWS_TRAINING_CERTIFICATION_EMAIL_DOMAINS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetPartnerResponse.memberNameToFieldInitializer();
    private final String catalog;
    private final String arn;
    private final String id;
    private final String legalName;
    private final Instant createdAt;
    private final PartnerProfile profile;
    private final List<PartnerDomain> awsTrainingCertificationEmailDomains;

    private GetPartnerResponse(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.arn = builder.arn;
        this.id = builder.id;
        this.legalName = builder.legalName;
        this.createdAt = builder.createdAt;
        this.profile = builder.profile;
        this.awsTrainingCertificationEmailDomains = builder.awsTrainingCertificationEmailDomains;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final String legalName() {
        return this.legalName;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final PartnerProfile profile() {
        return this.profile;
    }

    public final boolean hasAwsTrainingCertificationEmailDomains() {
        return this.awsTrainingCertificationEmailDomains != null && !(this.awsTrainingCertificationEmailDomains instanceof SdkAutoConstructList);
    }

    public final List<PartnerDomain> awsTrainingCertificationEmailDomains() {
        return this.awsTrainingCertificationEmailDomains;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.legalName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.profile());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAwsTrainingCertificationEmailDomains() ? this.awsTrainingCertificationEmailDomains() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPartnerResponse)) {
            return false;
        }
        GetPartnerResponse other = (GetPartnerResponse)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.legalName(), other.legalName()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.profile(), other.profile()) && this.hasAwsTrainingCertificationEmailDomains() == other.hasAwsTrainingCertificationEmailDomains() && Objects.equals(this.awsTrainingCertificationEmailDomains(), other.awsTrainingCertificationEmailDomains());
    }

    public final String toString() {
        return ToString.builder((String)"GetPartnerResponse").add("Catalog", (Object)this.catalog()).add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("LegalName", (Object)(this.legalName() == null ? null : "*** Sensitive Data Redacted ***")).add("CreatedAt", (Object)this.createdAt()).add("Profile", (Object)this.profile()).add("AwsTrainingCertificationEmailDomains", this.hasAwsTrainingCertificationEmailDomains() ? this.awsTrainingCertificationEmailDomains() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "LegalName": {
                return Optional.ofNullable(clazz.cast(this.legalName()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "Profile": {
                return Optional.ofNullable(clazz.cast(this.profile()));
            }
            case "AwsTrainingCertificationEmailDomains": {
                return Optional.ofNullable(clazz.cast(this.awsTrainingCertificationEmailDomains()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Id", ID_FIELD);
        map.put("LegalName", LEGAL_NAME_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("Profile", PROFILE_FIELD);
        map.put("AwsTrainingCertificationEmailDomains", AWS_TRAINING_CERTIFICATION_EMAIL_DOMAINS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPartnerResponse, T> g) {
        return obj -> g.apply((GetPartnerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralAccountResponse.BuilderImpl
    implements Builder {
        private String catalog;
        private String arn;
        private String id;
        private String legalName;
        private Instant createdAt;
        private PartnerProfile profile;
        private List<PartnerDomain> awsTrainingCertificationEmailDomains = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPartnerResponse model) {
            super(model);
            this.catalog(model.catalog);
            this.arn(model.arn);
            this.id(model.id);
            this.legalName(model.legalName);
            this.createdAt(model.createdAt);
            this.profile(model.profile);
            this.awsTrainingCertificationEmailDomains(model.awsTrainingCertificationEmailDomains);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getLegalName() {
            return this.legalName;
        }

        public final void setLegalName(String legalName) {
            this.legalName = legalName;
        }

        @Override
        public final Builder legalName(String legalName) {
            this.legalName = legalName;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final PartnerProfile.Builder getProfile() {
            return this.profile != null ? this.profile.toBuilder() : null;
        }

        public final void setProfile(PartnerProfile.BuilderImpl profile) {
            this.profile = profile != null ? profile.build() : null;
        }

        @Override
        public final Builder profile(PartnerProfile profile) {
            this.profile = profile;
            return this;
        }

        public final List<PartnerDomain.Builder> getAwsTrainingCertificationEmailDomains() {
            List<PartnerDomain.Builder> result = PartnerDomainListCopier.copyToBuilder(this.awsTrainingCertificationEmailDomains);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAwsTrainingCertificationEmailDomains(Collection<PartnerDomain.BuilderImpl> awsTrainingCertificationEmailDomains) {
            this.awsTrainingCertificationEmailDomains = PartnerDomainListCopier.copyFromBuilder(awsTrainingCertificationEmailDomains);
        }

        @Override
        public final Builder awsTrainingCertificationEmailDomains(Collection<PartnerDomain> awsTrainingCertificationEmailDomains) {
            this.awsTrainingCertificationEmailDomains = PartnerDomainListCopier.copy(awsTrainingCertificationEmailDomains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsTrainingCertificationEmailDomains(PartnerDomain ... awsTrainingCertificationEmailDomains) {
            this.awsTrainingCertificationEmailDomains(Arrays.asList(awsTrainingCertificationEmailDomains));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsTrainingCertificationEmailDomains(Consumer<PartnerDomain.Builder> ... awsTrainingCertificationEmailDomains) {
            this.awsTrainingCertificationEmailDomains(Stream.of(awsTrainingCertificationEmailDomains).map(c -> (PartnerDomain)((PartnerDomain.Builder)PartnerDomain.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetPartnerResponse build() {
            return new GetPartnerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralAccountResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPartnerResponse> {
        public Builder catalog(String var1);

        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder legalName(String var1);

        public Builder createdAt(Instant var1);

        public Builder profile(PartnerProfile var1);

        default public Builder profile(Consumer<PartnerProfile.Builder> profile) {
            return this.profile((PartnerProfile)((PartnerProfile.Builder)PartnerProfile.builder().applyMutation(profile)).build());
        }

        public Builder awsTrainingCertificationEmailDomains(Collection<PartnerDomain> var1);

        public Builder awsTrainingCertificationEmailDomains(PartnerDomain ... var1);

        public Builder awsTrainingCertificationEmailDomains(Consumer<PartnerDomain.Builder> ... var1);
    }
}

