/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralaccount.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegistrantVerificationResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RegistrantVerificationResponse> {
    private static final SdkField<String> COMPLETION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompletionUrl").getter(RegistrantVerificationResponse.getter(RegistrantVerificationResponse::completionUrl)).setter(RegistrantVerificationResponse.setter(Builder::completionUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionUrl").build()}).build();
    private static final SdkField<Instant> COMPLETION_URL_EXPIRES_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletionUrlExpiresAt").getter(RegistrantVerificationResponse.getter(RegistrantVerificationResponse::completionUrlExpiresAt)).setter(RegistrantVerificationResponse.setter(Builder::completionUrlExpiresAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionUrlExpiresAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETION_URL_FIELD, COMPLETION_URL_EXPIRES_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RegistrantVerificationResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String completionUrl;
    private final Instant completionUrlExpiresAt;

    private RegistrantVerificationResponse(BuilderImpl builder) {
        this.completionUrl = builder.completionUrl;
        this.completionUrlExpiresAt = builder.completionUrlExpiresAt;
    }

    public final String completionUrl() {
        return this.completionUrl;
    }

    public final Instant completionUrlExpiresAt() {
        return this.completionUrlExpiresAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.completionUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionUrlExpiresAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegistrantVerificationResponse)) {
            return false;
        }
        RegistrantVerificationResponse other = (RegistrantVerificationResponse)obj;
        return Objects.equals(this.completionUrl(), other.completionUrl()) && Objects.equals(this.completionUrlExpiresAt(), other.completionUrlExpiresAt());
    }

    public final String toString() {
        return ToString.builder((String)"RegistrantVerificationResponse").add("CompletionUrl", (Object)this.completionUrl()).add("CompletionUrlExpiresAt", (Object)this.completionUrlExpiresAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CompletionUrl": {
                return Optional.ofNullable(clazz.cast(this.completionUrl()));
            }
            case "CompletionUrlExpiresAt": {
                return Optional.ofNullable(clazz.cast(this.completionUrlExpiresAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CompletionUrl", COMPLETION_URL_FIELD);
        map.put("CompletionUrlExpiresAt", COMPLETION_URL_EXPIRES_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegistrantVerificationResponse, T> g) {
        return obj -> g.apply((RegistrantVerificationResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String completionUrl;
        private Instant completionUrlExpiresAt;

        private BuilderImpl() {
        }

        private BuilderImpl(RegistrantVerificationResponse model) {
            this.completionUrl(model.completionUrl);
            this.completionUrlExpiresAt(model.completionUrlExpiresAt);
        }

        public final String getCompletionUrl() {
            return this.completionUrl;
        }

        public final void setCompletionUrl(String completionUrl) {
            this.completionUrl = completionUrl;
        }

        @Override
        public final Builder completionUrl(String completionUrl) {
            this.completionUrl = completionUrl;
            return this;
        }

        public final Instant getCompletionUrlExpiresAt() {
            return this.completionUrlExpiresAt;
        }

        public final void setCompletionUrlExpiresAt(Instant completionUrlExpiresAt) {
            this.completionUrlExpiresAt = completionUrlExpiresAt;
        }

        @Override
        public final Builder completionUrlExpiresAt(Instant completionUrlExpiresAt) {
            this.completionUrlExpiresAt = completionUrlExpiresAt;
            return this;
        }

        public RegistrantVerificationResponse build() {
            return new RegistrantVerificationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RegistrantVerificationResponse> {
        public Builder completionUrl(String var1);

        public Builder completionUrlExpiresAt(Instant var1);
    }
}

