/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralaccount.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralaccount.model.ConnectionType;
import software.amazon.awssdk.services.partnercentralaccount.model.InvitationStatus;
import software.amazon.awssdk.services.partnercentralaccount.model.ParticipantIdentifierListCopier;
import software.amazon.awssdk.services.partnercentralaccount.model.ParticipantType;
import software.amazon.awssdk.services.partnercentralaccount.model.PartnerCentralAccountRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConnectionInvitationsRequest
extends PartnerCentralAccountRequest
implements ToCopyableBuilder<Builder, ListConnectionInvitationsRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(ListConnectionInvitationsRequest.getter(ListConnectionInvitationsRequest::catalog)).setter(ListConnectionInvitationsRequest.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListConnectionInvitationsRequest.getter(ListConnectionInvitationsRequest::nextToken)).setter(ListConnectionInvitationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionType").getter(ListConnectionInvitationsRequest.getter(ListConnectionInvitationsRequest::connectionTypeAsString)).setter(ListConnectionInvitationsRequest.setter(Builder::connectionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionType").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListConnectionInvitationsRequest.getter(ListConnectionInvitationsRequest::maxResults)).setter(ListConnectionInvitationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<List<String>> OTHER_PARTICIPANT_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OtherParticipantIdentifiers").getter(ListConnectionInvitationsRequest.getter(ListConnectionInvitationsRequest::otherParticipantIdentifiers)).setter(ListConnectionInvitationsRequest.setter(Builder::otherParticipantIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherParticipantIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PARTICIPANT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParticipantType").getter(ListConnectionInvitationsRequest.getter(ListConnectionInvitationsRequest::participantTypeAsString)).setter(ListConnectionInvitationsRequest.setter(Builder::participantType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ListConnectionInvitationsRequest.getter(ListConnectionInvitationsRequest::statusAsString)).setter(ListConnectionInvitationsRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, NEXT_TOKEN_FIELD, CONNECTION_TYPE_FIELD, MAX_RESULTS_FIELD, OTHER_PARTICIPANT_IDENTIFIERS_FIELD, PARTICIPANT_TYPE_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListConnectionInvitationsRequest.memberNameToFieldInitializer();
    private final String catalog;
    private final String nextToken;
    private final String connectionType;
    private final Integer maxResults;
    private final List<String> otherParticipantIdentifiers;
    private final String participantType;
    private final String status;

    private ListConnectionInvitationsRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.nextToken = builder.nextToken;
        this.connectionType = builder.connectionType;
        this.maxResults = builder.maxResults;
        this.otherParticipantIdentifiers = builder.otherParticipantIdentifiers;
        this.participantType = builder.participantType;
        this.status = builder.status;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final ConnectionType connectionType() {
        return ConnectionType.fromValue(this.connectionType);
    }

    public final String connectionTypeAsString() {
        return this.connectionType;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final boolean hasOtherParticipantIdentifiers() {
        return this.otherParticipantIdentifiers != null && !(this.otherParticipantIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> otherParticipantIdentifiers() {
        return this.otherParticipantIdentifiers;
    }

    public final ParticipantType participantType() {
        return ParticipantType.fromValue(this.participantType);
    }

    public final String participantTypeAsString() {
        return this.participantType;
    }

    public final InvitationStatus status() {
        return InvitationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOtherParticipantIdentifiers() ? this.otherParticipantIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.participantTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConnectionInvitationsRequest)) {
            return false;
        }
        ListConnectionInvitationsRequest other = (ListConnectionInvitationsRequest)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.connectionTypeAsString(), other.connectionTypeAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && this.hasOtherParticipantIdentifiers() == other.hasOtherParticipantIdentifiers() && Objects.equals(this.otherParticipantIdentifiers(), other.otherParticipantIdentifiers()) && Objects.equals(this.participantTypeAsString(), other.participantTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListConnectionInvitationsRequest").add("Catalog", (Object)this.catalog()).add("NextToken", (Object)this.nextToken()).add("ConnectionType", (Object)this.connectionTypeAsString()).add("MaxResults", (Object)this.maxResults()).add("OtherParticipantIdentifiers", this.hasOtherParticipantIdentifiers() ? this.otherParticipantIdentifiers() : null).add("ParticipantType", (Object)this.participantTypeAsString()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ConnectionType": {
                return Optional.ofNullable(clazz.cast(this.connectionTypeAsString()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "OtherParticipantIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.otherParticipantIdentifiers()));
            }
            case "ParticipantType": {
                return Optional.ofNullable(clazz.cast(this.participantTypeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ConnectionType", CONNECTION_TYPE_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("OtherParticipantIdentifiers", OTHER_PARTICIPANT_IDENTIFIERS_FIELD);
        map.put("ParticipantType", PARTICIPANT_TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConnectionInvitationsRequest, T> g) {
        return obj -> g.apply((ListConnectionInvitationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralAccountRequest.BuilderImpl
    implements Builder {
        private String catalog;
        private String nextToken;
        private String connectionType;
        private Integer maxResults;
        private List<String> otherParticipantIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private String participantType;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConnectionInvitationsRequest model) {
            super(model);
            this.catalog(model.catalog);
            this.nextToken(model.nextToken);
            this.connectionType(model.connectionType);
            this.maxResults(model.maxResults);
            this.otherParticipantIdentifiers(model.otherParticipantIdentifiers);
            this.participantType(model.participantType);
            this.status(model.status);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getConnectionType() {
            return this.connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<String> getOtherParticipantIdentifiers() {
            if (this.otherParticipantIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.otherParticipantIdentifiers;
        }

        public final void setOtherParticipantIdentifiers(Collection<String> otherParticipantIdentifiers) {
            this.otherParticipantIdentifiers = ParticipantIdentifierListCopier.copy(otherParticipantIdentifiers);
        }

        @Override
        public final Builder otherParticipantIdentifiers(Collection<String> otherParticipantIdentifiers) {
            this.otherParticipantIdentifiers = ParticipantIdentifierListCopier.copy(otherParticipantIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder otherParticipantIdentifiers(String ... otherParticipantIdentifiers) {
            this.otherParticipantIdentifiers(Arrays.asList(otherParticipantIdentifiers));
            return this;
        }

        public final String getParticipantType() {
            return this.participantType;
        }

        public final void setParticipantType(String participantType) {
            this.participantType = participantType;
        }

        @Override
        public final Builder participantType(String participantType) {
            this.participantType = participantType;
            return this;
        }

        @Override
        public final Builder participantType(ParticipantType participantType) {
            this.participantType(participantType == null ? null : participantType.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InvitationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListConnectionInvitationsRequest build() {
            return new ListConnectionInvitationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralAccountRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConnectionInvitationsRequest> {
        public Builder catalog(String var1);

        public Builder nextToken(String var1);

        public Builder connectionType(String var1);

        public Builder connectionType(ConnectionType var1);

        public Builder maxResults(Integer var1);

        public Builder otherParticipantIdentifiers(Collection<String> var1);

        public Builder otherParticipantIdentifiers(String ... var1);

        public Builder participantType(String var1);

        public Builder participantType(ParticipantType var1);

        public Builder status(String var1);

        public Builder status(InvitationStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

