/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.panorama.model.DeviceIdListCopier;
import software.amazon.awssdk.services.panorama.model.DeviceJobConfig;
import software.amazon.awssdk.services.panorama.model.JobType;
import software.amazon.awssdk.services.panorama.model.PanoramaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateJobForDevicesRequest
extends PanoramaRequest
implements ToCopyableBuilder<Builder, CreateJobForDevicesRequest> {
    private static final SdkField<List<String>> DEVICE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeviceIds").getter(CreateJobForDevicesRequest.getter(CreateJobForDevicesRequest::deviceIds)).setter(CreateJobForDevicesRequest.setter(Builder::deviceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DeviceJobConfig> DEVICE_JOB_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeviceJobConfig").getter(CreateJobForDevicesRequest.getter(CreateJobForDevicesRequest::deviceJobConfig)).setter(CreateJobForDevicesRequest.setter(Builder::deviceJobConfig)).constructor(DeviceJobConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceJobConfig").build()}).build();
    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobType").getter(CreateJobForDevicesRequest.getter(CreateJobForDevicesRequest::jobTypeAsString)).setter(CreateJobForDevicesRequest.setter(Builder::jobType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_IDS_FIELD, DEVICE_JOB_CONFIG_FIELD, JOB_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateJobForDevicesRequest.memberNameToFieldInitializer();
    private final List<String> deviceIds;
    private final DeviceJobConfig deviceJobConfig;
    private final String jobType;

    private CreateJobForDevicesRequest(BuilderImpl builder) {
        super(builder);
        this.deviceIds = builder.deviceIds;
        this.deviceJobConfig = builder.deviceJobConfig;
        this.jobType = builder.jobType;
    }

    public final boolean hasDeviceIds() {
        return this.deviceIds != null && !(this.deviceIds instanceof SdkAutoConstructList);
    }

    public final List<String> deviceIds() {
        return this.deviceIds;
    }

    public final DeviceJobConfig deviceJobConfig() {
        return this.deviceJobConfig;
    }

    public final JobType jobType() {
        return JobType.fromValue(this.jobType);
    }

    public final String jobTypeAsString() {
        return this.jobType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeviceIds() ? this.deviceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceJobConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobForDevicesRequest)) {
            return false;
        }
        CreateJobForDevicesRequest other = (CreateJobForDevicesRequest)((Object)obj);
        return this.hasDeviceIds() == other.hasDeviceIds() && Objects.equals(this.deviceIds(), other.deviceIds()) && Objects.equals(this.deviceJobConfig(), other.deviceJobConfig()) && Objects.equals(this.jobTypeAsString(), other.jobTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateJobForDevicesRequest").add("DeviceIds", this.hasDeviceIds() ? this.deviceIds() : null).add("DeviceJobConfig", (Object)this.deviceJobConfig()).add("JobType", (Object)this.jobTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceIds": {
                return Optional.ofNullable(clazz.cast(this.deviceIds()));
            }
            case "DeviceJobConfig": {
                return Optional.ofNullable(clazz.cast(this.deviceJobConfig()));
            }
            case "JobType": {
                return Optional.ofNullable(clazz.cast(this.jobTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DeviceIds", DEVICE_IDS_FIELD);
        map.put("DeviceJobConfig", DEVICE_JOB_CONFIG_FIELD);
        map.put("JobType", JOB_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateJobForDevicesRequest, T> g) {
        return obj -> g.apply((CreateJobForDevicesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PanoramaRequest.BuilderImpl
    implements Builder {
        private List<String> deviceIds = DefaultSdkAutoConstructList.getInstance();
        private DeviceJobConfig deviceJobConfig;
        private String jobType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobForDevicesRequest model) {
            super(model);
            this.deviceIds(model.deviceIds);
            this.deviceJobConfig(model.deviceJobConfig);
            this.jobType(model.jobType);
        }

        public final Collection<String> getDeviceIds() {
            if (this.deviceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.deviceIds;
        }

        public final void setDeviceIds(Collection<String> deviceIds) {
            this.deviceIds = DeviceIdListCopier.copy(deviceIds);
        }

        @Override
        public final Builder deviceIds(Collection<String> deviceIds) {
            this.deviceIds = DeviceIdListCopier.copy(deviceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceIds(String ... deviceIds) {
            this.deviceIds(Arrays.asList(deviceIds));
            return this;
        }

        public final DeviceJobConfig.Builder getDeviceJobConfig() {
            return this.deviceJobConfig != null ? this.deviceJobConfig.toBuilder() : null;
        }

        public final void setDeviceJobConfig(DeviceJobConfig.BuilderImpl deviceJobConfig) {
            this.deviceJobConfig = deviceJobConfig != null ? deviceJobConfig.build() : null;
        }

        @Override
        public final Builder deviceJobConfig(DeviceJobConfig deviceJobConfig) {
            this.deviceJobConfig = deviceJobConfig;
            return this;
        }

        public final String getJobType() {
            return this.jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateJobForDevicesRequest build() {
            return new CreateJobForDevicesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PanoramaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateJobForDevicesRequest> {
        public Builder deviceIds(Collection<String> var1);

        public Builder deviceIds(String ... var1);

        public Builder deviceJobConfig(DeviceJobConfig var1);

        default public Builder deviceJobConfig(Consumer<DeviceJobConfig.Builder> deviceJobConfig) {
            return this.deviceJobConfig((DeviceJobConfig)((DeviceJobConfig.Builder)DeviceJobConfig.builder().applyMutation(deviceJobConfig)).build());
        }

        public Builder jobType(String var1);

        public Builder jobType(JobType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

