/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.panorama.model.PanoramaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeletePackageRequest
extends PanoramaRequest
implements ToCopyableBuilder<Builder, DeletePackageRequest> {
    private static final SdkField<Boolean> FORCE_DELETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ForceDelete").getter(DeletePackageRequest.getter(DeletePackageRequest::forceDelete)).setter(DeletePackageRequest.setter(Builder::forceDelete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ForceDelete").build()}).build();
    private static final SdkField<String> PACKAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageId").getter(DeletePackageRequest.getter(DeletePackageRequest::packageId)).setter(DeletePackageRequest.setter(Builder::packageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("PackageId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORCE_DELETE_FIELD, PACKAGE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeletePackageRequest.memberNameToFieldInitializer();
    private final Boolean forceDelete;
    private final String packageId;

    private DeletePackageRequest(BuilderImpl builder) {
        super(builder);
        this.forceDelete = builder.forceDelete;
        this.packageId = builder.packageId;
    }

    public final Boolean forceDelete() {
        return this.forceDelete;
    }

    public final String packageId() {
        return this.packageId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.forceDelete());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePackageRequest)) {
            return false;
        }
        DeletePackageRequest other = (DeletePackageRequest)((Object)obj);
        return Objects.equals(this.forceDelete(), other.forceDelete()) && Objects.equals(this.packageId(), other.packageId());
    }

    public final String toString() {
        return ToString.builder((String)"DeletePackageRequest").add("ForceDelete", (Object)this.forceDelete()).add("PackageId", (Object)this.packageId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ForceDelete": {
                return Optional.ofNullable(clazz.cast(this.forceDelete()));
            }
            case "PackageId": {
                return Optional.ofNullable(clazz.cast(this.packageId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ForceDelete", FORCE_DELETE_FIELD);
        map.put("PackageId", PACKAGE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeletePackageRequest, T> g) {
        return obj -> g.apply((DeletePackageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PanoramaRequest.BuilderImpl
    implements Builder {
        private Boolean forceDelete;
        private String packageId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePackageRequest model) {
            super(model);
            this.forceDelete(model.forceDelete);
            this.packageId(model.packageId);
        }

        public final Boolean getForceDelete() {
            return this.forceDelete;
        }

        public final void setForceDelete(Boolean forceDelete) {
            this.forceDelete = forceDelete;
        }

        @Override
        public final Builder forceDelete(Boolean forceDelete) {
            this.forceDelete = forceDelete;
            return this;
        }

        public final String getPackageId() {
            return this.packageId;
        }

        public final void setPackageId(String packageId) {
            this.packageId = packageId;
        }

        @Override
        public final Builder packageId(String packageId) {
            this.packageId = packageId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeletePackageRequest build() {
            return new DeletePackageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PanoramaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeletePackageRequest> {
        public Builder forceDelete(Boolean var1);

        public Builder packageId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

