/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.panorama.model.NetworkConnectionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NtpStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NtpStatus> {
    private static final SdkField<String> CONNECTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionStatus").getter(NtpStatus.getter(NtpStatus::connectionStatusAsString)).setter(NtpStatus.setter(Builder::connectionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionStatus").build()}).build();
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddress").getter(NtpStatus.getter(NtpStatus::ipAddress)).setter(NtpStatus.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()}).build();
    private static final SdkField<String> NTP_SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NtpServerName").getter(NtpStatus.getter(NtpStatus::ntpServerName)).setter(NtpStatus.setter(Builder::ntpServerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NtpServerName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_STATUS_FIELD, IP_ADDRESS_FIELD, NTP_SERVER_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NtpStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String connectionStatus;
    private final String ipAddress;
    private final String ntpServerName;

    private NtpStatus(BuilderImpl builder) {
        this.connectionStatus = builder.connectionStatus;
        this.ipAddress = builder.ipAddress;
        this.ntpServerName = builder.ntpServerName;
    }

    public final NetworkConnectionStatus connectionStatus() {
        return NetworkConnectionStatus.fromValue(this.connectionStatus);
    }

    public final String connectionStatusAsString() {
        return this.connectionStatus;
    }

    public final String ipAddress() {
        return this.ipAddress;
    }

    public final String ntpServerName() {
        return this.ntpServerName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.ntpServerName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NtpStatus)) {
            return false;
        }
        NtpStatus other = (NtpStatus)obj;
        return Objects.equals(this.connectionStatusAsString(), other.connectionStatusAsString()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.ntpServerName(), other.ntpServerName());
    }

    public final String toString() {
        return ToString.builder((String)"NtpStatus").add("ConnectionStatus", (Object)this.connectionStatusAsString()).add("IpAddress", (Object)this.ipAddress()).add("NtpServerName", (Object)this.ntpServerName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionStatus": {
                return Optional.ofNullable(clazz.cast(this.connectionStatusAsString()));
            }
            case "IpAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "NtpServerName": {
                return Optional.ofNullable(clazz.cast(this.ntpServerName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ConnectionStatus", CONNECTION_STATUS_FIELD);
        map.put("IpAddress", IP_ADDRESS_FIELD);
        map.put("NtpServerName", NTP_SERVER_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NtpStatus, T> g) {
        return obj -> g.apply((NtpStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectionStatus;
        private String ipAddress;
        private String ntpServerName;

        private BuilderImpl() {
        }

        private BuilderImpl(NtpStatus model) {
            this.connectionStatus(model.connectionStatus);
            this.ipAddress(model.ipAddress);
            this.ntpServerName(model.ntpServerName);
        }

        public final String getConnectionStatus() {
            return this.connectionStatus;
        }

        public final void setConnectionStatus(String connectionStatus) {
            this.connectionStatus = connectionStatus;
        }

        @Override
        public final Builder connectionStatus(String connectionStatus) {
            this.connectionStatus = connectionStatus;
            return this;
        }

        @Override
        public final Builder connectionStatus(NetworkConnectionStatus connectionStatus) {
            this.connectionStatus(connectionStatus == null ? null : connectionStatus.toString());
            return this;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getNtpServerName() {
            return this.ntpServerName;
        }

        public final void setNtpServerName(String ntpServerName) {
            this.ntpServerName = ntpServerName;
        }

        @Override
        public final Builder ntpServerName(String ntpServerName) {
            this.ntpServerName = ntpServerName;
            return this;
        }

        public NtpStatus build() {
            return new NtpStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NtpStatus> {
        public Builder connectionStatus(String var1);

        public Builder connectionStatus(NetworkConnectionStatus var1);

        public Builder ipAddress(String var1);

        public Builder ntpServerName(String var1);
    }
}

