/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.panorama.PanoramaAsyncClient;
import software.amazon.awssdk.services.panorama.internal.UserAgentUtils;
import software.amazon.awssdk.services.panorama.model.ListDevicesJobsRequest;
import software.amazon.awssdk.services.panorama.model.ListDevicesJobsResponse;

public class ListDevicesJobsPublisher
implements SdkPublisher<ListDevicesJobsResponse> {
    private final PanoramaAsyncClient client;
    private final ListDevicesJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDevicesJobsPublisher(PanoramaAsyncClient client, ListDevicesJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDevicesJobsPublisher(PanoramaAsyncClient client, ListDevicesJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDevicesJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDevicesJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListDevicesJobsResponseFetcher
    implements AsyncPageFetcher<ListDevicesJobsResponse> {
        private ListDevicesJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListDevicesJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDevicesJobsResponse> nextPage(ListDevicesJobsResponse previousPage) {
            if (previousPage == null) {
                return ListDevicesJobsPublisher.this.client.listDevicesJobs(ListDevicesJobsPublisher.this.firstRequest);
            }
            return ListDevicesJobsPublisher.this.client.listDevicesJobs((ListDevicesJobsRequest)((Object)ListDevicesJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

