/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.panorama.model.ConnectionType;
import software.amazon.awssdk.services.panorama.model.StaticIpConnectionInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EthernetPayload
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EthernetPayload> {
    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionType").getter(EthernetPayload.getter(EthernetPayload::connectionTypeAsString)).setter(EthernetPayload.setter(Builder::connectionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionType").build()}).build();
    private static final SdkField<StaticIpConnectionInfo> STATIC_IP_CONNECTION_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StaticIpConnectionInfo").getter(EthernetPayload.getter(EthernetPayload::staticIpConnectionInfo)).setter(EthernetPayload.setter(Builder::staticIpConnectionInfo)).constructor(StaticIpConnectionInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticIpConnectionInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_TYPE_FIELD, STATIC_IP_CONNECTION_INFO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EthernetPayload.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String connectionType;
    private final StaticIpConnectionInfo staticIpConnectionInfo;

    private EthernetPayload(BuilderImpl builder) {
        this.connectionType = builder.connectionType;
        this.staticIpConnectionInfo = builder.staticIpConnectionInfo;
    }

    public final ConnectionType connectionType() {
        return ConnectionType.fromValue(this.connectionType);
    }

    public final String connectionTypeAsString() {
        return this.connectionType;
    }

    public final StaticIpConnectionInfo staticIpConnectionInfo() {
        return this.staticIpConnectionInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.staticIpConnectionInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EthernetPayload)) {
            return false;
        }
        EthernetPayload other = (EthernetPayload)obj;
        return Objects.equals(this.connectionTypeAsString(), other.connectionTypeAsString()) && Objects.equals(this.staticIpConnectionInfo(), other.staticIpConnectionInfo());
    }

    public final String toString() {
        return ToString.builder((String)"EthernetPayload").add("ConnectionType", (Object)this.connectionTypeAsString()).add("StaticIpConnectionInfo", (Object)this.staticIpConnectionInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionType": {
                return Optional.ofNullable(clazz.cast(this.connectionTypeAsString()));
            }
            case "StaticIpConnectionInfo": {
                return Optional.ofNullable(clazz.cast(this.staticIpConnectionInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConnectionType", CONNECTION_TYPE_FIELD);
        map.put("StaticIpConnectionInfo", STATIC_IP_CONNECTION_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EthernetPayload, T> g) {
        return obj -> g.apply((EthernetPayload)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectionType;
        private StaticIpConnectionInfo staticIpConnectionInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(EthernetPayload model) {
            this.connectionType(model.connectionType);
            this.staticIpConnectionInfo(model.staticIpConnectionInfo);
        }

        public final String getConnectionType() {
            return this.connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        public final StaticIpConnectionInfo.Builder getStaticIpConnectionInfo() {
            return this.staticIpConnectionInfo != null ? this.staticIpConnectionInfo.toBuilder() : null;
        }

        public final void setStaticIpConnectionInfo(StaticIpConnectionInfo.BuilderImpl staticIpConnectionInfo) {
            this.staticIpConnectionInfo = staticIpConnectionInfo != null ? staticIpConnectionInfo.build() : null;
        }

        @Override
        public final Builder staticIpConnectionInfo(StaticIpConnectionInfo staticIpConnectionInfo) {
            this.staticIpConnectionInfo = staticIpConnectionInfo;
            return this;
        }

        public EthernetPayload build() {
            return new EthernetPayload(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EthernetPayload> {
        public Builder connectionType(String var1);

        public Builder connectionType(ConnectionType var1);

        public Builder staticIpConnectionInfo(StaticIpConnectionInfo var1);

        default public Builder staticIpConnectionInfo(Consumer<StaticIpConnectionInfo.Builder> staticIpConnectionInfo) {
            return this.staticIpConnectionInfo((StaticIpConnectionInfo)((StaticIpConnectionInfo.Builder)StaticIpConnectionInfo.builder().applyMutation(staticIpConnectionInfo)).build());
        }
    }
}

