/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.panorama.model.NodeCategory;
import software.amazon.awssdk.services.panorama.model.NodeInterface;
import software.amazon.awssdk.services.panorama.model.PanoramaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeNodeResponse
extends PanoramaResponse
implements ToCopyableBuilder<Builder, DescribeNodeResponse> {
    private static final SdkField<String> ASSET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssetName").getter(DescribeNodeResponse.getter(DescribeNodeResponse::assetName)).setter(DescribeNodeResponse.setter(Builder::assetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetName").build()}).build();
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Category").getter(DescribeNodeResponse.getter(DescribeNodeResponse::categoryAsString)).setter(DescribeNodeResponse.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(DescribeNodeResponse.getter(DescribeNodeResponse::createdTime)).setter(DescribeNodeResponse.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeNodeResponse.getter(DescribeNodeResponse::description)).setter(DescribeNodeResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(DescribeNodeResponse.getter(DescribeNodeResponse::lastUpdatedTime)).setter(DescribeNodeResponse.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeNodeResponse.getter(DescribeNodeResponse::name)).setter(DescribeNodeResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> NODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeId").getter(DescribeNodeResponse.getter(DescribeNodeResponse::nodeId)).setter(DescribeNodeResponse.setter(Builder::nodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeId").build()}).build();
    private static final SdkField<NodeInterface> NODE_INTERFACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NodeInterface").getter(DescribeNodeResponse.getter(DescribeNodeResponse::nodeInterface)).setter(DescribeNodeResponse.setter(Builder::nodeInterface)).constructor(NodeInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeInterface").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerAccount").getter(DescribeNodeResponse.getter(DescribeNodeResponse::ownerAccount)).setter(DescribeNodeResponse.setter(Builder::ownerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccount").build()}).build();
    private static final SdkField<String> PACKAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageArn").getter(DescribeNodeResponse.getter(DescribeNodeResponse::packageArn)).setter(DescribeNodeResponse.setter(Builder::packageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageArn").build()}).build();
    private static final SdkField<String> PACKAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageId").getter(DescribeNodeResponse.getter(DescribeNodeResponse::packageId)).setter(DescribeNodeResponse.setter(Builder::packageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageId").build()}).build();
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageName").getter(DescribeNodeResponse.getter(DescribeNodeResponse::packageName)).setter(DescribeNodeResponse.setter(Builder::packageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageName").build()}).build();
    private static final SdkField<String> PACKAGE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageVersion").getter(DescribeNodeResponse.getter(DescribeNodeResponse::packageVersion)).setter(DescribeNodeResponse.setter(Builder::packageVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageVersion").build()}).build();
    private static final SdkField<String> PATCH_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PatchVersion").getter(DescribeNodeResponse.getter(DescribeNodeResponse::patchVersion)).setter(DescribeNodeResponse.setter(Builder::patchVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_NAME_FIELD, CATEGORY_FIELD, CREATED_TIME_FIELD, DESCRIPTION_FIELD, LAST_UPDATED_TIME_FIELD, NAME_FIELD, NODE_ID_FIELD, NODE_INTERFACE_FIELD, OWNER_ACCOUNT_FIELD, PACKAGE_ARN_FIELD, PACKAGE_ID_FIELD, PACKAGE_NAME_FIELD, PACKAGE_VERSION_FIELD, PATCH_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeNodeResponse.memberNameToFieldInitializer();
    private final String assetName;
    private final String category;
    private final Instant createdTime;
    private final String description;
    private final Instant lastUpdatedTime;
    private final String name;
    private final String nodeId;
    private final NodeInterface nodeInterface;
    private final String ownerAccount;
    private final String packageArn;
    private final String packageId;
    private final String packageName;
    private final String packageVersion;
    private final String patchVersion;

    private DescribeNodeResponse(BuilderImpl builder) {
        super(builder);
        this.assetName = builder.assetName;
        this.category = builder.category;
        this.createdTime = builder.createdTime;
        this.description = builder.description;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.name = builder.name;
        this.nodeId = builder.nodeId;
        this.nodeInterface = builder.nodeInterface;
        this.ownerAccount = builder.ownerAccount;
        this.packageArn = builder.packageArn;
        this.packageId = builder.packageId;
        this.packageName = builder.packageName;
        this.packageVersion = builder.packageVersion;
        this.patchVersion = builder.patchVersion;
    }

    public final String assetName() {
        return this.assetName;
    }

    public final NodeCategory category() {
        return NodeCategory.fromValue(this.category);
    }

    public final String categoryAsString() {
        return this.category;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String description() {
        return this.description;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final String name() {
        return this.name;
    }

    public final String nodeId() {
        return this.nodeId;
    }

    public final NodeInterface nodeInterface() {
        return this.nodeInterface;
    }

    public final String ownerAccount() {
        return this.ownerAccount;
    }

    public final String packageArn() {
        return this.packageArn;
    }

    public final String packageId() {
        return this.packageId;
    }

    public final String packageName() {
        return this.packageName;
    }

    public final String packageVersion() {
        return this.packageVersion;
    }

    public final String patchVersion() {
        return this.patchVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeInterface());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.patchVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNodeResponse)) {
            return false;
        }
        DescribeNodeResponse other = (DescribeNodeResponse)((Object)obj);
        return Objects.equals(this.assetName(), other.assetName()) && Objects.equals(this.categoryAsString(), other.categoryAsString()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.nodeId(), other.nodeId()) && Objects.equals(this.nodeInterface(), other.nodeInterface()) && Objects.equals(this.ownerAccount(), other.ownerAccount()) && Objects.equals(this.packageArn(), other.packageArn()) && Objects.equals(this.packageId(), other.packageId()) && Objects.equals(this.packageName(), other.packageName()) && Objects.equals(this.packageVersion(), other.packageVersion()) && Objects.equals(this.patchVersion(), other.patchVersion());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeNodeResponse").add("AssetName", (Object)this.assetName()).add("Category", (Object)this.categoryAsString()).add("CreatedTime", (Object)this.createdTime()).add("Description", (Object)this.description()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("Name", (Object)this.name()).add("NodeId", (Object)this.nodeId()).add("NodeInterface", (Object)this.nodeInterface()).add("OwnerAccount", (Object)this.ownerAccount()).add("PackageArn", (Object)this.packageArn()).add("PackageId", (Object)this.packageId()).add("PackageName", (Object)this.packageName()).add("PackageVersion", (Object)this.packageVersion()).add("PatchVersion", (Object)this.patchVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssetName": {
                return Optional.ofNullable(clazz.cast(this.assetName()));
            }
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.categoryAsString()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "NodeId": {
                return Optional.ofNullable(clazz.cast(this.nodeId()));
            }
            case "NodeInterface": {
                return Optional.ofNullable(clazz.cast(this.nodeInterface()));
            }
            case "OwnerAccount": {
                return Optional.ofNullable(clazz.cast(this.ownerAccount()));
            }
            case "PackageArn": {
                return Optional.ofNullable(clazz.cast(this.packageArn()));
            }
            case "PackageId": {
                return Optional.ofNullable(clazz.cast(this.packageId()));
            }
            case "PackageName": {
                return Optional.ofNullable(clazz.cast(this.packageName()));
            }
            case "PackageVersion": {
                return Optional.ofNullable(clazz.cast(this.packageVersion()));
            }
            case "PatchVersion": {
                return Optional.ofNullable(clazz.cast(this.patchVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AssetName", ASSET_NAME_FIELD);
        map.put("Category", CATEGORY_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("NodeId", NODE_ID_FIELD);
        map.put("NodeInterface", NODE_INTERFACE_FIELD);
        map.put("OwnerAccount", OWNER_ACCOUNT_FIELD);
        map.put("PackageArn", PACKAGE_ARN_FIELD);
        map.put("PackageId", PACKAGE_ID_FIELD);
        map.put("PackageName", PACKAGE_NAME_FIELD);
        map.put("PackageVersion", PACKAGE_VERSION_FIELD);
        map.put("PatchVersion", PATCH_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeNodeResponse, T> g) {
        return obj -> g.apply((DescribeNodeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PanoramaResponse.BuilderImpl
    implements Builder {
        private String assetName;
        private String category;
        private Instant createdTime;
        private String description;
        private Instant lastUpdatedTime;
        private String name;
        private String nodeId;
        private NodeInterface nodeInterface;
        private String ownerAccount;
        private String packageArn;
        private String packageId;
        private String packageName;
        private String packageVersion;
        private String patchVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNodeResponse model) {
            super(model);
            this.assetName(model.assetName);
            this.category(model.category);
            this.createdTime(model.createdTime);
            this.description(model.description);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.name(model.name);
            this.nodeId(model.nodeId);
            this.nodeInterface(model.nodeInterface);
            this.ownerAccount(model.ownerAccount);
            this.packageArn(model.packageArn);
            this.packageId(model.packageId);
            this.packageName(model.packageName);
            this.packageVersion(model.packageVersion);
            this.patchVersion(model.patchVersion);
        }

        public final String getAssetName() {
            return this.assetName;
        }

        public final void setAssetName(String assetName) {
            this.assetName = assetName;
        }

        @Override
        public final Builder assetName(String assetName) {
            this.assetName = assetName;
            return this;
        }

        public final String getCategory() {
            return this.category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(NodeCategory category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNodeId() {
            return this.nodeId;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final NodeInterface.Builder getNodeInterface() {
            return this.nodeInterface != null ? this.nodeInterface.toBuilder() : null;
        }

        public final void setNodeInterface(NodeInterface.BuilderImpl nodeInterface) {
            this.nodeInterface = nodeInterface != null ? nodeInterface.build() : null;
        }

        @Override
        public final Builder nodeInterface(NodeInterface nodeInterface) {
            this.nodeInterface = nodeInterface;
            return this;
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final String getPackageArn() {
            return this.packageArn;
        }

        public final void setPackageArn(String packageArn) {
            this.packageArn = packageArn;
        }

        @Override
        public final Builder packageArn(String packageArn) {
            this.packageArn = packageArn;
            return this;
        }

        public final String getPackageId() {
            return this.packageId;
        }

        public final void setPackageId(String packageId) {
            this.packageId = packageId;
        }

        @Override
        public final Builder packageId(String packageId) {
            this.packageId = packageId;
            return this;
        }

        public final String getPackageName() {
            return this.packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getPackageVersion() {
            return this.packageVersion;
        }

        public final void setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
        }

        @Override
        public final Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        public final String getPatchVersion() {
            return this.patchVersion;
        }

        public final void setPatchVersion(String patchVersion) {
            this.patchVersion = patchVersion;
        }

        @Override
        public final Builder patchVersion(String patchVersion) {
            this.patchVersion = patchVersion;
            return this;
        }

        @Override
        public DescribeNodeResponse build() {
            return new DescribeNodeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PanoramaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeNodeResponse> {
        public Builder assetName(String var1);

        public Builder category(String var1);

        public Builder category(NodeCategory var1);

        public Builder createdTime(Instant var1);

        public Builder description(String var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder name(String var1);

        public Builder nodeId(String var1);

        public Builder nodeInterface(NodeInterface var1);

        default public Builder nodeInterface(Consumer<NodeInterface.Builder> nodeInterface) {
            return this.nodeInterface((NodeInterface)((NodeInterface.Builder)NodeInterface.builder().applyMutation(nodeInterface)).build());
        }

        public Builder ownerAccount(String var1);

        public Builder packageArn(String var1);

        public Builder packageId(String var1);

        public Builder packageName(String var1);

        public Builder packageVersion(String var1);

        public Builder patchVersion(String var1);
    }
}

