/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.panorama.model.DesiredState;
import software.amazon.awssdk.services.panorama.model.DeviceReportedStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReportedRuntimeContextState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReportedRuntimeContextState> {
    private static final SdkField<String> DESIRED_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DesiredState").getter(ReportedRuntimeContextState.getter(ReportedRuntimeContextState::desiredStateAsString)).setter(ReportedRuntimeContextState.setter(Builder::desiredState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredState").build()}).build();
    private static final SdkField<String> DEVICE_REPORTED_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceReportedStatus").getter(ReportedRuntimeContextState.getter(ReportedRuntimeContextState::deviceReportedStatusAsString)).setter(ReportedRuntimeContextState.setter(Builder::deviceReportedStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceReportedStatus").build()}).build();
    private static final SdkField<Instant> DEVICE_REPORTED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeviceReportedTime").getter(ReportedRuntimeContextState.getter(ReportedRuntimeContextState::deviceReportedTime)).setter(ReportedRuntimeContextState.setter(Builder::deviceReportedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceReportedTime").build()}).build();
    private static final SdkField<String> RUNTIME_CONTEXT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuntimeContextName").getter(ReportedRuntimeContextState.getter(ReportedRuntimeContextState::runtimeContextName)).setter(ReportedRuntimeContextState.setter(Builder::runtimeContextName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeContextName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESIRED_STATE_FIELD, DEVICE_REPORTED_STATUS_FIELD, DEVICE_REPORTED_TIME_FIELD, RUNTIME_CONTEXT_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DesiredState", DESIRED_STATE_FIELD);
            this.put("DeviceReportedStatus", DEVICE_REPORTED_STATUS_FIELD);
            this.put("DeviceReportedTime", DEVICE_REPORTED_TIME_FIELD);
            this.put("RuntimeContextName", RUNTIME_CONTEXT_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String desiredState;
    private final String deviceReportedStatus;
    private final Instant deviceReportedTime;
    private final String runtimeContextName;

    private ReportedRuntimeContextState(BuilderImpl builder) {
        this.desiredState = builder.desiredState;
        this.deviceReportedStatus = builder.deviceReportedStatus;
        this.deviceReportedTime = builder.deviceReportedTime;
        this.runtimeContextName = builder.runtimeContextName;
    }

    public final DesiredState desiredState() {
        return DesiredState.fromValue(this.desiredState);
    }

    public final String desiredStateAsString() {
        return this.desiredState;
    }

    public final DeviceReportedStatus deviceReportedStatus() {
        return DeviceReportedStatus.fromValue(this.deviceReportedStatus);
    }

    public final String deviceReportedStatusAsString() {
        return this.deviceReportedStatus;
    }

    public final Instant deviceReportedTime() {
        return this.deviceReportedTime;
    }

    public final String runtimeContextName() {
        return this.runtimeContextName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceReportedStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceReportedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeContextName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportedRuntimeContextState)) {
            return false;
        }
        ReportedRuntimeContextState other = (ReportedRuntimeContextState)obj;
        return Objects.equals(this.desiredStateAsString(), other.desiredStateAsString()) && Objects.equals(this.deviceReportedStatusAsString(), other.deviceReportedStatusAsString()) && Objects.equals(this.deviceReportedTime(), other.deviceReportedTime()) && Objects.equals(this.runtimeContextName(), other.runtimeContextName());
    }

    public final String toString() {
        return ToString.builder((String)"ReportedRuntimeContextState").add("DesiredState", (Object)this.desiredStateAsString()).add("DeviceReportedStatus", (Object)this.deviceReportedStatusAsString()).add("DeviceReportedTime", (Object)this.deviceReportedTime()).add("RuntimeContextName", (Object)this.runtimeContextName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DesiredState": {
                return Optional.ofNullable(clazz.cast(this.desiredStateAsString()));
            }
            case "DeviceReportedStatus": {
                return Optional.ofNullable(clazz.cast(this.deviceReportedStatusAsString()));
            }
            case "DeviceReportedTime": {
                return Optional.ofNullable(clazz.cast(this.deviceReportedTime()));
            }
            case "RuntimeContextName": {
                return Optional.ofNullable(clazz.cast(this.runtimeContextName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ReportedRuntimeContextState, T> g) {
        return obj -> g.apply((ReportedRuntimeContextState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String desiredState;
        private String deviceReportedStatus;
        private Instant deviceReportedTime;
        private String runtimeContextName;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportedRuntimeContextState model) {
            this.desiredState(model.desiredState);
            this.deviceReportedStatus(model.deviceReportedStatus);
            this.deviceReportedTime(model.deviceReportedTime);
            this.runtimeContextName(model.runtimeContextName);
        }

        public final String getDesiredState() {
            return this.desiredState;
        }

        public final void setDesiredState(String desiredState) {
            this.desiredState = desiredState;
        }

        @Override
        public final Builder desiredState(String desiredState) {
            this.desiredState = desiredState;
            return this;
        }

        @Override
        public final Builder desiredState(DesiredState desiredState) {
            this.desiredState(desiredState == null ? null : desiredState.toString());
            return this;
        }

        public final String getDeviceReportedStatus() {
            return this.deviceReportedStatus;
        }

        public final void setDeviceReportedStatus(String deviceReportedStatus) {
            this.deviceReportedStatus = deviceReportedStatus;
        }

        @Override
        public final Builder deviceReportedStatus(String deviceReportedStatus) {
            this.deviceReportedStatus = deviceReportedStatus;
            return this;
        }

        @Override
        public final Builder deviceReportedStatus(DeviceReportedStatus deviceReportedStatus) {
            this.deviceReportedStatus(deviceReportedStatus == null ? null : deviceReportedStatus.toString());
            return this;
        }

        public final Instant getDeviceReportedTime() {
            return this.deviceReportedTime;
        }

        public final void setDeviceReportedTime(Instant deviceReportedTime) {
            this.deviceReportedTime = deviceReportedTime;
        }

        @Override
        public final Builder deviceReportedTime(Instant deviceReportedTime) {
            this.deviceReportedTime = deviceReportedTime;
            return this;
        }

        public final String getRuntimeContextName() {
            return this.runtimeContextName;
        }

        public final void setRuntimeContextName(String runtimeContextName) {
            this.runtimeContextName = runtimeContextName;
        }

        @Override
        public final Builder runtimeContextName(String runtimeContextName) {
            this.runtimeContextName = runtimeContextName;
            return this;
        }

        public ReportedRuntimeContextState build() {
            return new ReportedRuntimeContextState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReportedRuntimeContextState> {
        public Builder desiredState(String var1);

        public Builder desiredState(DesiredState var1);

        public Builder deviceReportedStatus(String var1);

        public Builder deviceReportedStatus(DeviceReportedStatus var1);

        public Builder deviceReportedTime(Instant var1);

        public Builder runtimeContextName(String var1);
    }
}

