/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.panorama.PanoramaAsyncClient;
import software.amazon.awssdk.services.panorama.internal.UserAgentUtils;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstancesRequest;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstancesResponse;

public class ListApplicationInstancesPublisher
implements SdkPublisher<ListApplicationInstancesResponse> {
    private final PanoramaAsyncClient client;
    private final ListApplicationInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListApplicationInstancesPublisher(PanoramaAsyncClient client, ListApplicationInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListApplicationInstancesPublisher(PanoramaAsyncClient client, ListApplicationInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListApplicationInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListApplicationInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListApplicationInstancesResponseFetcher
    implements AsyncPageFetcher<ListApplicationInstancesResponse> {
        private ListApplicationInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListApplicationInstancesResponse> nextPage(ListApplicationInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationInstancesPublisher.this.client.listApplicationInstances(ListApplicationInstancesPublisher.this.firstRequest);
            }
            return ListApplicationInstancesPublisher.this.client.listApplicationInstances((ListApplicationInstancesRequest)((Object)ListApplicationInstancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

