/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UpdateProgress {
    PENDING("PENDING"),
    IN_PROGRESS("IN_PROGRESS"),
    VERIFYING("VERIFYING"),
    REBOOTING("REBOOTING"),
    DOWNLOADING("DOWNLOADING"),
    COMPLETED("COMPLETED"),
    FAILED("FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UpdateProgress> VALUE_MAP;
    private final String value;

    private UpdateProgress(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UpdateProgress fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UpdateProgress> knownValues() {
        EnumSet<UpdateProgress> knownValues = EnumSet.allOf(UpdateProgress.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UpdateProgress.class, UpdateProgress::toString);
    }
}

