/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.panorama.PanoramaAsyncClient;
import software.amazon.awssdk.services.panorama.internal.UserAgentUtils;
import software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsRequest;
import software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsResponse;

public class ListNodeFromTemplateJobsPublisher
implements SdkPublisher<ListNodeFromTemplateJobsResponse> {
    private final PanoramaAsyncClient client;
    private final ListNodeFromTemplateJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListNodeFromTemplateJobsPublisher(PanoramaAsyncClient client, ListNodeFromTemplateJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListNodeFromTemplateJobsPublisher(PanoramaAsyncClient client, ListNodeFromTemplateJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListNodeFromTemplateJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListNodeFromTemplateJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListNodeFromTemplateJobsResponseFetcher
    implements AsyncPageFetcher<ListNodeFromTemplateJobsResponse> {
        private ListNodeFromTemplateJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListNodeFromTemplateJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListNodeFromTemplateJobsResponse> nextPage(ListNodeFromTemplateJobsResponse previousPage) {
            if (previousPage == null) {
                return ListNodeFromTemplateJobsPublisher.this.client.listNodeFromTemplateJobs(ListNodeFromTemplateJobsPublisher.this.firstRequest);
            }
            return ListNodeFromTemplateJobsPublisher.this.client.listNodeFromTemplateJobs((ListNodeFromTemplateJobsRequest)((Object)ListNodeFromTemplateJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

