/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.panorama.PanoramaAsyncClient;
import software.amazon.awssdk.services.panorama.model.ListPackagesRequest;
import software.amazon.awssdk.services.panorama.model.ListPackagesResponse;

public class ListPackagesPublisher
implements SdkPublisher<ListPackagesResponse> {
    private final PanoramaAsyncClient client;
    private final ListPackagesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPackagesPublisher(PanoramaAsyncClient client, ListPackagesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPackagesPublisher(PanoramaAsyncClient client, ListPackagesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPackagesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPackagesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListPackagesResponseFetcher
    implements AsyncPageFetcher<ListPackagesResponse> {
        private ListPackagesResponseFetcher() {
        }

        public boolean hasNextPage(ListPackagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPackagesResponse> nextPage(ListPackagesResponse previousPage) {
            if (previousPage == null) {
                return ListPackagesPublisher.this.client.listPackages(ListPackagesPublisher.this.firstRequest);
            }
            return ListPackagesPublisher.this.client.listPackages((ListPackagesRequest)((Object)ListPackagesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

