/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus;
import software.amazon.awssdk.services.panorama.model.DeviceBrand;
import software.amazon.awssdk.services.panorama.model.DeviceStatus;
import software.amazon.awssdk.services.panorama.model.DeviceType;
import software.amazon.awssdk.services.panorama.model.LatestDeviceJob;
import software.amazon.awssdk.services.panorama.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Device
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Device> {
    private static final SdkField<String> BRAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Brand").getter(Device.getter(Device::brandAsString)).setter(Device.setter(Builder::brand)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Brand").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(Device.getter(Device::createdTime)).setter(Device.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> CURRENT_SOFTWARE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentSoftware").getter(Device.getter(Device::currentSoftware)).setter(Device.setter(Builder::currentSoftware)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentSoftware").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Device.getter(Device::description)).setter(Device.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DEVICE_AGGREGATED_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceAggregatedStatus").getter(Device.getter(Device::deviceAggregatedStatusAsString)).setter(Device.setter(Builder::deviceAggregatedStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceAggregatedStatus").build()}).build();
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceId").getter(Device.getter(Device::deviceId)).setter(Device.setter(Builder::deviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(Device.getter(Device::lastUpdatedTime)).setter(Device.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<LatestDeviceJob> LATEST_DEVICE_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LatestDeviceJob").getter(Device.getter(Device::latestDeviceJob)).setter(Device.setter(Builder::latestDeviceJob)).constructor(LatestDeviceJob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestDeviceJob").build()}).build();
    private static final SdkField<Instant> LEASE_EXPIRATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LeaseExpirationTime").getter(Device.getter(Device::leaseExpirationTime)).setter(Device.setter(Builder::leaseExpirationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LeaseExpirationTime").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Device.getter(Device::name)).setter(Device.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> PROVISIONING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisioningStatus").getter(Device.getter(Device::provisioningStatusAsString)).setter(Device.setter(Builder::provisioningStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningStatus").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(Device.getter(Device::tags)).setter(Device.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Device.getter(Device::typeAsString)).setter(Device.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRAND_FIELD, CREATED_TIME_FIELD, CURRENT_SOFTWARE_FIELD, DESCRIPTION_FIELD, DEVICE_AGGREGATED_STATUS_FIELD, DEVICE_ID_FIELD, LAST_UPDATED_TIME_FIELD, LATEST_DEVICE_JOB_FIELD, LEASE_EXPIRATION_TIME_FIELD, NAME_FIELD, PROVISIONING_STATUS_FIELD, TAGS_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String brand;
    private final Instant createdTime;
    private final String currentSoftware;
    private final String description;
    private final String deviceAggregatedStatus;
    private final String deviceId;
    private final Instant lastUpdatedTime;
    private final LatestDeviceJob latestDeviceJob;
    private final Instant leaseExpirationTime;
    private final String name;
    private final String provisioningStatus;
    private final Map<String, String> tags;
    private final String type;

    private Device(BuilderImpl builder) {
        this.brand = builder.brand;
        this.createdTime = builder.createdTime;
        this.currentSoftware = builder.currentSoftware;
        this.description = builder.description;
        this.deviceAggregatedStatus = builder.deviceAggregatedStatus;
        this.deviceId = builder.deviceId;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.latestDeviceJob = builder.latestDeviceJob;
        this.leaseExpirationTime = builder.leaseExpirationTime;
        this.name = builder.name;
        this.provisioningStatus = builder.provisioningStatus;
        this.tags = builder.tags;
        this.type = builder.type;
    }

    public final DeviceBrand brand() {
        return DeviceBrand.fromValue(this.brand);
    }

    public final String brandAsString() {
        return this.brand;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String currentSoftware() {
        return this.currentSoftware;
    }

    public final String description() {
        return this.description;
    }

    public final DeviceAggregatedStatus deviceAggregatedStatus() {
        return DeviceAggregatedStatus.fromValue(this.deviceAggregatedStatus);
    }

    public final String deviceAggregatedStatusAsString() {
        return this.deviceAggregatedStatus;
    }

    public final String deviceId() {
        return this.deviceId;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final LatestDeviceJob latestDeviceJob() {
        return this.latestDeviceJob;
    }

    public final Instant leaseExpirationTime() {
        return this.leaseExpirationTime;
    }

    public final String name() {
        return this.name;
    }

    public final DeviceStatus provisioningStatus() {
        return DeviceStatus.fromValue(this.provisioningStatus);
    }

    public final String provisioningStatusAsString() {
        return this.provisioningStatus;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final DeviceType type() {
        return DeviceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.brandAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentSoftware());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceAggregatedStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestDeviceJob());
        hashCode = 31 * hashCode + Objects.hashCode(this.leaseExpirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Device)) {
            return false;
        }
        Device other = (Device)obj;
        return Objects.equals(this.brandAsString(), other.brandAsString()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.currentSoftware(), other.currentSoftware()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.deviceAggregatedStatusAsString(), other.deviceAggregatedStatusAsString()) && Objects.equals(this.deviceId(), other.deviceId()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.latestDeviceJob(), other.latestDeviceJob()) && Objects.equals(this.leaseExpirationTime(), other.leaseExpirationTime()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.provisioningStatusAsString(), other.provisioningStatusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Device").add("Brand", (Object)this.brandAsString()).add("CreatedTime", (Object)this.createdTime()).add("CurrentSoftware", (Object)this.currentSoftware()).add("Description", (Object)this.description()).add("DeviceAggregatedStatus", (Object)this.deviceAggregatedStatusAsString()).add("DeviceId", (Object)this.deviceId()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("LatestDeviceJob", (Object)this.latestDeviceJob()).add("LeaseExpirationTime", (Object)this.leaseExpirationTime()).add("Name", (Object)this.name()).add("ProvisioningStatus", (Object)this.provisioningStatusAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Brand": {
                return Optional.ofNullable(clazz.cast(this.brandAsString()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "CurrentSoftware": {
                return Optional.ofNullable(clazz.cast(this.currentSoftware()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DeviceAggregatedStatus": {
                return Optional.ofNullable(clazz.cast(this.deviceAggregatedStatusAsString()));
            }
            case "DeviceId": {
                return Optional.ofNullable(clazz.cast(this.deviceId()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "LatestDeviceJob": {
                return Optional.ofNullable(clazz.cast(this.latestDeviceJob()));
            }
            case "LeaseExpirationTime": {
                return Optional.ofNullable(clazz.cast(this.leaseExpirationTime()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ProvisioningStatus": {
                return Optional.ofNullable(clazz.cast(this.provisioningStatusAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Device, T> g) {
        return obj -> g.apply((Device)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String brand;
        private Instant createdTime;
        private String currentSoftware;
        private String description;
        private String deviceAggregatedStatus;
        private String deviceId;
        private Instant lastUpdatedTime;
        private LatestDeviceJob latestDeviceJob;
        private Instant leaseExpirationTime;
        private String name;
        private String provisioningStatus;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Device model) {
            this.brand(model.brand);
            this.createdTime(model.createdTime);
            this.currentSoftware(model.currentSoftware);
            this.description(model.description);
            this.deviceAggregatedStatus(model.deviceAggregatedStatus);
            this.deviceId(model.deviceId);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.latestDeviceJob(model.latestDeviceJob);
            this.leaseExpirationTime(model.leaseExpirationTime);
            this.name(model.name);
            this.provisioningStatus(model.provisioningStatus);
            this.tags(model.tags);
            this.type(model.type);
        }

        public final String getBrand() {
            return this.brand;
        }

        public final void setBrand(String brand) {
            this.brand = brand;
        }

        @Override
        public final Builder brand(String brand) {
            this.brand = brand;
            return this;
        }

        @Override
        public final Builder brand(DeviceBrand brand) {
            this.brand(brand == null ? null : brand.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getCurrentSoftware() {
            return this.currentSoftware;
        }

        public final void setCurrentSoftware(String currentSoftware) {
            this.currentSoftware = currentSoftware;
        }

        @Override
        public final Builder currentSoftware(String currentSoftware) {
            this.currentSoftware = currentSoftware;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDeviceAggregatedStatus() {
            return this.deviceAggregatedStatus;
        }

        public final void setDeviceAggregatedStatus(String deviceAggregatedStatus) {
            this.deviceAggregatedStatus = deviceAggregatedStatus;
        }

        @Override
        public final Builder deviceAggregatedStatus(String deviceAggregatedStatus) {
            this.deviceAggregatedStatus = deviceAggregatedStatus;
            return this;
        }

        @Override
        public final Builder deviceAggregatedStatus(DeviceAggregatedStatus deviceAggregatedStatus) {
            this.deviceAggregatedStatus(deviceAggregatedStatus == null ? null : deviceAggregatedStatus.toString());
            return this;
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final LatestDeviceJob.Builder getLatestDeviceJob() {
            return this.latestDeviceJob != null ? this.latestDeviceJob.toBuilder() : null;
        }

        public final void setLatestDeviceJob(LatestDeviceJob.BuilderImpl latestDeviceJob) {
            this.latestDeviceJob = latestDeviceJob != null ? latestDeviceJob.build() : null;
        }

        @Override
        public final Builder latestDeviceJob(LatestDeviceJob latestDeviceJob) {
            this.latestDeviceJob = latestDeviceJob;
            return this;
        }

        public final Instant getLeaseExpirationTime() {
            return this.leaseExpirationTime;
        }

        public final void setLeaseExpirationTime(Instant leaseExpirationTime) {
            this.leaseExpirationTime = leaseExpirationTime;
        }

        @Override
        public final Builder leaseExpirationTime(Instant leaseExpirationTime) {
            this.leaseExpirationTime = leaseExpirationTime;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProvisioningStatus() {
            return this.provisioningStatus;
        }

        public final void setProvisioningStatus(String provisioningStatus) {
            this.provisioningStatus = provisioningStatus;
        }

        @Override
        public final Builder provisioningStatus(String provisioningStatus) {
            this.provisioningStatus = provisioningStatus;
            return this;
        }

        @Override
        public final Builder provisioningStatus(DeviceStatus provisioningStatus) {
            this.provisioningStatus(provisioningStatus == null ? null : provisioningStatus.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DeviceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public Device build() {
            return new Device(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Device> {
        public Builder brand(String var1);

        public Builder brand(DeviceBrand var1);

        public Builder createdTime(Instant var1);

        public Builder currentSoftware(String var1);

        public Builder description(String var1);

        public Builder deviceAggregatedStatus(String var1);

        public Builder deviceAggregatedStatus(DeviceAggregatedStatus var1);

        public Builder deviceId(String var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder latestDeviceJob(LatestDeviceJob var1);

        default public Builder latestDeviceJob(Consumer<LatestDeviceJob.Builder> latestDeviceJob) {
            return this.latestDeviceJob((LatestDeviceJob)((LatestDeviceJob.Builder)LatestDeviceJob.builder().applyMutation(latestDeviceJob)).build());
        }

        public Builder leaseExpirationTime(Instant var1);

        public Builder name(String var1);

        public Builder provisioningStatus(String var1);

        public Builder provisioningStatus(DeviceStatus var1);

        public Builder tags(Map<String, String> var1);

        public Builder type(String var1);

        public Builder type(DeviceType var1);
    }
}

