/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeviceBrand {
    AWS_PANORAMA("AWS_PANORAMA"),
    LENOVO("LENOVO"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeviceBrand> VALUE_MAP;
    private final String value;

    private DeviceBrand(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeviceBrand fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeviceBrand> knownValues() {
        EnumSet<DeviceBrand> knownValues = EnumSet.allOf(DeviceBrand.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeviceBrand.class, DeviceBrand::toString);
    }
}

