/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.panorama.model.NodeFromTemplateJob;
import software.amazon.awssdk.services.panorama.model.NodeFromTemplateJobListCopier;
import software.amazon.awssdk.services.panorama.model.PanoramaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNodeFromTemplateJobsResponse
extends PanoramaResponse
implements ToCopyableBuilder<Builder, ListNodeFromTemplateJobsResponse> {
    private static final SdkField<List<NodeFromTemplateJob>> NODE_FROM_TEMPLATE_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NodeFromTemplateJobs").getter(ListNodeFromTemplateJobsResponse.getter(ListNodeFromTemplateJobsResponse::nodeFromTemplateJobs)).setter(ListNodeFromTemplateJobsResponse.setter(Builder::nodeFromTemplateJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeFromTemplateJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NodeFromTemplateJob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListNodeFromTemplateJobsResponse.getter(ListNodeFromTemplateJobsResponse::nextToken)).setter(ListNodeFromTemplateJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_FROM_TEMPLATE_JOBS_FIELD, NEXT_TOKEN_FIELD));
    private final List<NodeFromTemplateJob> nodeFromTemplateJobs;
    private final String nextToken;

    private ListNodeFromTemplateJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nodeFromTemplateJobs = builder.nodeFromTemplateJobs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasNodeFromTemplateJobs() {
        return this.nodeFromTemplateJobs != null && !(this.nodeFromTemplateJobs instanceof SdkAutoConstructList);
    }

    public final List<NodeFromTemplateJob> nodeFromTemplateJobs() {
        return this.nodeFromTemplateJobs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodeFromTemplateJobs() ? this.nodeFromTemplateJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNodeFromTemplateJobsResponse)) {
            return false;
        }
        ListNodeFromTemplateJobsResponse other = (ListNodeFromTemplateJobsResponse)((Object)obj);
        return this.hasNodeFromTemplateJobs() == other.hasNodeFromTemplateJobs() && Objects.equals(this.nodeFromTemplateJobs(), other.nodeFromTemplateJobs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListNodeFromTemplateJobsResponse").add("NodeFromTemplateJobs", this.hasNodeFromTemplateJobs() ? this.nodeFromTemplateJobs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NodeFromTemplateJobs": {
                return Optional.ofNullable(clazz.cast(this.nodeFromTemplateJobs()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListNodeFromTemplateJobsResponse, T> g) {
        return obj -> g.apply((ListNodeFromTemplateJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PanoramaResponse.BuilderImpl
    implements Builder {
        private List<NodeFromTemplateJob> nodeFromTemplateJobs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNodeFromTemplateJobsResponse model) {
            super(model);
            this.nodeFromTemplateJobs(model.nodeFromTemplateJobs);
            this.nextToken(model.nextToken);
        }

        public final List<NodeFromTemplateJob.Builder> getNodeFromTemplateJobs() {
            List<NodeFromTemplateJob.Builder> result = NodeFromTemplateJobListCopier.copyToBuilder(this.nodeFromTemplateJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodeFromTemplateJobs(Collection<NodeFromTemplateJob.BuilderImpl> nodeFromTemplateJobs) {
            this.nodeFromTemplateJobs = NodeFromTemplateJobListCopier.copyFromBuilder(nodeFromTemplateJobs);
        }

        @Override
        @Transient
        public final Builder nodeFromTemplateJobs(Collection<NodeFromTemplateJob> nodeFromTemplateJobs) {
            this.nodeFromTemplateJobs = NodeFromTemplateJobListCopier.copy(nodeFromTemplateJobs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder nodeFromTemplateJobs(NodeFromTemplateJob ... nodeFromTemplateJobs) {
            this.nodeFromTemplateJobs(Arrays.asList(nodeFromTemplateJobs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder nodeFromTemplateJobs(Consumer<NodeFromTemplateJob.Builder> ... nodeFromTemplateJobs) {
            this.nodeFromTemplateJobs(Stream.of(nodeFromTemplateJobs).map(c -> (NodeFromTemplateJob)((NodeFromTemplateJob.Builder)NodeFromTemplateJob.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListNodeFromTemplateJobsResponse build() {
            return new ListNodeFromTemplateJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PanoramaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListNodeFromTemplateJobsResponse> {
        public Builder nodeFromTemplateJobs(Collection<NodeFromTemplateJob> var1);

        public Builder nodeFromTemplateJobs(NodeFromTemplateJob ... var1);

        public Builder nodeFromTemplateJobs(Consumer<NodeFromTemplateJob.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

