/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeviceAggregatedStatus {
    ERROR("ERROR"),
    AWAITING_PROVISIONING("AWAITING_PROVISIONING"),
    PENDING("PENDING"),
    FAILED("FAILED"),
    DELETING("DELETING"),
    ONLINE("ONLINE"),
    OFFLINE("OFFLINE"),
    LEASE_EXPIRED("LEASE_EXPIRED"),
    UPDATE_NEEDED("UPDATE_NEEDED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeviceAggregatedStatus> VALUE_MAP;
    private final String value;

    private DeviceAggregatedStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeviceAggregatedStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeviceAggregatedStatus> knownValues() {
        EnumSet<DeviceAggregatedStatus> knownValues = EnumSet.allOf(DeviceAggregatedStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeviceAggregatedStatus.class, DeviceAggregatedStatus::toString);
    }
}

