/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.panorama.PanoramaClient;
import software.amazon.awssdk.services.panorama.model.AccessDeniedException;
import software.amazon.awssdk.services.panorama.model.ConflictException;
import software.amazon.awssdk.services.panorama.model.CreateApplicationInstanceRequest;
import software.amazon.awssdk.services.panorama.model.CreateApplicationInstanceResponse;
import software.amazon.awssdk.services.panorama.model.CreateJobForDevicesRequest;
import software.amazon.awssdk.services.panorama.model.CreateJobForDevicesResponse;
import software.amazon.awssdk.services.panorama.model.CreateNodeFromTemplateJobRequest;
import software.amazon.awssdk.services.panorama.model.CreateNodeFromTemplateJobResponse;
import software.amazon.awssdk.services.panorama.model.CreatePackageImportJobRequest;
import software.amazon.awssdk.services.panorama.model.CreatePackageImportJobResponse;
import software.amazon.awssdk.services.panorama.model.CreatePackageRequest;
import software.amazon.awssdk.services.panorama.model.CreatePackageResponse;
import software.amazon.awssdk.services.panorama.model.DeleteDeviceRequest;
import software.amazon.awssdk.services.panorama.model.DeleteDeviceResponse;
import software.amazon.awssdk.services.panorama.model.DeletePackageRequest;
import software.amazon.awssdk.services.panorama.model.DeletePackageResponse;
import software.amazon.awssdk.services.panorama.model.DeregisterPackageVersionRequest;
import software.amazon.awssdk.services.panorama.model.DeregisterPackageVersionResponse;
import software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceDetailsRequest;
import software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceDetailsResponse;
import software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceRequest;
import software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceResponse;
import software.amazon.awssdk.services.panorama.model.DescribeDeviceJobRequest;
import software.amazon.awssdk.services.panorama.model.DescribeDeviceJobResponse;
import software.amazon.awssdk.services.panorama.model.DescribeDeviceRequest;
import software.amazon.awssdk.services.panorama.model.DescribeDeviceResponse;
import software.amazon.awssdk.services.panorama.model.DescribeNodeFromTemplateJobRequest;
import software.amazon.awssdk.services.panorama.model.DescribeNodeFromTemplateJobResponse;
import software.amazon.awssdk.services.panorama.model.DescribeNodeRequest;
import software.amazon.awssdk.services.panorama.model.DescribeNodeResponse;
import software.amazon.awssdk.services.panorama.model.DescribePackageImportJobRequest;
import software.amazon.awssdk.services.panorama.model.DescribePackageImportJobResponse;
import software.amazon.awssdk.services.panorama.model.DescribePackageRequest;
import software.amazon.awssdk.services.panorama.model.DescribePackageResponse;
import software.amazon.awssdk.services.panorama.model.DescribePackageVersionRequest;
import software.amazon.awssdk.services.panorama.model.DescribePackageVersionResponse;
import software.amazon.awssdk.services.panorama.model.InternalServerException;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesRequest;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesResponse;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesRequest;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesResponse;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstancesRequest;
import software.amazon.awssdk.services.panorama.model.ListApplicationInstancesResponse;
import software.amazon.awssdk.services.panorama.model.ListDevicesJobsRequest;
import software.amazon.awssdk.services.panorama.model.ListDevicesJobsResponse;
import software.amazon.awssdk.services.panorama.model.ListDevicesRequest;
import software.amazon.awssdk.services.panorama.model.ListDevicesResponse;
import software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsRequest;
import software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsResponse;
import software.amazon.awssdk.services.panorama.model.ListNodesRequest;
import software.amazon.awssdk.services.panorama.model.ListNodesResponse;
import software.amazon.awssdk.services.panorama.model.ListPackageImportJobsRequest;
import software.amazon.awssdk.services.panorama.model.ListPackageImportJobsResponse;
import software.amazon.awssdk.services.panorama.model.ListPackagesRequest;
import software.amazon.awssdk.services.panorama.model.ListPackagesResponse;
import software.amazon.awssdk.services.panorama.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.panorama.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.panorama.model.PanoramaException;
import software.amazon.awssdk.services.panorama.model.PanoramaRequest;
import software.amazon.awssdk.services.panorama.model.ProvisionDeviceRequest;
import software.amazon.awssdk.services.panorama.model.ProvisionDeviceResponse;
import software.amazon.awssdk.services.panorama.model.RegisterPackageVersionRequest;
import software.amazon.awssdk.services.panorama.model.RegisterPackageVersionResponse;
import software.amazon.awssdk.services.panorama.model.RemoveApplicationInstanceRequest;
import software.amazon.awssdk.services.panorama.model.RemoveApplicationInstanceResponse;
import software.amazon.awssdk.services.panorama.model.ResourceNotFoundException;
import software.amazon.awssdk.services.panorama.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.panorama.model.TagResourceRequest;
import software.amazon.awssdk.services.panorama.model.TagResourceResponse;
import software.amazon.awssdk.services.panorama.model.UntagResourceRequest;
import software.amazon.awssdk.services.panorama.model.UntagResourceResponse;
import software.amazon.awssdk.services.panorama.model.UpdateDeviceMetadataRequest;
import software.amazon.awssdk.services.panorama.model.UpdateDeviceMetadataResponse;
import software.amazon.awssdk.services.panorama.model.ValidationException;
import software.amazon.awssdk.services.panorama.paginators.ListApplicationInstanceDependenciesIterable;
import software.amazon.awssdk.services.panorama.paginators.ListApplicationInstanceNodeInstancesIterable;
import software.amazon.awssdk.services.panorama.paginators.ListApplicationInstancesIterable;
import software.amazon.awssdk.services.panorama.paginators.ListDevicesIterable;
import software.amazon.awssdk.services.panorama.paginators.ListDevicesJobsIterable;
import software.amazon.awssdk.services.panorama.paginators.ListNodeFromTemplateJobsIterable;
import software.amazon.awssdk.services.panorama.paginators.ListNodesIterable;
import software.amazon.awssdk.services.panorama.paginators.ListPackageImportJobsIterable;
import software.amazon.awssdk.services.panorama.paginators.ListPackagesIterable;
import software.amazon.awssdk.services.panorama.transform.CreateApplicationInstanceRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.CreateJobForDevicesRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.CreateNodeFromTemplateJobRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.CreatePackageImportJobRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.CreatePackageRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.DeleteDeviceRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.DeletePackageRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.DeregisterPackageVersionRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.DescribeApplicationInstanceDetailsRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.DescribeApplicationInstanceRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.DescribeDeviceJobRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.DescribeDeviceRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.DescribeNodeFromTemplateJobRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.DescribeNodeRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.DescribePackageImportJobRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.DescribePackageRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.DescribePackageVersionRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.ListApplicationInstanceDependenciesRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.ListApplicationInstanceNodeInstancesRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.ListApplicationInstancesRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.ListDevicesJobsRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.ListDevicesRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.ListNodeFromTemplateJobsRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.ListNodesRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.ListPackageImportJobsRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.ListPackagesRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.ProvisionDeviceRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.RegisterPackageVersionRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.RemoveApplicationInstanceRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.panorama.transform.UpdateDeviceMetadataRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultPanoramaClient
implements PanoramaClient {
    private static final Logger log = Logger.loggerFor(DefaultPanoramaClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultPanoramaClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "panorama";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateApplicationInstanceResponse createApplicationInstance(CreateApplicationInstanceRequest createApplicationInstanceRequest) throws ValidationException, AccessDeniedException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateApplicationInstanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(this.clientConfiguration, createApplicationInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateApplicationInstance");
            CreateApplicationInstanceResponse createApplicationInstanceResponse = (CreateApplicationInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApplicationInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createApplicationInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateApplicationInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createApplicationInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$createApplicationInstance$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateJobForDevicesResponse createJobForDevices(CreateJobForDevicesRequest createJobForDevicesRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateJobForDevicesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(this.clientConfiguration, createJobForDevicesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateJobForDevices");
            CreateJobForDevicesResponse createJobForDevicesResponse = (CreateJobForDevicesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateJobForDevices").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createJobForDevicesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateJobForDevicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createJobForDevicesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$createJobForDevices$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateNodeFromTemplateJobResponse createNodeFromTemplateJob(CreateNodeFromTemplateJobRequest createNodeFromTemplateJobRequest) throws ConflictException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateNodeFromTemplateJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(this.clientConfiguration, createNodeFromTemplateJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateNodeFromTemplateJob");
            CreateNodeFromTemplateJobResponse createNodeFromTemplateJobResponse = (CreateNodeFromTemplateJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateNodeFromTemplateJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createNodeFromTemplateJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateNodeFromTemplateJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createNodeFromTemplateJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$createNodeFromTemplateJob$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePackageResponse createPackage(CreatePackageRequest createPackageRequest) throws ConflictException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePackageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(this.clientConfiguration, createPackageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePackage");
            CreatePackageResponse createPackageResponse = (CreatePackageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePackage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPackageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePackageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPackageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$createPackage$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePackageImportJobResponse createPackageImportJob(CreatePackageImportJobRequest createPackageImportJobRequest) throws ConflictException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePackageImportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(this.clientConfiguration, createPackageImportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePackageImportJob");
            CreatePackageImportJobResponse createPackageImportJobResponse = (CreatePackageImportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePackageImportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPackageImportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePackageImportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPackageImportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$createPackageImportJob$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDeviceResponse deleteDevice(DeleteDeviceRequest deleteDeviceRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDeviceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(this.clientConfiguration, deleteDeviceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDevice");
            DeleteDeviceResponse deleteDeviceResponse = (DeleteDeviceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDevice").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDeviceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDeviceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDeviceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$deleteDevice$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePackageResponse deletePackage(DeletePackageRequest deletePackageRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePackageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(this.clientConfiguration, deletePackageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePackage");
            DeletePackageResponse deletePackageResponse = (DeletePackageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePackage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePackageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePackageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePackageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$deletePackage$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeregisterPackageVersionResponse deregisterPackageVersion(DeregisterPackageVersionRequest deregisterPackageVersionRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterPackageVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(this.clientConfiguration, deregisterPackageVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterPackageVersion");
            DeregisterPackageVersionResponse deregisterPackageVersionResponse = (DeregisterPackageVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterPackageVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deregisterPackageVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeregisterPackageVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deregisterPackageVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$deregisterPackageVersion$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeApplicationInstanceResponse describeApplicationInstance(DescribeApplicationInstanceRequest describeApplicationInstanceRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeApplicationInstanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(this.clientConfiguration, describeApplicationInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeApplicationInstance");
            DescribeApplicationInstanceResponse describeApplicationInstanceResponse = (DescribeApplicationInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeApplicationInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeApplicationInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeApplicationInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeApplicationInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$describeApplicationInstance$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeApplicationInstanceDetailsResponse describeApplicationInstanceDetails(DescribeApplicationInstanceDetailsRequest describeApplicationInstanceDetailsRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeApplicationInstanceDetailsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(this.clientConfiguration, describeApplicationInstanceDetailsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeApplicationInstanceDetails");
            DescribeApplicationInstanceDetailsResponse describeApplicationInstanceDetailsResponse = (DescribeApplicationInstanceDetailsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeApplicationInstanceDetails").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeApplicationInstanceDetailsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeApplicationInstanceDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeApplicationInstanceDetailsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$describeApplicationInstanceDetails$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDeviceResponse describeDevice(DescribeDeviceRequest describeDeviceRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDeviceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(this.clientConfiguration, describeDeviceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDevice");
            DescribeDeviceResponse describeDeviceResponse = (DescribeDeviceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDevice").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDeviceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDeviceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDeviceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$describeDevice$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDeviceJobResponse describeDeviceJob(DescribeDeviceJobRequest describeDeviceJobRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDeviceJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(this.clientConfiguration, describeDeviceJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDeviceJob");
            DescribeDeviceJobResponse describeDeviceJobResponse = (DescribeDeviceJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDeviceJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDeviceJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDeviceJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDeviceJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$describeDeviceJob$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeNodeResponse describeNode(DescribeNodeRequest describeNodeRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeNodeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(this.clientConfiguration, describeNodeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeNode");
            DescribeNodeResponse describeNodeResponse = (DescribeNodeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeNode").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeNodeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeNodeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeNodeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$describeNode$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeNodeFromTemplateJobResponse describeNodeFromTemplateJob(DescribeNodeFromTemplateJobRequest describeNodeFromTemplateJobRequest) throws ConflictException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeNodeFromTemplateJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(this.clientConfiguration, describeNodeFromTemplateJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeNodeFromTemplateJob");
            DescribeNodeFromTemplateJobResponse describeNodeFromTemplateJobResponse = (DescribeNodeFromTemplateJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeNodeFromTemplateJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeNodeFromTemplateJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeNodeFromTemplateJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeNodeFromTemplateJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$describeNodeFromTemplateJob$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePackageResponse describePackage(DescribePackageRequest describePackageRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePackageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(this.clientConfiguration, describePackageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePackage");
            DescribePackageResponse describePackageResponse = (DescribePackageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePackage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describePackageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribePackageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describePackageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$describePackage$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePackageImportJobResponse describePackageImportJob(DescribePackageImportJobRequest describePackageImportJobRequest) throws ConflictException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePackageImportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(this.clientConfiguration, describePackageImportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePackageImportJob");
            DescribePackageImportJobResponse describePackageImportJobResponse = (DescribePackageImportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePackageImportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describePackageImportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribePackageImportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describePackageImportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$describePackageImportJob$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePackageVersionResponse describePackageVersion(DescribePackageVersionRequest describePackageVersionRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePackageVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(this.clientConfiguration, describePackageVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePackageVersion");
            DescribePackageVersionResponse describePackageVersionResponse = (DescribePackageVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePackageVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describePackageVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribePackageVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describePackageVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$describePackageVersion$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListApplicationInstanceDependenciesResponse listApplicationInstanceDependencies(ListApplicationInstanceDependenciesRequest listApplicationInstanceDependenciesRequest) throws AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApplicationInstanceDependenciesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(this.clientConfiguration, listApplicationInstanceDependenciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListApplicationInstanceDependencies");
            ListApplicationInstanceDependenciesResponse listApplicationInstanceDependenciesResponse = (ListApplicationInstanceDependenciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApplicationInstanceDependencies").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listApplicationInstanceDependenciesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListApplicationInstanceDependenciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listApplicationInstanceDependenciesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$listApplicationInstanceDependencies$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListApplicationInstanceDependenciesIterable listApplicationInstanceDependenciesPaginator(ListApplicationInstanceDependenciesRequest listApplicationInstanceDependenciesRequest) throws AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return new ListApplicationInstanceDependenciesIterable(this, this.applyPaginatorUserAgent(listApplicationInstanceDependenciesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListApplicationInstanceNodeInstancesResponse listApplicationInstanceNodeInstances(ListApplicationInstanceNodeInstancesRequest listApplicationInstanceNodeInstancesRequest) throws AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApplicationInstanceNodeInstancesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(this.clientConfiguration, listApplicationInstanceNodeInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListApplicationInstanceNodeInstances");
            ListApplicationInstanceNodeInstancesResponse listApplicationInstanceNodeInstancesResponse = (ListApplicationInstanceNodeInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApplicationInstanceNodeInstances").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listApplicationInstanceNodeInstancesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListApplicationInstanceNodeInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listApplicationInstanceNodeInstancesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$listApplicationInstanceNodeInstances$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListApplicationInstanceNodeInstancesIterable listApplicationInstanceNodeInstancesPaginator(ListApplicationInstanceNodeInstancesRequest listApplicationInstanceNodeInstancesRequest) throws AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return new ListApplicationInstanceNodeInstancesIterable(this, this.applyPaginatorUserAgent(listApplicationInstanceNodeInstancesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListApplicationInstancesResponse listApplicationInstances(ListApplicationInstancesRequest listApplicationInstancesRequest) throws AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApplicationInstancesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(this.clientConfiguration, listApplicationInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListApplicationInstances");
            ListApplicationInstancesResponse listApplicationInstancesResponse = (ListApplicationInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApplicationInstances").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listApplicationInstancesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListApplicationInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listApplicationInstancesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$listApplicationInstances$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListApplicationInstancesIterable listApplicationInstancesPaginator(ListApplicationInstancesRequest listApplicationInstancesRequest) throws AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return new ListApplicationInstancesIterable(this, this.applyPaginatorUserAgent(listApplicationInstancesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDevicesResponse listDevices(ListDevicesRequest listDevicesRequest) throws ConflictException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDevicesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(this.clientConfiguration, listDevicesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDevices");
            ListDevicesResponse listDevicesResponse = (ListDevicesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDevices").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDevicesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDevicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDevicesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$listDevices$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListDevicesIterable listDevicesPaginator(ListDevicesRequest listDevicesRequest) throws ConflictException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return new ListDevicesIterable(this, this.applyPaginatorUserAgent(listDevicesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDevicesJobsResponse listDevicesJobs(ListDevicesJobsRequest listDevicesJobsRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDevicesJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(this.clientConfiguration, listDevicesJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDevicesJobs");
            ListDevicesJobsResponse listDevicesJobsResponse = (ListDevicesJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDevicesJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDevicesJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDevicesJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDevicesJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$listDevicesJobs$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListDevicesJobsIterable listDevicesJobsPaginator(ListDevicesJobsRequest listDevicesJobsRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return new ListDevicesJobsIterable(this, this.applyPaginatorUserAgent(listDevicesJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListNodeFromTemplateJobsResponse listNodeFromTemplateJobs(ListNodeFromTemplateJobsRequest listNodeFromTemplateJobsRequest) throws ConflictException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListNodeFromTemplateJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(this.clientConfiguration, listNodeFromTemplateJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListNodeFromTemplateJobs");
            ListNodeFromTemplateJobsResponse listNodeFromTemplateJobsResponse = (ListNodeFromTemplateJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListNodeFromTemplateJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listNodeFromTemplateJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListNodeFromTemplateJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listNodeFromTemplateJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$listNodeFromTemplateJobs$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListNodeFromTemplateJobsIterable listNodeFromTemplateJobsPaginator(ListNodeFromTemplateJobsRequest listNodeFromTemplateJobsRequest) throws ConflictException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return new ListNodeFromTemplateJobsIterable(this, this.applyPaginatorUserAgent(listNodeFromTemplateJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListNodesResponse listNodes(ListNodesRequest listNodesRequest) throws ConflictException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListNodesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(this.clientConfiguration, listNodesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListNodes");
            ListNodesResponse listNodesResponse = (ListNodesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListNodes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listNodesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListNodesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listNodesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$listNodes$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListNodesIterable listNodesPaginator(ListNodesRequest listNodesRequest) throws ConflictException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return new ListNodesIterable(this, this.applyPaginatorUserAgent(listNodesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPackageImportJobsResponse listPackageImportJobs(ListPackageImportJobsRequest listPackageImportJobsRequest) throws ConflictException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPackageImportJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(this.clientConfiguration, listPackageImportJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPackageImportJobs");
            ListPackageImportJobsResponse listPackageImportJobsResponse = (ListPackageImportJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPackageImportJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPackageImportJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPackageImportJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPackageImportJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$listPackageImportJobs$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListPackageImportJobsIterable listPackageImportJobsPaginator(ListPackageImportJobsRequest listPackageImportJobsRequest) throws ConflictException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return new ListPackageImportJobsIterable(this, this.applyPaginatorUserAgent(listPackageImportJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPackagesResponse listPackages(ListPackagesRequest listPackagesRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPackagesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(this.clientConfiguration, listPackagesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPackages");
            ListPackagesResponse listPackagesResponse = (ListPackagesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPackages").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPackagesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPackagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPackagesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$listPackages$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListPackagesIterable listPackagesPaginator(ListPackagesRequest listPackagesRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        return new ListPackagesIterable(this, this.applyPaginatorUserAgent(listPackagesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$listTagsForResource$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProvisionDeviceResponse provisionDevice(ProvisionDeviceRequest provisionDeviceRequest) throws ConflictException, ValidationException, AccessDeniedException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ProvisionDeviceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(this.clientConfiguration, provisionDeviceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ProvisionDevice");
            ProvisionDeviceResponse provisionDeviceResponse = (ProvisionDeviceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ProvisionDevice").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)provisionDeviceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ProvisionDeviceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return provisionDeviceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$provisionDevice$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterPackageVersionResponse registerPackageVersion(RegisterPackageVersionRequest registerPackageVersionRequest) throws ConflictException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterPackageVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(this.clientConfiguration, registerPackageVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterPackageVersion");
            RegisterPackageVersionResponse registerPackageVersionResponse = (RegisterPackageVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterPackageVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)registerPackageVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RegisterPackageVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return registerPackageVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$registerPackageVersion$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveApplicationInstanceResponse removeApplicationInstance(RemoveApplicationInstanceRequest removeApplicationInstanceRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveApplicationInstanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(this.clientConfiguration, removeApplicationInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveApplicationInstance");
            RemoveApplicationInstanceResponse removeApplicationInstanceResponse = (RemoveApplicationInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveApplicationInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeApplicationInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveApplicationInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeApplicationInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$removeApplicationInstance$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$tagResource$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$untagResource$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDeviceMetadataResponse updateDeviceMetadata(UpdateDeviceMetadataRequest updateDeviceMetadataRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, PanoramaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDeviceMetadataResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPanoramaClient.resolveMetricPublishers(this.clientConfiguration, updateDeviceMetadataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Panorama");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDeviceMetadata");
            UpdateDeviceMetadataResponse updateDeviceMetadataResponse = (UpdateDeviceMetadataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDeviceMetadata").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDeviceMetadataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDeviceMetadataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDeviceMetadataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPanoramaClient.lambda$updateDeviceMetadata$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(PanoramaException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends PanoramaRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.208").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((PanoramaRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateDeviceMetadata$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeApplicationInstance$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerPackageVersion$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$provisionDevice$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPackages$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPackageImportJobs$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listNodes$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listNodeFromTemplateJobs$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDevicesJobs$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDevices$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listApplicationInstances$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listApplicationInstanceNodeInstances$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listApplicationInstanceDependencies$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describePackageVersion$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describePackageImportJob$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describePackage$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeNodeFromTemplateJob$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeNode$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDeviceJob$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDevice$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeApplicationInstanceDetails$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeApplicationInstance$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deregisterPackageVersion$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePackage$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDevice$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPackageImportJob$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPackage$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createNodeFromTemplateJob$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createJobForDevices$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createApplicationInstance$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

