/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PackageVersionOutputConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PackageVersionOutputConfig> {
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageName").getter(PackageVersionOutputConfig.getter(PackageVersionOutputConfig::packageName)).setter(PackageVersionOutputConfig.setter(Builder::packageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageName").build()}).build();
    private static final SdkField<String> PACKAGE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageVersion").getter(PackageVersionOutputConfig.getter(PackageVersionOutputConfig::packageVersion)).setter(PackageVersionOutputConfig.setter(Builder::packageVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageVersion").build()}).build();
    private static final SdkField<Boolean> MARK_LATEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MarkLatest").getter(PackageVersionOutputConfig.getter(PackageVersionOutputConfig::markLatest)).setter(PackageVersionOutputConfig.setter(Builder::markLatest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MarkLatest").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_NAME_FIELD, PACKAGE_VERSION_FIELD, MARK_LATEST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String packageName;
    private final String packageVersion;
    private final Boolean markLatest;

    private PackageVersionOutputConfig(BuilderImpl builder) {
        this.packageName = builder.packageName;
        this.packageVersion = builder.packageVersion;
        this.markLatest = builder.markLatest;
    }

    public final String packageName() {
        return this.packageName;
    }

    public final String packageVersion() {
        return this.packageVersion;
    }

    public final Boolean markLatest() {
        return this.markLatest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.packageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.markLatest());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageVersionOutputConfig)) {
            return false;
        }
        PackageVersionOutputConfig other = (PackageVersionOutputConfig)obj;
        return Objects.equals(this.packageName(), other.packageName()) && Objects.equals(this.packageVersion(), other.packageVersion()) && Objects.equals(this.markLatest(), other.markLatest());
    }

    public final String toString() {
        return ToString.builder((String)"PackageVersionOutputConfig").add("PackageName", (Object)this.packageName()).add("PackageVersion", (Object)this.packageVersion()).add("MarkLatest", (Object)this.markLatest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PackageName": {
                return Optional.ofNullable(clazz.cast(this.packageName()));
            }
            case "PackageVersion": {
                return Optional.ofNullable(clazz.cast(this.packageVersion()));
            }
            case "MarkLatest": {
                return Optional.ofNullable(clazz.cast(this.markLatest()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PackageVersionOutputConfig, T> g) {
        return obj -> g.apply((PackageVersionOutputConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String packageName;
        private String packageVersion;
        private Boolean markLatest;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageVersionOutputConfig model) {
            this.packageName(model.packageName);
            this.packageVersion(model.packageVersion);
            this.markLatest(model.markLatest);
        }

        public final String getPackageName() {
            return this.packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        @Transient
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getPackageVersion() {
            return this.packageVersion;
        }

        public final void setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
        }

        @Override
        @Transient
        public final Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        public final Boolean getMarkLatest() {
            return this.markLatest;
        }

        public final void setMarkLatest(Boolean markLatest) {
            this.markLatest = markLatest;
        }

        @Override
        @Transient
        public final Builder markLatest(Boolean markLatest) {
            this.markLatest = markLatest;
            return this;
        }

        public PackageVersionOutputConfig build() {
            return new PackageVersionOutputConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PackageVersionOutputConfig> {
        public Builder packageName(String var1);

        public Builder packageVersion(String var1);

        public Builder markLatest(Boolean var1);
    }
}

