/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.panorama.model.DeviceConnectionStatus;
import software.amazon.awssdk.services.panorama.model.DeviceStatus;
import software.amazon.awssdk.services.panorama.model.DeviceType;
import software.amazon.awssdk.services.panorama.model.NetworkPayload;
import software.amazon.awssdk.services.panorama.model.NetworkStatus;
import software.amazon.awssdk.services.panorama.model.PanoramaResponse;
import software.amazon.awssdk.services.panorama.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDeviceResponse
extends PanoramaResponse
implements ToCopyableBuilder<Builder, DescribeDeviceResponse> {
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceId").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::deviceId)).setter(DescribeDeviceResponse.setter(Builder::deviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::name)).setter(DescribeDeviceResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::arn)).setter(DescribeDeviceResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::description)).setter(DescribeDeviceResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::typeAsString)).setter(DescribeDeviceResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> DEVICE_CONNECTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceConnectionStatus").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::deviceConnectionStatusAsString)).setter(DescribeDeviceResponse.setter(Builder::deviceConnectionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceConnectionStatus").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::createdTime)).setter(DescribeDeviceResponse.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> PROVISIONING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisioningStatus").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::provisioningStatusAsString)).setter(DescribeDeviceResponse.setter(Builder::provisioningStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningStatus").build()}).build();
    private static final SdkField<String> LATEST_SOFTWARE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestSoftware").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::latestSoftware)).setter(DescribeDeviceResponse.setter(Builder::latestSoftware)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestSoftware").build()}).build();
    private static final SdkField<String> CURRENT_SOFTWARE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentSoftware").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::currentSoftware)).setter(DescribeDeviceResponse.setter(Builder::currentSoftware)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentSoftware").build()}).build();
    private static final SdkField<String> SERIAL_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SerialNumber").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::serialNumber)).setter(DescribeDeviceResponse.setter(Builder::serialNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SerialNumber").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::tags)).setter(DescribeDeviceResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<NetworkPayload> NETWORKING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkingConfiguration").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::networkingConfiguration)).setter(DescribeDeviceResponse.setter(Builder::networkingConfiguration)).constructor(NetworkPayload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkingConfiguration").build()}).build();
    private static final SdkField<NetworkStatus> CURRENT_NETWORKING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CurrentNetworkingStatus").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::currentNetworkingStatus)).setter(DescribeDeviceResponse.setter(Builder::currentNetworkingStatus)).constructor(NetworkStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentNetworkingStatus").build()}).build();
    private static final SdkField<Instant> LEASE_EXPIRATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LeaseExpirationTime").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::leaseExpirationTime)).setter(DescribeDeviceResponse.setter(Builder::leaseExpirationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LeaseExpirationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_ID_FIELD, NAME_FIELD, ARN_FIELD, DESCRIPTION_FIELD, TYPE_FIELD, DEVICE_CONNECTION_STATUS_FIELD, CREATED_TIME_FIELD, PROVISIONING_STATUS_FIELD, LATEST_SOFTWARE_FIELD, CURRENT_SOFTWARE_FIELD, SERIAL_NUMBER_FIELD, TAGS_FIELD, NETWORKING_CONFIGURATION_FIELD, CURRENT_NETWORKING_STATUS_FIELD, LEASE_EXPIRATION_TIME_FIELD));
    private final String deviceId;
    private final String name;
    private final String arn;
    private final String description;
    private final String type;
    private final String deviceConnectionStatus;
    private final Instant createdTime;
    private final String provisioningStatus;
    private final String latestSoftware;
    private final String currentSoftware;
    private final String serialNumber;
    private final Map<String, String> tags;
    private final NetworkPayload networkingConfiguration;
    private final NetworkStatus currentNetworkingStatus;
    private final Instant leaseExpirationTime;

    private DescribeDeviceResponse(BuilderImpl builder) {
        super(builder);
        this.deviceId = builder.deviceId;
        this.name = builder.name;
        this.arn = builder.arn;
        this.description = builder.description;
        this.type = builder.type;
        this.deviceConnectionStatus = builder.deviceConnectionStatus;
        this.createdTime = builder.createdTime;
        this.provisioningStatus = builder.provisioningStatus;
        this.latestSoftware = builder.latestSoftware;
        this.currentSoftware = builder.currentSoftware;
        this.serialNumber = builder.serialNumber;
        this.tags = builder.tags;
        this.networkingConfiguration = builder.networkingConfiguration;
        this.currentNetworkingStatus = builder.currentNetworkingStatus;
        this.leaseExpirationTime = builder.leaseExpirationTime;
    }

    public final String deviceId() {
        return this.deviceId;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final String description() {
        return this.description;
    }

    public final DeviceType type() {
        return DeviceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final DeviceConnectionStatus deviceConnectionStatus() {
        return DeviceConnectionStatus.fromValue(this.deviceConnectionStatus);
    }

    public final String deviceConnectionStatusAsString() {
        return this.deviceConnectionStatus;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final DeviceStatus provisioningStatus() {
        return DeviceStatus.fromValue(this.provisioningStatus);
    }

    public final String provisioningStatusAsString() {
        return this.provisioningStatus;
    }

    public final String latestSoftware() {
        return this.latestSoftware;
    }

    public final String currentSoftware() {
        return this.currentSoftware;
    }

    public final String serialNumber() {
        return this.serialNumber;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final NetworkPayload networkingConfiguration() {
        return this.networkingConfiguration;
    }

    public final NetworkStatus currentNetworkingStatus() {
        return this.currentNetworkingStatus;
    }

    public final Instant leaseExpirationTime() {
        return this.leaseExpirationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceConnectionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestSoftware());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentSoftware());
        hashCode = 31 * hashCode + Objects.hashCode(this.serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.networkingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentNetworkingStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.leaseExpirationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeviceResponse)) {
            return false;
        }
        DescribeDeviceResponse other = (DescribeDeviceResponse)((Object)obj);
        return Objects.equals(this.deviceId(), other.deviceId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.deviceConnectionStatusAsString(), other.deviceConnectionStatusAsString()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.provisioningStatusAsString(), other.provisioningStatusAsString()) && Objects.equals(this.latestSoftware(), other.latestSoftware()) && Objects.equals(this.currentSoftware(), other.currentSoftware()) && Objects.equals(this.serialNumber(), other.serialNumber()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.networkingConfiguration(), other.networkingConfiguration()) && Objects.equals(this.currentNetworkingStatus(), other.currentNetworkingStatus()) && Objects.equals(this.leaseExpirationTime(), other.leaseExpirationTime());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDeviceResponse").add("DeviceId", (Object)this.deviceId()).add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("Description", (Object)this.description()).add("Type", (Object)this.typeAsString()).add("DeviceConnectionStatus", (Object)this.deviceConnectionStatusAsString()).add("CreatedTime", (Object)this.createdTime()).add("ProvisioningStatus", (Object)this.provisioningStatusAsString()).add("LatestSoftware", (Object)this.latestSoftware()).add("CurrentSoftware", (Object)this.currentSoftware()).add("SerialNumber", (Object)this.serialNumber()).add("Tags", this.hasTags() ? this.tags() : null).add("NetworkingConfiguration", (Object)this.networkingConfiguration()).add("CurrentNetworkingStatus", (Object)this.currentNetworkingStatus()).add("LeaseExpirationTime", (Object)this.leaseExpirationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceId": {
                return Optional.ofNullable(clazz.cast(this.deviceId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "DeviceConnectionStatus": {
                return Optional.ofNullable(clazz.cast(this.deviceConnectionStatusAsString()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "ProvisioningStatus": {
                return Optional.ofNullable(clazz.cast(this.provisioningStatusAsString()));
            }
            case "LatestSoftware": {
                return Optional.ofNullable(clazz.cast(this.latestSoftware()));
            }
            case "CurrentSoftware": {
                return Optional.ofNullable(clazz.cast(this.currentSoftware()));
            }
            case "SerialNumber": {
                return Optional.ofNullable(clazz.cast(this.serialNumber()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "NetworkingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkingConfiguration()));
            }
            case "CurrentNetworkingStatus": {
                return Optional.ofNullable(clazz.cast(this.currentNetworkingStatus()));
            }
            case "LeaseExpirationTime": {
                return Optional.ofNullable(clazz.cast(this.leaseExpirationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDeviceResponse, T> g) {
        return obj -> g.apply((DescribeDeviceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PanoramaResponse.BuilderImpl
    implements Builder {
        private String deviceId;
        private String name;
        private String arn;
        private String description;
        private String type;
        private String deviceConnectionStatus;
        private Instant createdTime;
        private String provisioningStatus;
        private String latestSoftware;
        private String currentSoftware;
        private String serialNumber;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private NetworkPayload networkingConfiguration;
        private NetworkStatus currentNetworkingStatus;
        private Instant leaseExpirationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeviceResponse model) {
            super(model);
            this.deviceId(model.deviceId);
            this.name(model.name);
            this.arn(model.arn);
            this.description(model.description);
            this.type(model.type);
            this.deviceConnectionStatus(model.deviceConnectionStatus);
            this.createdTime(model.createdTime);
            this.provisioningStatus(model.provisioningStatus);
            this.latestSoftware(model.latestSoftware);
            this.currentSoftware(model.currentSoftware);
            this.serialNumber(model.serialNumber);
            this.tags(model.tags);
            this.networkingConfiguration(model.networkingConfiguration);
            this.currentNetworkingStatus(model.currentNetworkingStatus);
            this.leaseExpirationTime(model.leaseExpirationTime);
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        @Transient
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(DeviceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDeviceConnectionStatus() {
            return this.deviceConnectionStatus;
        }

        public final void setDeviceConnectionStatus(String deviceConnectionStatus) {
            this.deviceConnectionStatus = deviceConnectionStatus;
        }

        @Override
        @Transient
        public final Builder deviceConnectionStatus(String deviceConnectionStatus) {
            this.deviceConnectionStatus = deviceConnectionStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder deviceConnectionStatus(DeviceConnectionStatus deviceConnectionStatus) {
            this.deviceConnectionStatus(deviceConnectionStatus == null ? null : deviceConnectionStatus.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getProvisioningStatus() {
            return this.provisioningStatus;
        }

        public final void setProvisioningStatus(String provisioningStatus) {
            this.provisioningStatus = provisioningStatus;
        }

        @Override
        @Transient
        public final Builder provisioningStatus(String provisioningStatus) {
            this.provisioningStatus = provisioningStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder provisioningStatus(DeviceStatus provisioningStatus) {
            this.provisioningStatus(provisioningStatus == null ? null : provisioningStatus.toString());
            return this;
        }

        public final String getLatestSoftware() {
            return this.latestSoftware;
        }

        public final void setLatestSoftware(String latestSoftware) {
            this.latestSoftware = latestSoftware;
        }

        @Override
        @Transient
        public final Builder latestSoftware(String latestSoftware) {
            this.latestSoftware = latestSoftware;
            return this;
        }

        public final String getCurrentSoftware() {
            return this.currentSoftware;
        }

        public final void setCurrentSoftware(String currentSoftware) {
            this.currentSoftware = currentSoftware;
        }

        @Override
        @Transient
        public final Builder currentSoftware(String currentSoftware) {
            this.currentSoftware = currentSoftware;
            return this;
        }

        public final String getSerialNumber() {
            return this.serialNumber;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        @Override
        @Transient
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final NetworkPayload.Builder getNetworkingConfiguration() {
            return this.networkingConfiguration != null ? this.networkingConfiguration.toBuilder() : null;
        }

        public final void setNetworkingConfiguration(NetworkPayload.BuilderImpl networkingConfiguration) {
            this.networkingConfiguration = networkingConfiguration != null ? networkingConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder networkingConfiguration(NetworkPayload networkingConfiguration) {
            this.networkingConfiguration = networkingConfiguration;
            return this;
        }

        public final NetworkStatus.Builder getCurrentNetworkingStatus() {
            return this.currentNetworkingStatus != null ? this.currentNetworkingStatus.toBuilder() : null;
        }

        public final void setCurrentNetworkingStatus(NetworkStatus.BuilderImpl currentNetworkingStatus) {
            this.currentNetworkingStatus = currentNetworkingStatus != null ? currentNetworkingStatus.build() : null;
        }

        @Override
        @Transient
        public final Builder currentNetworkingStatus(NetworkStatus currentNetworkingStatus) {
            this.currentNetworkingStatus = currentNetworkingStatus;
            return this;
        }

        public final Instant getLeaseExpirationTime() {
            return this.leaseExpirationTime;
        }

        public final void setLeaseExpirationTime(Instant leaseExpirationTime) {
            this.leaseExpirationTime = leaseExpirationTime;
        }

        @Override
        @Transient
        public final Builder leaseExpirationTime(Instant leaseExpirationTime) {
            this.leaseExpirationTime = leaseExpirationTime;
            return this;
        }

        @Override
        public DescribeDeviceResponse build() {
            return new DescribeDeviceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PanoramaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDeviceResponse> {
        public Builder deviceId(String var1);

        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder description(String var1);

        public Builder type(String var1);

        public Builder type(DeviceType var1);

        public Builder deviceConnectionStatus(String var1);

        public Builder deviceConnectionStatus(DeviceConnectionStatus var1);

        public Builder createdTime(Instant var1);

        public Builder provisioningStatus(String var1);

        public Builder provisioningStatus(DeviceStatus var1);

        public Builder latestSoftware(String var1);

        public Builder currentSoftware(String var1);

        public Builder serialNumber(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder networkingConfiguration(NetworkPayload var1);

        default public Builder networkingConfiguration(Consumer<NetworkPayload.Builder> networkingConfiguration) {
            return this.networkingConfiguration((NetworkPayload)((NetworkPayload.Builder)NetworkPayload.builder().applyMutation(networkingConfiguration)).build());
        }

        public Builder currentNetworkingStatus(NetworkStatus var1);

        default public Builder currentNetworkingStatus(Consumer<NetworkStatus.Builder> currentNetworkingStatus) {
            return this.currentNetworkingStatus((NetworkStatus)((NetworkStatus.Builder)NetworkStatus.builder().applyMutation(currentNetworkingStatus)).build());
        }

        public Builder leaseExpirationTime(Instant var1);
    }
}

