/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.panorama.model.ManifestOverridesPayload;
import software.amazon.awssdk.services.panorama.model.ManifestPayload;
import software.amazon.awssdk.services.panorama.model.PanoramaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeApplicationInstanceDetailsResponse
extends PanoramaResponse
implements ToCopyableBuilder<Builder, DescribeApplicationInstanceDetailsResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeApplicationInstanceDetailsResponse.getter(DescribeApplicationInstanceDetailsResponse::name)).setter(DescribeApplicationInstanceDetailsResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeApplicationInstanceDetailsResponse.getter(DescribeApplicationInstanceDetailsResponse::description)).setter(DescribeApplicationInstanceDetailsResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DEFAULT_RUNTIME_CONTEXT_DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultRuntimeContextDevice").getter(DescribeApplicationInstanceDetailsResponse.getter(DescribeApplicationInstanceDetailsResponse::defaultRuntimeContextDevice)).setter(DescribeApplicationInstanceDetailsResponse.setter(Builder::defaultRuntimeContextDevice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRuntimeContextDevice").build()}).build();
    private static final SdkField<ManifestPayload> MANIFEST_PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ManifestPayload").getter(DescribeApplicationInstanceDetailsResponse.getter(DescribeApplicationInstanceDetailsResponse::manifestPayload)).setter(DescribeApplicationInstanceDetailsResponse.setter(Builder::manifestPayload)).constructor(ManifestPayload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestPayload").build()}).build();
    private static final SdkField<ManifestOverridesPayload> MANIFEST_OVERRIDES_PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ManifestOverridesPayload").getter(DescribeApplicationInstanceDetailsResponse.getter(DescribeApplicationInstanceDetailsResponse::manifestOverridesPayload)).setter(DescribeApplicationInstanceDetailsResponse.setter(Builder::manifestOverridesPayload)).constructor(ManifestOverridesPayload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestOverridesPayload").build()}).build();
    private static final SdkField<String> APPLICATION_INSTANCE_ID_TO_REPLACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationInstanceIdToReplace").getter(DescribeApplicationInstanceDetailsResponse.getter(DescribeApplicationInstanceDetailsResponse::applicationInstanceIdToReplace)).setter(DescribeApplicationInstanceDetailsResponse.setter(Builder::applicationInstanceIdToReplace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationInstanceIdToReplace").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(DescribeApplicationInstanceDetailsResponse.getter(DescribeApplicationInstanceDetailsResponse::createdTime)).setter(DescribeApplicationInstanceDetailsResponse.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> APPLICATION_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationInstanceId").getter(DescribeApplicationInstanceDetailsResponse.getter(DescribeApplicationInstanceDetailsResponse::applicationInstanceId)).setter(DescribeApplicationInstanceDetailsResponse.setter(Builder::applicationInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationInstanceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, DEFAULT_RUNTIME_CONTEXT_DEVICE_FIELD, MANIFEST_PAYLOAD_FIELD, MANIFEST_OVERRIDES_PAYLOAD_FIELD, APPLICATION_INSTANCE_ID_TO_REPLACE_FIELD, CREATED_TIME_FIELD, APPLICATION_INSTANCE_ID_FIELD));
    private final String name;
    private final String description;
    private final String defaultRuntimeContextDevice;
    private final ManifestPayload manifestPayload;
    private final ManifestOverridesPayload manifestOverridesPayload;
    private final String applicationInstanceIdToReplace;
    private final Instant createdTime;
    private final String applicationInstanceId;

    private DescribeApplicationInstanceDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.defaultRuntimeContextDevice = builder.defaultRuntimeContextDevice;
        this.manifestPayload = builder.manifestPayload;
        this.manifestOverridesPayload = builder.manifestOverridesPayload;
        this.applicationInstanceIdToReplace = builder.applicationInstanceIdToReplace;
        this.createdTime = builder.createdTime;
        this.applicationInstanceId = builder.applicationInstanceId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String defaultRuntimeContextDevice() {
        return this.defaultRuntimeContextDevice;
    }

    public final ManifestPayload manifestPayload() {
        return this.manifestPayload;
    }

    public final ManifestOverridesPayload manifestOverridesPayload() {
        return this.manifestOverridesPayload;
    }

    public final String applicationInstanceIdToReplace() {
        return this.applicationInstanceIdToReplace;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String applicationInstanceId() {
        return this.applicationInstanceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultRuntimeContextDevice());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestPayload());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestOverridesPayload());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationInstanceIdToReplace());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationInstanceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationInstanceDetailsResponse)) {
            return false;
        }
        DescribeApplicationInstanceDetailsResponse other = (DescribeApplicationInstanceDetailsResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.defaultRuntimeContextDevice(), other.defaultRuntimeContextDevice()) && Objects.equals(this.manifestPayload(), other.manifestPayload()) && Objects.equals(this.manifestOverridesPayload(), other.manifestOverridesPayload()) && Objects.equals(this.applicationInstanceIdToReplace(), other.applicationInstanceIdToReplace()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.applicationInstanceId(), other.applicationInstanceId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeApplicationInstanceDetailsResponse").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("DefaultRuntimeContextDevice", (Object)this.defaultRuntimeContextDevice()).add("ManifestPayload", (Object)this.manifestPayload()).add("ManifestOverridesPayload", (Object)this.manifestOverridesPayload()).add("ApplicationInstanceIdToReplace", (Object)this.applicationInstanceIdToReplace()).add("CreatedTime", (Object)this.createdTime()).add("ApplicationInstanceId", (Object)this.applicationInstanceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DefaultRuntimeContextDevice": {
                return Optional.ofNullable(clazz.cast(this.defaultRuntimeContextDevice()));
            }
            case "ManifestPayload": {
                return Optional.ofNullable(clazz.cast(this.manifestPayload()));
            }
            case "ManifestOverridesPayload": {
                return Optional.ofNullable(clazz.cast(this.manifestOverridesPayload()));
            }
            case "ApplicationInstanceIdToReplace": {
                return Optional.ofNullable(clazz.cast(this.applicationInstanceIdToReplace()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "ApplicationInstanceId": {
                return Optional.ofNullable(clazz.cast(this.applicationInstanceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeApplicationInstanceDetailsResponse, T> g) {
        return obj -> g.apply((DescribeApplicationInstanceDetailsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PanoramaResponse.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String defaultRuntimeContextDevice;
        private ManifestPayload manifestPayload;
        private ManifestOverridesPayload manifestOverridesPayload;
        private String applicationInstanceIdToReplace;
        private Instant createdTime;
        private String applicationInstanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationInstanceDetailsResponse model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.defaultRuntimeContextDevice(model.defaultRuntimeContextDevice);
            this.manifestPayload(model.manifestPayload);
            this.manifestOverridesPayload(model.manifestOverridesPayload);
            this.applicationInstanceIdToReplace(model.applicationInstanceIdToReplace);
            this.createdTime(model.createdTime);
            this.applicationInstanceId(model.applicationInstanceId);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDefaultRuntimeContextDevice() {
            return this.defaultRuntimeContextDevice;
        }

        public final void setDefaultRuntimeContextDevice(String defaultRuntimeContextDevice) {
            this.defaultRuntimeContextDevice = defaultRuntimeContextDevice;
        }

        @Override
        @Transient
        public final Builder defaultRuntimeContextDevice(String defaultRuntimeContextDevice) {
            this.defaultRuntimeContextDevice = defaultRuntimeContextDevice;
            return this;
        }

        public final ManifestPayload.Builder getManifestPayload() {
            return this.manifestPayload != null ? this.manifestPayload.toBuilder() : null;
        }

        public final void setManifestPayload(ManifestPayload.BuilderImpl manifestPayload) {
            this.manifestPayload = manifestPayload != null ? manifestPayload.build() : null;
        }

        @Override
        @Transient
        public final Builder manifestPayload(ManifestPayload manifestPayload) {
            this.manifestPayload = manifestPayload;
            return this;
        }

        public final ManifestOverridesPayload.Builder getManifestOverridesPayload() {
            return this.manifestOverridesPayload != null ? this.manifestOverridesPayload.toBuilder() : null;
        }

        public final void setManifestOverridesPayload(ManifestOverridesPayload.BuilderImpl manifestOverridesPayload) {
            this.manifestOverridesPayload = manifestOverridesPayload != null ? manifestOverridesPayload.build() : null;
        }

        @Override
        @Transient
        public final Builder manifestOverridesPayload(ManifestOverridesPayload manifestOverridesPayload) {
            this.manifestOverridesPayload = manifestOverridesPayload;
            return this;
        }

        public final String getApplicationInstanceIdToReplace() {
            return this.applicationInstanceIdToReplace;
        }

        public final void setApplicationInstanceIdToReplace(String applicationInstanceIdToReplace) {
            this.applicationInstanceIdToReplace = applicationInstanceIdToReplace;
        }

        @Override
        @Transient
        public final Builder applicationInstanceIdToReplace(String applicationInstanceIdToReplace) {
            this.applicationInstanceIdToReplace = applicationInstanceIdToReplace;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getApplicationInstanceId() {
            return this.applicationInstanceId;
        }

        public final void setApplicationInstanceId(String applicationInstanceId) {
            this.applicationInstanceId = applicationInstanceId;
        }

        @Override
        @Transient
        public final Builder applicationInstanceId(String applicationInstanceId) {
            this.applicationInstanceId = applicationInstanceId;
            return this;
        }

        @Override
        public DescribeApplicationInstanceDetailsResponse build() {
            return new DescribeApplicationInstanceDetailsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PanoramaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeApplicationInstanceDetailsResponse> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder defaultRuntimeContextDevice(String var1);

        public Builder manifestPayload(ManifestPayload var1);

        default public Builder manifestPayload(Consumer<ManifestPayload.Builder> manifestPayload) {
            return this.manifestPayload((ManifestPayload)((ManifestPayload.Builder)ManifestPayload.builder().applyMutation(manifestPayload)).build());
        }

        public Builder manifestOverridesPayload(ManifestOverridesPayload var1);

        default public Builder manifestOverridesPayload(Consumer<ManifestOverridesPayload.Builder> manifestOverridesPayload) {
            return this.manifestOverridesPayload((ManifestOverridesPayload)((ManifestOverridesPayload.Builder)ManifestOverridesPayload.builder().applyMutation(manifestOverridesPayload)).build());
        }

        public Builder applicationInstanceIdToReplace(String var1);

        public Builder createdTime(Instant var1);

        public Builder applicationInstanceId(String var1);
    }
}

