/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.outposts.model.OrderIdListCopier;
import software.amazon.awssdk.services.outposts.model.SubscriptionStatus;
import software.amazon.awssdk.services.outposts.model.SubscriptionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Subscription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Subscription> {
    private static final SdkField<String> SUBSCRIPTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubscriptionId").getter(Subscription.getter(Subscription::subscriptionId)).setter(Subscription.setter(Builder::subscriptionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionId").build()}).build();
    private static final SdkField<String> SUBSCRIPTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubscriptionType").getter(Subscription.getter(Subscription::subscriptionTypeAsString)).setter(Subscription.setter(Builder::subscriptionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionType").build()}).build();
    private static final SdkField<String> SUBSCRIPTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubscriptionStatus").getter(Subscription.getter(Subscription::subscriptionStatusAsString)).setter(Subscription.setter(Builder::subscriptionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionStatus").build()}).build();
    private static final SdkField<List<String>> ORDER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrderIds").getter(Subscription.getter(Subscription::orderIds)).setter(Subscription.setter(Builder::orderIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> BEGIN_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("BeginDate").getter(Subscription.getter(Subscription::beginDate)).setter(Subscription.setter(Builder::beginDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginDate").build()}).build();
    private static final SdkField<Instant> END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndDate").getter(Subscription.getter(Subscription::endDate)).setter(Subscription.setter(Builder::endDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").build()}).build();
    private static final SdkField<Double> MONTHLY_RECURRING_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MonthlyRecurringPrice").getter(Subscription.getter(Subscription::monthlyRecurringPrice)).setter(Subscription.setter(Builder::monthlyRecurringPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonthlyRecurringPrice").build()}).build();
    private static final SdkField<Double> UPFRONT_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("UpfrontPrice").getter(Subscription.getter(Subscription::upfrontPrice)).setter(Subscription.setter(Builder::upfrontPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpfrontPrice").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTION_ID_FIELD, SUBSCRIPTION_TYPE_FIELD, SUBSCRIPTION_STATUS_FIELD, ORDER_IDS_FIELD, BEGIN_DATE_FIELD, END_DATE_FIELD, MONTHLY_RECURRING_PRICE_FIELD, UPFRONT_PRICE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Subscription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String subscriptionId;
    private final String subscriptionType;
    private final String subscriptionStatus;
    private final List<String> orderIds;
    private final Instant beginDate;
    private final Instant endDate;
    private final Double monthlyRecurringPrice;
    private final Double upfrontPrice;

    private Subscription(BuilderImpl builder) {
        this.subscriptionId = builder.subscriptionId;
        this.subscriptionType = builder.subscriptionType;
        this.subscriptionStatus = builder.subscriptionStatus;
        this.orderIds = builder.orderIds;
        this.beginDate = builder.beginDate;
        this.endDate = builder.endDate;
        this.monthlyRecurringPrice = builder.monthlyRecurringPrice;
        this.upfrontPrice = builder.upfrontPrice;
    }

    public final String subscriptionId() {
        return this.subscriptionId;
    }

    public final SubscriptionType subscriptionType() {
        return SubscriptionType.fromValue(this.subscriptionType);
    }

    public final String subscriptionTypeAsString() {
        return this.subscriptionType;
    }

    public final SubscriptionStatus subscriptionStatus() {
        return SubscriptionStatus.fromValue(this.subscriptionStatus);
    }

    public final String subscriptionStatusAsString() {
        return this.subscriptionStatus;
    }

    public final boolean hasOrderIds() {
        return this.orderIds != null && !(this.orderIds instanceof SdkAutoConstructList);
    }

    public final List<String> orderIds() {
        return this.orderIds;
    }

    public final Instant beginDate() {
        return this.beginDate;
    }

    public final Instant endDate() {
        return this.endDate;
    }

    public final Double monthlyRecurringPrice() {
        return this.monthlyRecurringPrice;
    }

    public final Double upfrontPrice() {
        return this.upfrontPrice;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrderIds() ? this.orderIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.beginDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.monthlyRecurringPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.upfrontPrice());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription)obj;
        return Objects.equals(this.subscriptionId(), other.subscriptionId()) && Objects.equals(this.subscriptionTypeAsString(), other.subscriptionTypeAsString()) && Objects.equals(this.subscriptionStatusAsString(), other.subscriptionStatusAsString()) && this.hasOrderIds() == other.hasOrderIds() && Objects.equals(this.orderIds(), other.orderIds()) && Objects.equals(this.beginDate(), other.beginDate()) && Objects.equals(this.endDate(), other.endDate()) && Objects.equals(this.monthlyRecurringPrice(), other.monthlyRecurringPrice()) && Objects.equals(this.upfrontPrice(), other.upfrontPrice());
    }

    public final String toString() {
        return ToString.builder((String)"Subscription").add("SubscriptionId", (Object)this.subscriptionId()).add("SubscriptionType", (Object)this.subscriptionTypeAsString()).add("SubscriptionStatus", (Object)this.subscriptionStatusAsString()).add("OrderIds", this.hasOrderIds() ? this.orderIds() : null).add("BeginDate", (Object)this.beginDate()).add("EndDate", (Object)this.endDate()).add("MonthlyRecurringPrice", (Object)this.monthlyRecurringPrice()).add("UpfrontPrice", (Object)this.upfrontPrice()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubscriptionId": {
                return Optional.ofNullable(clazz.cast(this.subscriptionId()));
            }
            case "SubscriptionType": {
                return Optional.ofNullable(clazz.cast(this.subscriptionTypeAsString()));
            }
            case "SubscriptionStatus": {
                return Optional.ofNullable(clazz.cast(this.subscriptionStatusAsString()));
            }
            case "OrderIds": {
                return Optional.ofNullable(clazz.cast(this.orderIds()));
            }
            case "BeginDate": {
                return Optional.ofNullable(clazz.cast(this.beginDate()));
            }
            case "EndDate": {
                return Optional.ofNullable(clazz.cast(this.endDate()));
            }
            case "MonthlyRecurringPrice": {
                return Optional.ofNullable(clazz.cast(this.monthlyRecurringPrice()));
            }
            case "UpfrontPrice": {
                return Optional.ofNullable(clazz.cast(this.upfrontPrice()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SubscriptionId", SUBSCRIPTION_ID_FIELD);
        map.put("SubscriptionType", SUBSCRIPTION_TYPE_FIELD);
        map.put("SubscriptionStatus", SUBSCRIPTION_STATUS_FIELD);
        map.put("OrderIds", ORDER_IDS_FIELD);
        map.put("BeginDate", BEGIN_DATE_FIELD);
        map.put("EndDate", END_DATE_FIELD);
        map.put("MonthlyRecurringPrice", MONTHLY_RECURRING_PRICE_FIELD);
        map.put("UpfrontPrice", UPFRONT_PRICE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Subscription, T> g) {
        return obj -> g.apply((Subscription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String subscriptionId;
        private String subscriptionType;
        private String subscriptionStatus;
        private List<String> orderIds = DefaultSdkAutoConstructList.getInstance();
        private Instant beginDate;
        private Instant endDate;
        private Double monthlyRecurringPrice;
        private Double upfrontPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(Subscription model) {
            this.subscriptionId(model.subscriptionId);
            this.subscriptionType(model.subscriptionType);
            this.subscriptionStatus(model.subscriptionStatus);
            this.orderIds(model.orderIds);
            this.beginDate(model.beginDate);
            this.endDate(model.endDate);
            this.monthlyRecurringPrice(model.monthlyRecurringPrice);
            this.upfrontPrice(model.upfrontPrice);
        }

        public final String getSubscriptionId() {
            return this.subscriptionId;
        }

        public final void setSubscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
        }

        @Override
        public final Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public final String getSubscriptionType() {
            return this.subscriptionType;
        }

        public final void setSubscriptionType(String subscriptionType) {
            this.subscriptionType = subscriptionType;
        }

        @Override
        public final Builder subscriptionType(String subscriptionType) {
            this.subscriptionType = subscriptionType;
            return this;
        }

        @Override
        public final Builder subscriptionType(SubscriptionType subscriptionType) {
            this.subscriptionType(subscriptionType == null ? null : subscriptionType.toString());
            return this;
        }

        public final String getSubscriptionStatus() {
            return this.subscriptionStatus;
        }

        public final void setSubscriptionStatus(String subscriptionStatus) {
            this.subscriptionStatus = subscriptionStatus;
        }

        @Override
        public final Builder subscriptionStatus(String subscriptionStatus) {
            this.subscriptionStatus = subscriptionStatus;
            return this;
        }

        @Override
        public final Builder subscriptionStatus(SubscriptionStatus subscriptionStatus) {
            this.subscriptionStatus(subscriptionStatus == null ? null : subscriptionStatus.toString());
            return this;
        }

        public final Collection<String> getOrderIds() {
            if (this.orderIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.orderIds;
        }

        public final void setOrderIds(Collection<String> orderIds) {
            this.orderIds = OrderIdListCopier.copy(orderIds);
        }

        @Override
        public final Builder orderIds(Collection<String> orderIds) {
            this.orderIds = OrderIdListCopier.copy(orderIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderIds(String ... orderIds) {
            this.orderIds(Arrays.asList(orderIds));
            return this;
        }

        public final Instant getBeginDate() {
            return this.beginDate;
        }

        public final void setBeginDate(Instant beginDate) {
            this.beginDate = beginDate;
        }

        @Override
        public final Builder beginDate(Instant beginDate) {
            this.beginDate = beginDate;
            return this;
        }

        public final Instant getEndDate() {
            return this.endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final Double getMonthlyRecurringPrice() {
            return this.monthlyRecurringPrice;
        }

        public final void setMonthlyRecurringPrice(Double monthlyRecurringPrice) {
            this.monthlyRecurringPrice = monthlyRecurringPrice;
        }

        @Override
        public final Builder monthlyRecurringPrice(Double monthlyRecurringPrice) {
            this.monthlyRecurringPrice = monthlyRecurringPrice;
            return this;
        }

        public final Double getUpfrontPrice() {
            return this.upfrontPrice;
        }

        public final void setUpfrontPrice(Double upfrontPrice) {
            this.upfrontPrice = upfrontPrice;
        }

        @Override
        public final Builder upfrontPrice(Double upfrontPrice) {
            this.upfrontPrice = upfrontPrice;
            return this;
        }

        public Subscription build() {
            return new Subscription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Subscription> {
        public Builder subscriptionId(String var1);

        public Builder subscriptionType(String var1);

        public Builder subscriptionType(SubscriptionType var1);

        public Builder subscriptionStatus(String var1);

        public Builder subscriptionStatus(SubscriptionStatus var1);

        public Builder orderIds(Collection<String> var1);

        public Builder orderIds(String ... var1);

        public Builder beginDate(Instant var1);

        public Builder endDate(Instant var1);

        public Builder monthlyRecurringPrice(Double var1);

        public Builder upfrontPrice(Double var1);
    }
}

