/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.outposts.model.LineItem;
import software.amazon.awssdk.services.outposts.model.LineItemListDefinitionCopier;
import software.amazon.awssdk.services.outposts.model.OrderStatus;
import software.amazon.awssdk.services.outposts.model.OrderType;
import software.amazon.awssdk.services.outposts.model.PaymentOption;
import software.amazon.awssdk.services.outposts.model.PaymentTerm;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Order
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Order> {
    private static final SdkField<String> OUTPOST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostId").getter(Order.getter(Order::outpostId)).setter(Order.setter(Builder::outpostId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostId").build()}).build();
    private static final SdkField<String> ORDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrderId").getter(Order.getter(Order::orderId)).setter(Order.setter(Builder::orderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Order.getter(Order::statusAsString)).setter(Order.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<LineItem>> LINE_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LineItems").getter(Order.getter(Order::lineItems)).setter(Order.setter(Builder::lineItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LineItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PaymentOption").getter(Order.getter(Order::paymentOptionAsString)).setter(Order.setter(Builder::paymentOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentOption").build()}).build();
    private static final SdkField<Instant> ORDER_SUBMISSION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("OrderSubmissionDate").getter(Order.getter(Order::orderSubmissionDate)).setter(Order.setter(Builder::orderSubmissionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderSubmissionDate").build()}).build();
    private static final SdkField<Instant> ORDER_FULFILLED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("OrderFulfilledDate").getter(Order.getter(Order::orderFulfilledDate)).setter(Order.setter(Builder::orderFulfilledDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderFulfilledDate").build()}).build();
    private static final SdkField<String> PAYMENT_TERM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PaymentTerm").getter(Order.getter(Order::paymentTermAsString)).setter(Order.setter(Builder::paymentTerm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentTerm").build()}).build();
    private static final SdkField<String> ORDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrderType").getter(Order.getter(Order::orderTypeAsString)).setter(Order.setter(Builder::orderType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPOST_ID_FIELD, ORDER_ID_FIELD, STATUS_FIELD, LINE_ITEMS_FIELD, PAYMENT_OPTION_FIELD, ORDER_SUBMISSION_DATE_FIELD, ORDER_FULFILLED_DATE_FIELD, PAYMENT_TERM_FIELD, ORDER_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Order.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String outpostId;
    private final String orderId;
    private final String status;
    private final List<LineItem> lineItems;
    private final String paymentOption;
    private final Instant orderSubmissionDate;
    private final Instant orderFulfilledDate;
    private final String paymentTerm;
    private final String orderType;

    private Order(BuilderImpl builder) {
        this.outpostId = builder.outpostId;
        this.orderId = builder.orderId;
        this.status = builder.status;
        this.lineItems = builder.lineItems;
        this.paymentOption = builder.paymentOption;
        this.orderSubmissionDate = builder.orderSubmissionDate;
        this.orderFulfilledDate = builder.orderFulfilledDate;
        this.paymentTerm = builder.paymentTerm;
        this.orderType = builder.orderType;
    }

    public final String outpostId() {
        return this.outpostId;
    }

    public final String orderId() {
        return this.orderId;
    }

    public final OrderStatus status() {
        return OrderStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasLineItems() {
        return this.lineItems != null && !(this.lineItems instanceof SdkAutoConstructList);
    }

    public final List<LineItem> lineItems() {
        return this.lineItems;
    }

    public final PaymentOption paymentOption() {
        return PaymentOption.fromValue(this.paymentOption);
    }

    public final String paymentOptionAsString() {
        return this.paymentOption;
    }

    public final Instant orderSubmissionDate() {
        return this.orderSubmissionDate;
    }

    public final Instant orderFulfilledDate() {
        return this.orderFulfilledDate;
    }

    public final PaymentTerm paymentTerm() {
        return PaymentTerm.fromValue(this.paymentTerm);
    }

    public final String paymentTermAsString() {
        return this.paymentTerm;
    }

    public final OrderType orderType() {
        return OrderType.fromValue(this.orderType);
    }

    public final String orderTypeAsString() {
        return this.orderType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostId());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLineItems() ? this.lineItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderSubmissionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderFulfilledDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.paymentTermAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Order)) {
            return false;
        }
        Order other = (Order)obj;
        return Objects.equals(this.outpostId(), other.outpostId()) && Objects.equals(this.orderId(), other.orderId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasLineItems() == other.hasLineItems() && Objects.equals(this.lineItems(), other.lineItems()) && Objects.equals(this.paymentOptionAsString(), other.paymentOptionAsString()) && Objects.equals(this.orderSubmissionDate(), other.orderSubmissionDate()) && Objects.equals(this.orderFulfilledDate(), other.orderFulfilledDate()) && Objects.equals(this.paymentTermAsString(), other.paymentTermAsString()) && Objects.equals(this.orderTypeAsString(), other.orderTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Order").add("OutpostId", (Object)this.outpostId()).add("OrderId", (Object)this.orderId()).add("Status", (Object)this.statusAsString()).add("LineItems", this.hasLineItems() ? this.lineItems() : null).add("PaymentOption", (Object)this.paymentOptionAsString()).add("OrderSubmissionDate", (Object)this.orderSubmissionDate()).add("OrderFulfilledDate", (Object)this.orderFulfilledDate()).add("PaymentTerm", (Object)this.paymentTermAsString()).add("OrderType", (Object)this.orderTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutpostId": {
                return Optional.ofNullable(clazz.cast(this.outpostId()));
            }
            case "OrderId": {
                return Optional.ofNullable(clazz.cast(this.orderId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "LineItems": {
                return Optional.ofNullable(clazz.cast(this.lineItems()));
            }
            case "PaymentOption": {
                return Optional.ofNullable(clazz.cast(this.paymentOptionAsString()));
            }
            case "OrderSubmissionDate": {
                return Optional.ofNullable(clazz.cast(this.orderSubmissionDate()));
            }
            case "OrderFulfilledDate": {
                return Optional.ofNullable(clazz.cast(this.orderFulfilledDate()));
            }
            case "PaymentTerm": {
                return Optional.ofNullable(clazz.cast(this.paymentTermAsString()));
            }
            case "OrderType": {
                return Optional.ofNullable(clazz.cast(this.orderTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OutpostId", OUTPOST_ID_FIELD);
        map.put("OrderId", ORDER_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("LineItems", LINE_ITEMS_FIELD);
        map.put("PaymentOption", PAYMENT_OPTION_FIELD);
        map.put("OrderSubmissionDate", ORDER_SUBMISSION_DATE_FIELD);
        map.put("OrderFulfilledDate", ORDER_FULFILLED_DATE_FIELD);
        map.put("PaymentTerm", PAYMENT_TERM_FIELD);
        map.put("OrderType", ORDER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Order, T> g) {
        return obj -> g.apply((Order)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String outpostId;
        private String orderId;
        private String status;
        private List<LineItem> lineItems = DefaultSdkAutoConstructList.getInstance();
        private String paymentOption;
        private Instant orderSubmissionDate;
        private Instant orderFulfilledDate;
        private String paymentTerm;
        private String orderType;

        private BuilderImpl() {
        }

        private BuilderImpl(Order model) {
            this.outpostId(model.outpostId);
            this.orderId(model.orderId);
            this.status(model.status);
            this.lineItems(model.lineItems);
            this.paymentOption(model.paymentOption);
            this.orderSubmissionDate(model.orderSubmissionDate);
            this.orderFulfilledDate(model.orderFulfilledDate);
            this.paymentTerm(model.paymentTerm);
            this.orderType(model.orderType);
        }

        public final String getOutpostId() {
            return this.outpostId;
        }

        public final void setOutpostId(String outpostId) {
            this.outpostId = outpostId;
        }

        @Override
        public final Builder outpostId(String outpostId) {
            this.outpostId = outpostId;
            return this;
        }

        public final String getOrderId() {
            return this.orderId;
        }

        public final void setOrderId(String orderId) {
            this.orderId = orderId;
        }

        @Override
        public final Builder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OrderStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<LineItem.Builder> getLineItems() {
            List<LineItem.Builder> result = LineItemListDefinitionCopier.copyToBuilder(this.lineItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLineItems(Collection<LineItem.BuilderImpl> lineItems) {
            this.lineItems = LineItemListDefinitionCopier.copyFromBuilder(lineItems);
        }

        @Override
        public final Builder lineItems(Collection<LineItem> lineItems) {
            this.lineItems = LineItemListDefinitionCopier.copy(lineItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineItems(LineItem ... lineItems) {
            this.lineItems(Arrays.asList(lineItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineItems(Consumer<LineItem.Builder> ... lineItems) {
            this.lineItems(Stream.of(lineItems).map(c -> (LineItem)((LineItem.Builder)LineItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPaymentOption() {
            return this.paymentOption;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(PaymentOption paymentOption) {
            this.paymentOption(paymentOption == null ? null : paymentOption.toString());
            return this;
        }

        public final Instant getOrderSubmissionDate() {
            return this.orderSubmissionDate;
        }

        public final void setOrderSubmissionDate(Instant orderSubmissionDate) {
            this.orderSubmissionDate = orderSubmissionDate;
        }

        @Override
        public final Builder orderSubmissionDate(Instant orderSubmissionDate) {
            this.orderSubmissionDate = orderSubmissionDate;
            return this;
        }

        public final Instant getOrderFulfilledDate() {
            return this.orderFulfilledDate;
        }

        public final void setOrderFulfilledDate(Instant orderFulfilledDate) {
            this.orderFulfilledDate = orderFulfilledDate;
        }

        @Override
        public final Builder orderFulfilledDate(Instant orderFulfilledDate) {
            this.orderFulfilledDate = orderFulfilledDate;
            return this;
        }

        public final String getPaymentTerm() {
            return this.paymentTerm;
        }

        public final void setPaymentTerm(String paymentTerm) {
            this.paymentTerm = paymentTerm;
        }

        @Override
        public final Builder paymentTerm(String paymentTerm) {
            this.paymentTerm = paymentTerm;
            return this;
        }

        @Override
        public final Builder paymentTerm(PaymentTerm paymentTerm) {
            this.paymentTerm(paymentTerm == null ? null : paymentTerm.toString());
            return this;
        }

        public final String getOrderType() {
            return this.orderType;
        }

        public final void setOrderType(String orderType) {
            this.orderType = orderType;
        }

        @Override
        public final Builder orderType(String orderType) {
            this.orderType = orderType;
            return this;
        }

        @Override
        public final Builder orderType(OrderType orderType) {
            this.orderType(orderType == null ? null : orderType.toString());
            return this;
        }

        public Order build() {
            return new Order(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Order> {
        public Builder outpostId(String var1);

        public Builder orderId(String var1);

        public Builder status(String var1);

        public Builder status(OrderStatus var1);

        public Builder lineItems(Collection<LineItem> var1);

        public Builder lineItems(LineItem ... var1);

        public Builder lineItems(Consumer<LineItem.Builder> ... var1);

        public Builder paymentOption(String var1);

        public Builder paymentOption(PaymentOption var1);

        public Builder orderSubmissionDate(Instant var1);

        public Builder orderFulfilledDate(Instant var1);

        public Builder paymentTerm(String var1);

        public Builder paymentTerm(PaymentTerm var1);

        public Builder orderType(String var1);

        public Builder orderType(OrderType var1);
    }
}

