/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.outposts.model.AWSServiceName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BlockingInstance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BlockingInstance> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(BlockingInstance.getter(BlockingInstance::instanceId)).setter(BlockingInstance.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(BlockingInstance.getter(BlockingInstance::accountId)).setter(BlockingInstance.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> AWS_SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsServiceName").getter(BlockingInstance.getter(BlockingInstance::awsServiceNameAsString)).setter(BlockingInstance.setter(Builder::awsServiceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsServiceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, ACCOUNT_ID_FIELD, AWS_SERVICE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BlockingInstance.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String instanceId;
    private final String accountId;
    private final String awsServiceName;

    private BlockingInstance(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.accountId = builder.accountId;
        this.awsServiceName = builder.awsServiceName;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final AWSServiceName awsServiceName() {
        return AWSServiceName.fromValue(this.awsServiceName);
    }

    public final String awsServiceNameAsString() {
        return this.awsServiceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsServiceNameAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockingInstance)) {
            return false;
        }
        BlockingInstance other = (BlockingInstance)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.awsServiceNameAsString(), other.awsServiceNameAsString());
    }

    public final String toString() {
        return ToString.builder((String)"BlockingInstance").add("InstanceId", (Object)this.instanceId()).add("AccountId", (Object)this.accountId()).add("AwsServiceName", (Object)this.awsServiceNameAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "AwsServiceName": {
                return Optional.ofNullable(clazz.cast(this.awsServiceNameAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("AwsServiceName", AWS_SERVICE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BlockingInstance, T> g) {
        return obj -> g.apply((BlockingInstance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String accountId;
        private String awsServiceName;

        private BuilderImpl() {
        }

        private BuilderImpl(BlockingInstance model) {
            this.instanceId(model.instanceId);
            this.accountId(model.accountId);
            this.awsServiceName(model.awsServiceName);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getAwsServiceName() {
            return this.awsServiceName;
        }

        public final void setAwsServiceName(String awsServiceName) {
            this.awsServiceName = awsServiceName;
        }

        @Override
        public final Builder awsServiceName(String awsServiceName) {
            this.awsServiceName = awsServiceName;
            return this;
        }

        @Override
        public final Builder awsServiceName(AWSServiceName awsServiceName) {
            this.awsServiceName(awsServiceName == null ? null : awsServiceName.toString());
            return this;
        }

        public BlockingInstance build() {
            return new BlockingInstance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BlockingInstance> {
        public Builder instanceId(String var1);

        public Builder accountId(String var1);

        public Builder awsServiceName(String var1);

        public Builder awsServiceName(AWSServiceName var1);
    }
}

