/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.outposts.OutpostsAsyncClient;
import software.amazon.awssdk.services.outposts.internal.UserAgentUtils;
import software.amazon.awssdk.services.outposts.model.BlockingInstance;
import software.amazon.awssdk.services.outposts.model.ListBlockingInstancesForCapacityTaskRequest;
import software.amazon.awssdk.services.outposts.model.ListBlockingInstancesForCapacityTaskResponse;

public class ListBlockingInstancesForCapacityTaskPublisher
implements SdkPublisher<ListBlockingInstancesForCapacityTaskResponse> {
    private final OutpostsAsyncClient client;
    private final ListBlockingInstancesForCapacityTaskRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBlockingInstancesForCapacityTaskPublisher(OutpostsAsyncClient client, ListBlockingInstancesForCapacityTaskRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBlockingInstancesForCapacityTaskPublisher(OutpostsAsyncClient client, ListBlockingInstancesForCapacityTaskRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBlockingInstancesForCapacityTaskResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBlockingInstancesForCapacityTaskResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BlockingInstance> blockingInstances() {
        Function<ListBlockingInstancesForCapacityTaskResponse, Iterator> getIterator = response -> {
            if (response != null && response.blockingInstances() != null) {
                return response.blockingInstances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBlockingInstancesForCapacityTaskResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBlockingInstancesForCapacityTaskResponseFetcher
    implements AsyncPageFetcher<ListBlockingInstancesForCapacityTaskResponse> {
        private ListBlockingInstancesForCapacityTaskResponseFetcher() {
        }

        public boolean hasNextPage(ListBlockingInstancesForCapacityTaskResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBlockingInstancesForCapacityTaskResponse> nextPage(ListBlockingInstancesForCapacityTaskResponse previousPage) {
            if (previousPage == null) {
                return ListBlockingInstancesForCapacityTaskPublisher.this.client.listBlockingInstancesForCapacityTask(ListBlockingInstancesForCapacityTaskPublisher.this.firstRequest);
            }
            return ListBlockingInstancesForCapacityTaskPublisher.this.client.listBlockingInstancesForCapacityTask((ListBlockingInstancesForCapacityTaskRequest)((Object)ListBlockingInstancesForCapacityTaskPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

