/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LineItemRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LineItemRequest> {
    private static final SdkField<String> CATALOG_ITEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogItemId").getter(LineItemRequest.getter(LineItemRequest::catalogItemId)).setter(LineItemRequest.setter(Builder::catalogItemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogItemId").build()}).build();
    private static final SdkField<Integer> QUANTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Quantity").getter(LineItemRequest.getter(LineItemRequest::quantity)).setter(LineItemRequest.setter(Builder::quantity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ITEM_ID_FIELD, QUANTITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CatalogItemId", CATALOG_ITEM_ID_FIELD);
            this.put("Quantity", QUANTITY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String catalogItemId;
    private final Integer quantity;

    private LineItemRequest(BuilderImpl builder) {
        this.catalogItemId = builder.catalogItemId;
        this.quantity = builder.quantity;
    }

    public final String catalogItemId() {
        return this.catalogItemId;
    }

    public final Integer quantity() {
        return this.quantity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogItemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.quantity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineItemRequest)) {
            return false;
        }
        LineItemRequest other = (LineItemRequest)obj;
        return Objects.equals(this.catalogItemId(), other.catalogItemId()) && Objects.equals(this.quantity(), other.quantity());
    }

    public final String toString() {
        return ToString.builder((String)"LineItemRequest").add("CatalogItemId", (Object)this.catalogItemId()).add("Quantity", (Object)this.quantity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogItemId": {
                return Optional.ofNullable(clazz.cast(this.catalogItemId()));
            }
            case "Quantity": {
                return Optional.ofNullable(clazz.cast(this.quantity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LineItemRequest, T> g) {
        return obj -> g.apply((LineItemRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String catalogItemId;
        private Integer quantity;

        private BuilderImpl() {
        }

        private BuilderImpl(LineItemRequest model) {
            this.catalogItemId(model.catalogItemId);
            this.quantity(model.quantity);
        }

        public final String getCatalogItemId() {
            return this.catalogItemId;
        }

        public final void setCatalogItemId(String catalogItemId) {
            this.catalogItemId = catalogItemId;
        }

        @Override
        public final Builder catalogItemId(String catalogItemId) {
            this.catalogItemId = catalogItemId;
            return this;
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public LineItemRequest build() {
            return new LineItemRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LineItemRequest> {
        public Builder catalogItemId(String var1);

        public Builder quantity(Integer var1);
    }
}

