/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.outposts.model.CapacityTaskListCopier;
import software.amazon.awssdk.services.outposts.model.CapacityTaskSummary;
import software.amazon.awssdk.services.outposts.model.OutpostsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCapacityTasksResponse
extends OutpostsResponse
implements ToCopyableBuilder<Builder, ListCapacityTasksResponse> {
    private static final SdkField<List<CapacityTaskSummary>> CAPACITY_TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CapacityTasks").getter(ListCapacityTasksResponse.getter(ListCapacityTasksResponse::capacityTasks)).setter(ListCapacityTasksResponse.setter(Builder::capacityTasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityTasks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityTaskSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCapacityTasksResponse.getter(ListCapacityTasksResponse::nextToken)).setter(ListCapacityTasksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_TASKS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CapacityTasks", CAPACITY_TASKS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<CapacityTaskSummary> capacityTasks;
    private final String nextToken;

    private ListCapacityTasksResponse(BuilderImpl builder) {
        super(builder);
        this.capacityTasks = builder.capacityTasks;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCapacityTasks() {
        return this.capacityTasks != null && !(this.capacityTasks instanceof SdkAutoConstructList);
    }

    public final List<CapacityTaskSummary> capacityTasks() {
        return this.capacityTasks;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityTasks() ? this.capacityTasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCapacityTasksResponse)) {
            return false;
        }
        ListCapacityTasksResponse other = (ListCapacityTasksResponse)((Object)obj);
        return this.hasCapacityTasks() == other.hasCapacityTasks() && Objects.equals(this.capacityTasks(), other.capacityTasks()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCapacityTasksResponse").add("CapacityTasks", this.hasCapacityTasks() ? this.capacityTasks() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityTasks": {
                return Optional.ofNullable(clazz.cast(this.capacityTasks()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListCapacityTasksResponse, T> g) {
        return obj -> g.apply((ListCapacityTasksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OutpostsResponse.BuilderImpl
    implements Builder {
        private List<CapacityTaskSummary> capacityTasks = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCapacityTasksResponse model) {
            super(model);
            this.capacityTasks(model.capacityTasks);
            this.nextToken(model.nextToken);
        }

        public final List<CapacityTaskSummary.Builder> getCapacityTasks() {
            List<CapacityTaskSummary.Builder> result = CapacityTaskListCopier.copyToBuilder(this.capacityTasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityTasks(Collection<CapacityTaskSummary.BuilderImpl> capacityTasks) {
            this.capacityTasks = CapacityTaskListCopier.copyFromBuilder(capacityTasks);
        }

        @Override
        public final Builder capacityTasks(Collection<CapacityTaskSummary> capacityTasks) {
            this.capacityTasks = CapacityTaskListCopier.copy(capacityTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityTasks(CapacityTaskSummary ... capacityTasks) {
            this.capacityTasks(Arrays.asList(capacityTasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityTasks(Consumer<CapacityTaskSummary.Builder> ... capacityTasks) {
            this.capacityTasks(Stream.of(capacityTasks).map(c -> (CapacityTaskSummary)((CapacityTaskSummary.Builder)CapacityTaskSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCapacityTasksResponse build() {
            return new ListCapacityTasksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OutpostsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCapacityTasksResponse> {
        public Builder capacityTasks(Collection<CapacityTaskSummary> var1);

        public Builder capacityTasks(CapacityTaskSummary ... var1);

        public Builder capacityTasks(Consumer<CapacityTaskSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

