/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.outposts.model.Address;
import software.amazon.awssdk.services.outposts.model.OutpostsRequest;
import software.amazon.awssdk.services.outposts.model.RackPhysicalProperties;
import software.amazon.awssdk.services.outposts.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSiteRequest
extends OutpostsRequest
implements ToCopyableBuilder<Builder, CreateSiteRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateSiteRequest.getter(CreateSiteRequest::name)).setter(CreateSiteRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateSiteRequest.getter(CreateSiteRequest::description)).setter(CreateSiteRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> NOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Notes").getter(CreateSiteRequest.getter(CreateSiteRequest::notes)).setter(CreateSiteRequest.setter(Builder::notes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateSiteRequest.getter(CreateSiteRequest::tags)).setter(CreateSiteRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Address> OPERATING_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OperatingAddress").getter(CreateSiteRequest.getter(CreateSiteRequest::operatingAddress)).setter(CreateSiteRequest.setter(Builder::operatingAddress)).constructor(Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingAddress").build()}).build();
    private static final SdkField<Address> SHIPPING_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ShippingAddress").getter(CreateSiteRequest.getter(CreateSiteRequest::shippingAddress)).setter(CreateSiteRequest.setter(Builder::shippingAddress)).constructor(Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShippingAddress").build()}).build();
    private static final SdkField<RackPhysicalProperties> RACK_PHYSICAL_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RackPhysicalProperties").getter(CreateSiteRequest.getter(CreateSiteRequest::rackPhysicalProperties)).setter(CreateSiteRequest.setter(Builder::rackPhysicalProperties)).constructor(RackPhysicalProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RackPhysicalProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, NOTES_FIELD, TAGS_FIELD, OPERATING_ADDRESS_FIELD, SHIPPING_ADDRESS_FIELD, RACK_PHYSICAL_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("Notes", NOTES_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("OperatingAddress", OPERATING_ADDRESS_FIELD);
            this.put("ShippingAddress", SHIPPING_ADDRESS_FIELD);
            this.put("RackPhysicalProperties", RACK_PHYSICAL_PROPERTIES_FIELD);
        }
    });
    private final String name;
    private final String description;
    private final String notes;
    private final Map<String, String> tags;
    private final Address operatingAddress;
    private final Address shippingAddress;
    private final RackPhysicalProperties rackPhysicalProperties;

    private CreateSiteRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.notes = builder.notes;
        this.tags = builder.tags;
        this.operatingAddress = builder.operatingAddress;
        this.shippingAddress = builder.shippingAddress;
        this.rackPhysicalProperties = builder.rackPhysicalProperties;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String notes() {
        return this.notes;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Address operatingAddress() {
        return this.operatingAddress;
    }

    public final Address shippingAddress() {
        return this.shippingAddress;
    }

    public final RackPhysicalProperties rackPhysicalProperties() {
        return this.rackPhysicalProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.notes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.shippingAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.rackPhysicalProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSiteRequest)) {
            return false;
        }
        CreateSiteRequest other = (CreateSiteRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.notes(), other.notes()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.operatingAddress(), other.operatingAddress()) && Objects.equals(this.shippingAddress(), other.shippingAddress()) && Objects.equals(this.rackPhysicalProperties(), other.rackPhysicalProperties());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSiteRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Notes", (Object)this.notes()).add("Tags", this.hasTags() ? this.tags() : null).add("OperatingAddress", (Object)this.operatingAddress()).add("ShippingAddress", (Object)this.shippingAddress()).add("RackPhysicalProperties", (Object)this.rackPhysicalProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Notes": {
                return Optional.ofNullable(clazz.cast(this.notes()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "OperatingAddress": {
                return Optional.ofNullable(clazz.cast(this.operatingAddress()));
            }
            case "ShippingAddress": {
                return Optional.ofNullable(clazz.cast(this.shippingAddress()));
            }
            case "RackPhysicalProperties": {
                return Optional.ofNullable(clazz.cast(this.rackPhysicalProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateSiteRequest, T> g) {
        return obj -> g.apply((CreateSiteRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OutpostsRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String notes;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Address operatingAddress;
        private Address shippingAddress;
        private RackPhysicalProperties rackPhysicalProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSiteRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.notes(model.notes);
            this.tags(model.tags);
            this.operatingAddress(model.operatingAddress);
            this.shippingAddress(model.shippingAddress);
            this.rackPhysicalProperties(model.rackPhysicalProperties);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getNotes() {
            return this.notes;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Address.Builder getOperatingAddress() {
            return this.operatingAddress != null ? this.operatingAddress.toBuilder() : null;
        }

        public final void setOperatingAddress(Address.BuilderImpl operatingAddress) {
            this.operatingAddress = operatingAddress != null ? operatingAddress.build() : null;
        }

        @Override
        public final Builder operatingAddress(Address operatingAddress) {
            this.operatingAddress = operatingAddress;
            return this;
        }

        public final Address.Builder getShippingAddress() {
            return this.shippingAddress != null ? this.shippingAddress.toBuilder() : null;
        }

        public final void setShippingAddress(Address.BuilderImpl shippingAddress) {
            this.shippingAddress = shippingAddress != null ? shippingAddress.build() : null;
        }

        @Override
        public final Builder shippingAddress(Address shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        public final RackPhysicalProperties.Builder getRackPhysicalProperties() {
            return this.rackPhysicalProperties != null ? this.rackPhysicalProperties.toBuilder() : null;
        }

        public final void setRackPhysicalProperties(RackPhysicalProperties.BuilderImpl rackPhysicalProperties) {
            this.rackPhysicalProperties = rackPhysicalProperties != null ? rackPhysicalProperties.build() : null;
        }

        @Override
        public final Builder rackPhysicalProperties(RackPhysicalProperties rackPhysicalProperties) {
            this.rackPhysicalProperties = rackPhysicalProperties;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSiteRequest build() {
            return new CreateSiteRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OutpostsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSiteRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder notes(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder operatingAddress(Address var1);

        default public Builder operatingAddress(Consumer<Address.Builder> operatingAddress) {
            return this.operatingAddress((Address)((Address.Builder)Address.builder().applyMutation(operatingAddress)).build());
        }

        public Builder shippingAddress(Address var1);

        default public Builder shippingAddress(Consumer<Address.Builder> shippingAddress) {
            return this.shippingAddress((Address)((Address.Builder)Address.builder().applyMutation(shippingAddress)).build());
        }

        public Builder rackPhysicalProperties(RackPhysicalProperties var1);

        default public Builder rackPhysicalProperties(Consumer<RackPhysicalProperties.Builder> rackPhysicalProperties) {
            return this.rackPhysicalProperties((RackPhysicalProperties)((RackPhysicalProperties.Builder)RackPhysicalProperties.builder().applyMutation(rackPhysicalProperties)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

