/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.outposts.model.LineItemRequest;
import software.amazon.awssdk.services.outposts.model.LineItemRequestListDefinitionCopier;
import software.amazon.awssdk.services.outposts.model.OutpostsRequest;
import software.amazon.awssdk.services.outposts.model.PaymentOption;
import software.amazon.awssdk.services.outposts.model.PaymentTerm;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateOrderRequest
extends OutpostsRequest
implements ToCopyableBuilder<Builder, CreateOrderRequest> {
    private static final SdkField<String> OUTPOST_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostIdentifier").getter(CreateOrderRequest.getter(CreateOrderRequest::outpostIdentifier)).setter(CreateOrderRequest.setter(Builder::outpostIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostIdentifier").build()}).build();
    private static final SdkField<List<LineItemRequest>> LINE_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LineItems").getter(CreateOrderRequest.getter(CreateOrderRequest::lineItems)).setter(CreateOrderRequest.setter(Builder::lineItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LineItemRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PaymentOption").getter(CreateOrderRequest.getter(CreateOrderRequest::paymentOptionAsString)).setter(CreateOrderRequest.setter(Builder::paymentOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentOption").build()}).build();
    private static final SdkField<String> PAYMENT_TERM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PaymentTerm").getter(CreateOrderRequest.getter(CreateOrderRequest::paymentTermAsString)).setter(CreateOrderRequest.setter(Builder::paymentTerm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentTerm").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPOST_IDENTIFIER_FIELD, LINE_ITEMS_FIELD, PAYMENT_OPTION_FIELD, PAYMENT_TERM_FIELD));
    private final String outpostIdentifier;
    private final List<LineItemRequest> lineItems;
    private final String paymentOption;
    private final String paymentTerm;

    private CreateOrderRequest(BuilderImpl builder) {
        super(builder);
        this.outpostIdentifier = builder.outpostIdentifier;
        this.lineItems = builder.lineItems;
        this.paymentOption = builder.paymentOption;
        this.paymentTerm = builder.paymentTerm;
    }

    public final String outpostIdentifier() {
        return this.outpostIdentifier;
    }

    public final boolean hasLineItems() {
        return this.lineItems != null && !(this.lineItems instanceof SdkAutoConstructList);
    }

    public final List<LineItemRequest> lineItems() {
        return this.lineItems;
    }

    public final PaymentOption paymentOption() {
        return PaymentOption.fromValue(this.paymentOption);
    }

    public final String paymentOptionAsString() {
        return this.paymentOption;
    }

    public final PaymentTerm paymentTerm() {
        return PaymentTerm.fromValue(this.paymentTerm);
    }

    public final String paymentTermAsString() {
        return this.paymentTerm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLineItems() ? this.lineItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.paymentTermAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOrderRequest)) {
            return false;
        }
        CreateOrderRequest other = (CreateOrderRequest)((Object)obj);
        return Objects.equals(this.outpostIdentifier(), other.outpostIdentifier()) && this.hasLineItems() == other.hasLineItems() && Objects.equals(this.lineItems(), other.lineItems()) && Objects.equals(this.paymentOptionAsString(), other.paymentOptionAsString()) && Objects.equals(this.paymentTermAsString(), other.paymentTermAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateOrderRequest").add("OutpostIdentifier", (Object)this.outpostIdentifier()).add("LineItems", this.hasLineItems() ? this.lineItems() : null).add("PaymentOption", (Object)this.paymentOptionAsString()).add("PaymentTerm", (Object)this.paymentTermAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutpostIdentifier": {
                return Optional.ofNullable(clazz.cast(this.outpostIdentifier()));
            }
            case "LineItems": {
                return Optional.ofNullable(clazz.cast(this.lineItems()));
            }
            case "PaymentOption": {
                return Optional.ofNullable(clazz.cast(this.paymentOptionAsString()));
            }
            case "PaymentTerm": {
                return Optional.ofNullable(clazz.cast(this.paymentTermAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateOrderRequest, T> g) {
        return obj -> g.apply((CreateOrderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OutpostsRequest.BuilderImpl
    implements Builder {
        private String outpostIdentifier;
        private List<LineItemRequest> lineItems = DefaultSdkAutoConstructList.getInstance();
        private String paymentOption;
        private String paymentTerm;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOrderRequest model) {
            super(model);
            this.outpostIdentifier(model.outpostIdentifier);
            this.lineItems(model.lineItems);
            this.paymentOption(model.paymentOption);
            this.paymentTerm(model.paymentTerm);
        }

        public final String getOutpostIdentifier() {
            return this.outpostIdentifier;
        }

        public final void setOutpostIdentifier(String outpostIdentifier) {
            this.outpostIdentifier = outpostIdentifier;
        }

        @Override
        public final Builder outpostIdentifier(String outpostIdentifier) {
            this.outpostIdentifier = outpostIdentifier;
            return this;
        }

        public final List<LineItemRequest.Builder> getLineItems() {
            List<LineItemRequest.Builder> result = LineItemRequestListDefinitionCopier.copyToBuilder(this.lineItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLineItems(Collection<LineItemRequest.BuilderImpl> lineItems) {
            this.lineItems = LineItemRequestListDefinitionCopier.copyFromBuilder(lineItems);
        }

        @Override
        public final Builder lineItems(Collection<LineItemRequest> lineItems) {
            this.lineItems = LineItemRequestListDefinitionCopier.copy(lineItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineItems(LineItemRequest ... lineItems) {
            this.lineItems(Arrays.asList(lineItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineItems(Consumer<LineItemRequest.Builder> ... lineItems) {
            this.lineItems(Stream.of(lineItems).map(c -> (LineItemRequest)((LineItemRequest.Builder)LineItemRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPaymentOption() {
            return this.paymentOption;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(PaymentOption paymentOption) {
            this.paymentOption(paymentOption == null ? null : paymentOption.toString());
            return this;
        }

        public final String getPaymentTerm() {
            return this.paymentTerm;
        }

        public final void setPaymentTerm(String paymentTerm) {
            this.paymentTerm = paymentTerm;
        }

        @Override
        public final Builder paymentTerm(String paymentTerm) {
            this.paymentTerm = paymentTerm;
            return this;
        }

        @Override
        public final Builder paymentTerm(PaymentTerm paymentTerm) {
            this.paymentTerm(paymentTerm == null ? null : paymentTerm.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateOrderRequest build() {
            return new CreateOrderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OutpostsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateOrderRequest> {
        public Builder outpostIdentifier(String var1);

        public Builder lineItems(Collection<LineItemRequest> var1);

        public Builder lineItems(LineItemRequest ... var1);

        public Builder lineItems(Consumer<LineItemRequest.Builder> ... var1);

        public Builder paymentOption(String var1);

        public Builder paymentOption(PaymentOption var1);

        public Builder paymentTerm(String var1);

        public Builder paymentTerm(PaymentTerm var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

