/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.outposts.OutpostsAsyncClient;
import software.amazon.awssdk.services.outposts.internal.UserAgentUtils;
import software.amazon.awssdk.services.outposts.model.ListCatalogItemsRequest;
import software.amazon.awssdk.services.outposts.model.ListCatalogItemsResponse;

public class ListCatalogItemsPublisher
implements SdkPublisher<ListCatalogItemsResponse> {
    private final OutpostsAsyncClient client;
    private final ListCatalogItemsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCatalogItemsPublisher(OutpostsAsyncClient client, ListCatalogItemsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCatalogItemsPublisher(OutpostsAsyncClient client, ListCatalogItemsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCatalogItemsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCatalogItemsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListCatalogItemsResponseFetcher
    implements AsyncPageFetcher<ListCatalogItemsResponse> {
        private ListCatalogItemsResponseFetcher() {
        }

        public boolean hasNextPage(ListCatalogItemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCatalogItemsResponse> nextPage(ListCatalogItemsResponse previousPage) {
            if (previousPage == null) {
                return ListCatalogItemsPublisher.this.client.listCatalogItems(ListCatalogItemsPublisher.this.firstRequest);
            }
            return ListCatalogItemsPublisher.this.client.listCatalogItems((ListCatalogItemsRequest)((Object)ListCatalogItemsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

