/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.outposts.DefaultOutpostsAsyncClient;
import software.amazon.awssdk.services.outposts.DefaultOutpostsBaseClientBuilder;
import software.amazon.awssdk.services.outposts.OutpostsAsyncClient;
import software.amazon.awssdk.services.outposts.OutpostsAsyncClientBuilder;
import software.amazon.awssdk.services.outposts.OutpostsServiceClientConfiguration;
import software.amazon.awssdk.services.outposts.endpoints.OutpostsEndpointProvider;

@SdkInternalApi
final class DefaultOutpostsAsyncClientBuilder
extends DefaultOutpostsBaseClientBuilder<OutpostsAsyncClientBuilder, OutpostsAsyncClient>
implements OutpostsAsyncClientBuilder {
    DefaultOutpostsAsyncClientBuilder() {
    }

    @Override
    public DefaultOutpostsAsyncClientBuilder endpointProvider(OutpostsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final OutpostsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultOutpostsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        OutpostsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultOutpostsAsyncClient client = new DefaultOutpostsAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private OutpostsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return OutpostsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

