/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.outposts.model.ShipmentCarrier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ShipmentInformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ShipmentInformation> {
    private static final SdkField<String> SHIPMENT_TRACKING_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShipmentTrackingNumber").getter(ShipmentInformation.getter(ShipmentInformation::shipmentTrackingNumber)).setter(ShipmentInformation.setter(Builder::shipmentTrackingNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShipmentTrackingNumber").build()}).build();
    private static final SdkField<String> SHIPMENT_CARRIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShipmentCarrier").getter(ShipmentInformation.getter(ShipmentInformation::shipmentCarrierAsString)).setter(ShipmentInformation.setter(Builder::shipmentCarrier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShipmentCarrier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHIPMENT_TRACKING_NUMBER_FIELD, SHIPMENT_CARRIER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String shipmentTrackingNumber;
    private final String shipmentCarrier;

    private ShipmentInformation(BuilderImpl builder) {
        this.shipmentTrackingNumber = builder.shipmentTrackingNumber;
        this.shipmentCarrier = builder.shipmentCarrier;
    }

    public final String shipmentTrackingNumber() {
        return this.shipmentTrackingNumber;
    }

    public final ShipmentCarrier shipmentCarrier() {
        return ShipmentCarrier.fromValue(this.shipmentCarrier);
    }

    public final String shipmentCarrierAsString() {
        return this.shipmentCarrier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.shipmentTrackingNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.shipmentCarrierAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShipmentInformation)) {
            return false;
        }
        ShipmentInformation other = (ShipmentInformation)obj;
        return Objects.equals(this.shipmentTrackingNumber(), other.shipmentTrackingNumber()) && Objects.equals(this.shipmentCarrierAsString(), other.shipmentCarrierAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ShipmentInformation").add("ShipmentTrackingNumber", (Object)this.shipmentTrackingNumber()).add("ShipmentCarrier", (Object)this.shipmentCarrierAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ShipmentTrackingNumber": {
                return Optional.ofNullable(clazz.cast(this.shipmentTrackingNumber()));
            }
            case "ShipmentCarrier": {
                return Optional.ofNullable(clazz.cast(this.shipmentCarrierAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ShipmentInformation, T> g) {
        return obj -> g.apply((ShipmentInformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String shipmentTrackingNumber;
        private String shipmentCarrier;

        private BuilderImpl() {
        }

        private BuilderImpl(ShipmentInformation model) {
            this.shipmentTrackingNumber(model.shipmentTrackingNumber);
            this.shipmentCarrier(model.shipmentCarrier);
        }

        public final String getShipmentTrackingNumber() {
            return this.shipmentTrackingNumber;
        }

        public final void setShipmentTrackingNumber(String shipmentTrackingNumber) {
            this.shipmentTrackingNumber = shipmentTrackingNumber;
        }

        @Override
        public final Builder shipmentTrackingNumber(String shipmentTrackingNumber) {
            this.shipmentTrackingNumber = shipmentTrackingNumber;
            return this;
        }

        public final String getShipmentCarrier() {
            return this.shipmentCarrier;
        }

        public final void setShipmentCarrier(String shipmentCarrier) {
            this.shipmentCarrier = shipmentCarrier;
        }

        @Override
        public final Builder shipmentCarrier(String shipmentCarrier) {
            this.shipmentCarrier = shipmentCarrier;
            return this;
        }

        @Override
        public final Builder shipmentCarrier(ShipmentCarrier shipmentCarrier) {
            this.shipmentCarrier(shipmentCarrier == null ? null : shipmentCarrier.toString());
            return this;
        }

        public ShipmentInformation build() {
            return new ShipmentInformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ShipmentInformation> {
        public Builder shipmentTrackingNumber(String var1);

        public Builder shipmentCarrier(String var1);

        public Builder shipmentCarrier(ShipmentCarrier var1);
    }
}

