/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.outposts.model.LineItemAssetInformation;
import software.amazon.awssdk.services.outposts.model.LineItemAssetInformationListCopier;
import software.amazon.awssdk.services.outposts.model.LineItemStatus;
import software.amazon.awssdk.services.outposts.model.ShipmentInformation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LineItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LineItem> {
    private static final SdkField<String> CATALOG_ITEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogItemId").getter(LineItem.getter(LineItem::catalogItemId)).setter(LineItem.setter(Builder::catalogItemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogItemId").build()}).build();
    private static final SdkField<String> LINE_ITEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LineItemId").getter(LineItem.getter(LineItem::lineItemId)).setter(LineItem.setter(Builder::lineItemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineItemId").build()}).build();
    private static final SdkField<Integer> QUANTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Quantity").getter(LineItem.getter(LineItem::quantity)).setter(LineItem.setter(Builder::quantity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantity").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(LineItem.getter(LineItem::statusAsString)).setter(LineItem.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<ShipmentInformation> SHIPMENT_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ShipmentInformation").getter(LineItem.getter(LineItem::shipmentInformation)).setter(LineItem.setter(Builder::shipmentInformation)).constructor(ShipmentInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShipmentInformation").build()}).build();
    private static final SdkField<List<LineItemAssetInformation>> ASSET_INFORMATION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssetInformationList").getter(LineItem.getter(LineItem::assetInformationList)).setter(LineItem.setter(Builder::assetInformationList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetInformationList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LineItemAssetInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ITEM_ID_FIELD, LINE_ITEM_ID_FIELD, QUANTITY_FIELD, STATUS_FIELD, SHIPMENT_INFORMATION_FIELD, ASSET_INFORMATION_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String catalogItemId;
    private final String lineItemId;
    private final Integer quantity;
    private final String status;
    private final ShipmentInformation shipmentInformation;
    private final List<LineItemAssetInformation> assetInformationList;

    private LineItem(BuilderImpl builder) {
        this.catalogItemId = builder.catalogItemId;
        this.lineItemId = builder.lineItemId;
        this.quantity = builder.quantity;
        this.status = builder.status;
        this.shipmentInformation = builder.shipmentInformation;
        this.assetInformationList = builder.assetInformationList;
    }

    public final String catalogItemId() {
        return this.catalogItemId;
    }

    public final String lineItemId() {
        return this.lineItemId;
    }

    public final Integer quantity() {
        return this.quantity;
    }

    public final LineItemStatus status() {
        return LineItemStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ShipmentInformation shipmentInformation() {
        return this.shipmentInformation;
    }

    public final boolean hasAssetInformationList() {
        return this.assetInformationList != null && !(this.assetInformationList instanceof SdkAutoConstructList);
    }

    public final List<LineItemAssetInformation> assetInformationList() {
        return this.assetInformationList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogItemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lineItemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.quantity());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shipmentInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetInformationList() ? this.assetInformationList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineItem)) {
            return false;
        }
        LineItem other = (LineItem)obj;
        return Objects.equals(this.catalogItemId(), other.catalogItemId()) && Objects.equals(this.lineItemId(), other.lineItemId()) && Objects.equals(this.quantity(), other.quantity()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.shipmentInformation(), other.shipmentInformation()) && this.hasAssetInformationList() == other.hasAssetInformationList() && Objects.equals(this.assetInformationList(), other.assetInformationList());
    }

    public final String toString() {
        return ToString.builder((String)"LineItem").add("CatalogItemId", (Object)this.catalogItemId()).add("LineItemId", (Object)this.lineItemId()).add("Quantity", (Object)this.quantity()).add("Status", (Object)this.statusAsString()).add("ShipmentInformation", (Object)this.shipmentInformation()).add("AssetInformationList", this.hasAssetInformationList() ? this.assetInformationList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogItemId": {
                return Optional.ofNullable(clazz.cast(this.catalogItemId()));
            }
            case "LineItemId": {
                return Optional.ofNullable(clazz.cast(this.lineItemId()));
            }
            case "Quantity": {
                return Optional.ofNullable(clazz.cast(this.quantity()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ShipmentInformation": {
                return Optional.ofNullable(clazz.cast(this.shipmentInformation()));
            }
            case "AssetInformationList": {
                return Optional.ofNullable(clazz.cast(this.assetInformationList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LineItem, T> g) {
        return obj -> g.apply((LineItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String catalogItemId;
        private String lineItemId;
        private Integer quantity;
        private String status;
        private ShipmentInformation shipmentInformation;
        private List<LineItemAssetInformation> assetInformationList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LineItem model) {
            this.catalogItemId(model.catalogItemId);
            this.lineItemId(model.lineItemId);
            this.quantity(model.quantity);
            this.status(model.status);
            this.shipmentInformation(model.shipmentInformation);
            this.assetInformationList(model.assetInformationList);
        }

        public final String getCatalogItemId() {
            return this.catalogItemId;
        }

        public final void setCatalogItemId(String catalogItemId) {
            this.catalogItemId = catalogItemId;
        }

        @Override
        public final Builder catalogItemId(String catalogItemId) {
            this.catalogItemId = catalogItemId;
            return this;
        }

        public final String getLineItemId() {
            return this.lineItemId;
        }

        public final void setLineItemId(String lineItemId) {
            this.lineItemId = lineItemId;
        }

        @Override
        public final Builder lineItemId(String lineItemId) {
            this.lineItemId = lineItemId;
            return this;
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LineItemStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ShipmentInformation.Builder getShipmentInformation() {
            return this.shipmentInformation != null ? this.shipmentInformation.toBuilder() : null;
        }

        public final void setShipmentInformation(ShipmentInformation.BuilderImpl shipmentInformation) {
            this.shipmentInformation = shipmentInformation != null ? shipmentInformation.build() : null;
        }

        @Override
        public final Builder shipmentInformation(ShipmentInformation shipmentInformation) {
            this.shipmentInformation = shipmentInformation;
            return this;
        }

        public final List<LineItemAssetInformation.Builder> getAssetInformationList() {
            List<LineItemAssetInformation.Builder> result = LineItemAssetInformationListCopier.copyToBuilder(this.assetInformationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetInformationList(Collection<LineItemAssetInformation.BuilderImpl> assetInformationList) {
            this.assetInformationList = LineItemAssetInformationListCopier.copyFromBuilder(assetInformationList);
        }

        @Override
        public final Builder assetInformationList(Collection<LineItemAssetInformation> assetInformationList) {
            this.assetInformationList = LineItemAssetInformationListCopier.copy(assetInformationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetInformationList(LineItemAssetInformation ... assetInformationList) {
            this.assetInformationList(Arrays.asList(assetInformationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetInformationList(Consumer<LineItemAssetInformation.Builder> ... assetInformationList) {
            this.assetInformationList(Stream.of(assetInformationList).map(c -> (LineItemAssetInformation)((LineItemAssetInformation.Builder)LineItemAssetInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LineItem build() {
            return new LineItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LineItem> {
        public Builder catalogItemId(String var1);

        public Builder lineItemId(String var1);

        public Builder quantity(Integer var1);

        public Builder status(String var1);

        public Builder status(LineItemStatus var1);

        public Builder shipmentInformation(ShipmentInformation var1);

        default public Builder shipmentInformation(Consumer<ShipmentInformation.Builder> shipmentInformation) {
            return this.shipmentInformation((ShipmentInformation)((ShipmentInformation.Builder)ShipmentInformation.builder().applyMutation(shipmentInformation)).build());
        }

        public Builder assetInformationList(Collection<LineItemAssetInformation> var1);

        public Builder assetInformationList(LineItemAssetInformation ... var1);

        public Builder assetInformationList(Consumer<LineItemAssetInformation.Builder> ... var1);
    }
}

