/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PaymentTerm {
    THREE_YEARS("THREE_YEARS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PaymentTerm> VALUE_MAP;
    private final String value;

    private PaymentTerm(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PaymentTerm fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PaymentTerm> knownValues() {
        EnumSet<PaymentTerm> knownValues = EnumSet.allOf(PaymentTerm.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PaymentTerm.class, PaymentTerm::toString);
    }
}

