/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum OrderStatus {
    RECEIVED("RECEIVED"),
    PENDING("PENDING"),
    PROCESSING("PROCESSING"),
    INSTALLING("INSTALLING"),
    FULFILLED("FULFILLED"),
    CANCELLED("CANCELLED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private OrderStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OrderStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(OrderStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OrderStatus> knownValues() {
        return Stream.of(OrderStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

