/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.outposts.OutpostsClient;
import software.amazon.awssdk.services.outposts.model.ListOrdersRequest;
import software.amazon.awssdk.services.outposts.model.ListOrdersResponse;

public class ListOrdersIterable
implements SdkIterable<ListOrdersResponse> {
    private final OutpostsClient client;
    private final ListOrdersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOrdersIterable(OutpostsClient client, ListOrdersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListOrdersResponseFetcher();
    }

    public Iterator<ListOrdersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListOrdersResponseFetcher
    implements SyncPageFetcher<ListOrdersResponse> {
        private ListOrdersResponseFetcher() {
        }

        public boolean hasNextPage(ListOrdersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListOrdersResponse nextPage(ListOrdersResponse previousPage) {
            if (previousPage == null) {
                return ListOrdersIterable.this.client.listOrders(ListOrdersIterable.this.firstRequest);
            }
            return ListOrdersIterable.this.client.listOrders((ListOrdersRequest)((Object)ListOrdersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

