/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.outposts.DefaultOutpostsClientBuilder;
import software.amazon.awssdk.services.outposts.OutpostsClientBuilder;
import software.amazon.awssdk.services.outposts.model.AccessDeniedException;
import software.amazon.awssdk.services.outposts.model.ConflictException;
import software.amazon.awssdk.services.outposts.model.CreateOutpostRequest;
import software.amazon.awssdk.services.outposts.model.CreateOutpostResponse;
import software.amazon.awssdk.services.outposts.model.DeleteOutpostRequest;
import software.amazon.awssdk.services.outposts.model.DeleteOutpostResponse;
import software.amazon.awssdk.services.outposts.model.DeleteSiteRequest;
import software.amazon.awssdk.services.outposts.model.DeleteSiteResponse;
import software.amazon.awssdk.services.outposts.model.GetOutpostInstanceTypesRequest;
import software.amazon.awssdk.services.outposts.model.GetOutpostInstanceTypesResponse;
import software.amazon.awssdk.services.outposts.model.GetOutpostRequest;
import software.amazon.awssdk.services.outposts.model.GetOutpostResponse;
import software.amazon.awssdk.services.outposts.model.InternalServerException;
import software.amazon.awssdk.services.outposts.model.ListOutpostsRequest;
import software.amazon.awssdk.services.outposts.model.ListOutpostsResponse;
import software.amazon.awssdk.services.outposts.model.ListSitesRequest;
import software.amazon.awssdk.services.outposts.model.ListSitesResponse;
import software.amazon.awssdk.services.outposts.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.outposts.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.outposts.model.NotFoundException;
import software.amazon.awssdk.services.outposts.model.OutpostsException;
import software.amazon.awssdk.services.outposts.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.outposts.model.TagResourceRequest;
import software.amazon.awssdk.services.outposts.model.TagResourceResponse;
import software.amazon.awssdk.services.outposts.model.UntagResourceRequest;
import software.amazon.awssdk.services.outposts.model.UntagResourceResponse;
import software.amazon.awssdk.services.outposts.model.ValidationException;
import software.amazon.awssdk.services.outposts.paginators.ListOutpostsIterable;
import software.amazon.awssdk.services.outposts.paginators.ListSitesIterable;

@SdkPublicApi
@ThreadSafe
public interface OutpostsClient
extends SdkClient {
    public static final String SERVICE_NAME = "outposts";
    public static final String SERVICE_METADATA_ID = "outposts";

    public static OutpostsClient create() {
        return (OutpostsClient)OutpostsClient.builder().build();
    }

    public static OutpostsClientBuilder builder() {
        return new DefaultOutpostsClientBuilder();
    }

    default public CreateOutpostResponse createOutpost(CreateOutpostRequest createOutpostRequest) throws ValidationException, ConflictException, NotFoundException, AccessDeniedException, InternalServerException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    default public CreateOutpostResponse createOutpost(Consumer<CreateOutpostRequest.Builder> createOutpostRequest) throws ValidationException, ConflictException, NotFoundException, AccessDeniedException, InternalServerException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, OutpostsException {
        return this.createOutpost((CreateOutpostRequest)((Object)((CreateOutpostRequest.Builder)CreateOutpostRequest.builder().applyMutation(createOutpostRequest)).build()));
    }

    default public DeleteOutpostResponse deleteOutpost(DeleteOutpostRequest deleteOutpostRequest) throws ValidationException, ConflictException, NotFoundException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    default public DeleteOutpostResponse deleteOutpost(Consumer<DeleteOutpostRequest.Builder> deleteOutpostRequest) throws ValidationException, ConflictException, NotFoundException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        return this.deleteOutpost((DeleteOutpostRequest)((Object)((DeleteOutpostRequest.Builder)DeleteOutpostRequest.builder().applyMutation(deleteOutpostRequest)).build()));
    }

    default public DeleteSiteResponse deleteSite(DeleteSiteRequest deleteSiteRequest) throws ValidationException, ConflictException, NotFoundException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    default public DeleteSiteResponse deleteSite(Consumer<DeleteSiteRequest.Builder> deleteSiteRequest) throws ValidationException, ConflictException, NotFoundException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        return this.deleteSite((DeleteSiteRequest)((Object)((DeleteSiteRequest.Builder)DeleteSiteRequest.builder().applyMutation(deleteSiteRequest)).build()));
    }

    default public GetOutpostResponse getOutpost(GetOutpostRequest getOutpostRequest) throws ValidationException, NotFoundException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    default public GetOutpostResponse getOutpost(Consumer<GetOutpostRequest.Builder> getOutpostRequest) throws ValidationException, NotFoundException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        return this.getOutpost((GetOutpostRequest)((Object)((GetOutpostRequest.Builder)GetOutpostRequest.builder().applyMutation(getOutpostRequest)).build()));
    }

    default public GetOutpostInstanceTypesResponse getOutpostInstanceTypes(GetOutpostInstanceTypesRequest getOutpostInstanceTypesRequest) throws ValidationException, NotFoundException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    default public GetOutpostInstanceTypesResponse getOutpostInstanceTypes(Consumer<GetOutpostInstanceTypesRequest.Builder> getOutpostInstanceTypesRequest) throws ValidationException, NotFoundException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        return this.getOutpostInstanceTypes((GetOutpostInstanceTypesRequest)((Object)((GetOutpostInstanceTypesRequest.Builder)GetOutpostInstanceTypesRequest.builder().applyMutation(getOutpostInstanceTypesRequest)).build()));
    }

    default public ListOutpostsResponse listOutposts(ListOutpostsRequest listOutpostsRequest) throws ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    default public ListOutpostsResponse listOutposts(Consumer<ListOutpostsRequest.Builder> listOutpostsRequest) throws ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        return this.listOutposts((ListOutpostsRequest)((Object)((ListOutpostsRequest.Builder)ListOutpostsRequest.builder().applyMutation(listOutpostsRequest)).build()));
    }

    default public ListOutpostsIterable listOutpostsPaginator(ListOutpostsRequest listOutpostsRequest) throws ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    default public ListOutpostsIterable listOutpostsPaginator(Consumer<ListOutpostsRequest.Builder> listOutpostsRequest) throws ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        return this.listOutpostsPaginator((ListOutpostsRequest)((Object)((ListOutpostsRequest.Builder)ListOutpostsRequest.builder().applyMutation(listOutpostsRequest)).build()));
    }

    default public ListSitesResponse listSites(ListSitesRequest listSitesRequest) throws ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    default public ListSitesResponse listSites(Consumer<ListSitesRequest.Builder> listSitesRequest) throws ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        return this.listSites((ListSitesRequest)((Object)((ListSitesRequest.Builder)ListSitesRequest.builder().applyMutation(listSitesRequest)).build()));
    }

    default public ListSitesIterable listSitesPaginator(ListSitesRequest listSitesRequest) throws ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    default public ListSitesIterable listSitesPaginator(Consumer<ListSitesRequest.Builder> listSitesRequest) throws ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        return this.listSitesPaginator((ListSitesRequest)((Object)((ListSitesRequest.Builder)ListSitesRequest.builder().applyMutation(listSitesRequest)).build()));
    }

    default public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InternalServerException, ValidationException, NotFoundException, AwsServiceException, SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourceResponse listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalServerException, ValidationException, NotFoundException, AwsServiceException, SdkClientException, OutpostsException {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException, ValidationException, NotFoundException, AwsServiceException, SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    default public TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws InternalServerException, ValidationException, NotFoundException, AwsServiceException, SdkClientException, OutpostsException {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException, ValidationException, NotFoundException, AwsServiceException, SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    default public UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) throws InternalServerException, ValidationException, NotFoundException, AwsServiceException, SdkClientException, OutpostsException {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"outposts");
    }
}

