/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.osis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RevokePipelineEndpointConnectionsRequest extends OsisRequest implements
        ToCopyableBuilder<RevokePipelineEndpointConnectionsRequest.Builder, RevokePipelineEndpointConnectionsRequest> {
    private static final SdkField<String> PIPELINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineArn").getter(getter(RevokePipelineEndpointConnectionsRequest::pipelineArn))
            .setter(setter(Builder::pipelineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineArn").build()).build();

    private static final SdkField<List<String>> ENDPOINT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EndpointIds")
            .getter(getter(RevokePipelineEndpointConnectionsRequest::endpointIds))
            .setter(setter(Builder::endpointIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ARN_FIELD,
            ENDPOINT_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String pipelineArn;

    private final List<String> endpointIds;

    private RevokePipelineEndpointConnectionsRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineArn = builder.pipelineArn;
        this.endpointIds = builder.endpointIds;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the pipeline from which to revoke endpoint connections.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the pipeline from which to revoke endpoint connections.
     */
    public final String pipelineArn() {
        return pipelineArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the EndpointIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEndpointIds() {
        return endpointIds != null && !(endpointIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of endpoint IDs for which to revoke access to the pipeline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEndpointIds} method.
     * </p>
     * 
     * @return A list of endpoint IDs for which to revoke access to the pipeline.
     */
    public final List<String> endpointIds() {
        return endpointIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasEndpointIds() ? endpointIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokePipelineEndpointConnectionsRequest)) {
            return false;
        }
        RevokePipelineEndpointConnectionsRequest other = (RevokePipelineEndpointConnectionsRequest) obj;
        return Objects.equals(pipelineArn(), other.pipelineArn()) && hasEndpointIds() == other.hasEndpointIds()
                && Objects.equals(endpointIds(), other.endpointIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RevokePipelineEndpointConnectionsRequest").add("PipelineArn", pipelineArn())
                .add("EndpointIds", hasEndpointIds() ? endpointIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PipelineArn":
            return Optional.ofNullable(clazz.cast(pipelineArn()));
        case "EndpointIds":
            return Optional.ofNullable(clazz.cast(endpointIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PipelineArn", PIPELINE_ARN_FIELD);
        map.put("EndpointIds", ENDPOINT_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RevokePipelineEndpointConnectionsRequest, T> g) {
        return obj -> g.apply((RevokePipelineEndpointConnectionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OsisRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RevokePipelineEndpointConnectionsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the pipeline from which to revoke endpoint connections.
         * </p>
         * 
         * @param pipelineArn
         *        The Amazon Resource Name (ARN) of the pipeline from which to revoke endpoint connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineArn(String pipelineArn);

        /**
         * <p>
         * A list of endpoint IDs for which to revoke access to the pipeline.
         * </p>
         * 
         * @param endpointIds
         *        A list of endpoint IDs for which to revoke access to the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointIds(Collection<String> endpointIds);

        /**
         * <p>
         * A list of endpoint IDs for which to revoke access to the pipeline.
         * </p>
         * 
         * @param endpointIds
         *        A list of endpoint IDs for which to revoke access to the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointIds(String... endpointIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OsisRequest.BuilderImpl implements Builder {
        private String pipelineArn;

        private List<String> endpointIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RevokePipelineEndpointConnectionsRequest model) {
            super(model);
            pipelineArn(model.pipelineArn);
            endpointIds(model.endpointIds);
        }

        public final String getPipelineArn() {
            return pipelineArn;
        }

        public final void setPipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
        }

        @Override
        public final Builder pipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
            return this;
        }

        public final Collection<String> getEndpointIds() {
            if (endpointIds instanceof SdkAutoConstructList) {
                return null;
            }
            return endpointIds;
        }

        public final void setEndpointIds(Collection<String> endpointIds) {
            this.endpointIds = PipelineEndpointIdsListCopier.copy(endpointIds);
        }

        @Override
        public final Builder endpointIds(Collection<String> endpointIds) {
            this.endpointIds = PipelineEndpointIdsListCopier.copy(endpointIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointIds(String... endpointIds) {
            endpointIds(Arrays.asList(endpointIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RevokePipelineEndpointConnectionsRequest build() {
            return new RevokePipelineEndpointConnectionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
