/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.osis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPipelineEndpointsResponse extends OsisResponse implements
        ToCopyableBuilder<ListPipelineEndpointsResponse.Builder, ListPipelineEndpointsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPipelineEndpointsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<PipelineEndpoint>> PIPELINE_ENDPOINTS_FIELD = SdkField
            .<List<PipelineEndpoint>> builder(MarshallingType.LIST)
            .memberName("PipelineEndpoints")
            .getter(getter(ListPipelineEndpointsResponse::pipelineEndpoints))
            .setter(setter(Builder::pipelineEndpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineEndpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PipelineEndpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(PipelineEndpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            PIPELINE_ENDPOINTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<PipelineEndpoint> pipelineEndpoints;

    private ListPipelineEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.pipelineEndpoints = builder.pipelineEndpoints;
    }

    /**
     * <p>
     * When <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is
     * a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * </p>
     * 
     * @return When <code>NextToken</code> is returned, there are more results available. The value of
     *         <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned
     *         token to retrieve the next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PipelineEndpoints property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPipelineEndpoints() {
        return pipelineEndpoints != null && !(pipelineEndpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of pipeline endpoints.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPipelineEndpoints} method.
     * </p>
     * 
     * @return A list of pipeline endpoints.
     */
    public final List<PipelineEndpoint> pipelineEndpoints() {
        return pipelineEndpoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasPipelineEndpoints() ? pipelineEndpoints() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPipelineEndpointsResponse)) {
            return false;
        }
        ListPipelineEndpointsResponse other = (ListPipelineEndpointsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasPipelineEndpoints() == other.hasPipelineEndpoints()
                && Objects.equals(pipelineEndpoints(), other.pipelineEndpoints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPipelineEndpointsResponse").add("NextToken", nextToken())
                .add("PipelineEndpoints", hasPipelineEndpoints() ? pipelineEndpoints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "PipelineEndpoints":
            return Optional.ofNullable(clazz.cast(pipelineEndpoints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("PipelineEndpoints", PIPELINE_ENDPOINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPipelineEndpointsResponse, T> g) {
        return obj -> g.apply((ListPipelineEndpointsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OsisResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPipelineEndpointsResponse> {
        /**
         * <p>
         * When <code>NextToken</code> is returned, there are more results available. The value of
         * <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned
         * token to retrieve the next page.
         * </p>
         * 
         * @param nextToken
         *        When <code>NextToken</code> is returned, there are more results available. The value of
         *        <code>NextToken</code> is a unique pagination token for each page. Make the call again using the
         *        returned token to retrieve the next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of pipeline endpoints.
         * </p>
         * 
         * @param pipelineEndpoints
         *        A list of pipeline endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineEndpoints(Collection<PipelineEndpoint> pipelineEndpoints);

        /**
         * <p>
         * A list of pipeline endpoints.
         * </p>
         * 
         * @param pipelineEndpoints
         *        A list of pipeline endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineEndpoints(PipelineEndpoint... pipelineEndpoints);

        /**
         * <p>
         * A list of pipeline endpoints.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.osis.model.PipelineEndpoint.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.osis.model.PipelineEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.osis.model.PipelineEndpoint.Builder#build()} is called immediately and
         * its result is passed to {@link #pipelineEndpoints(List<PipelineEndpoint>)}.
         * 
         * @param pipelineEndpoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.osis.model.PipelineEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipelineEndpoints(java.util.Collection<PipelineEndpoint>)
         */
        Builder pipelineEndpoints(Consumer<PipelineEndpoint.Builder>... pipelineEndpoints);
    }

    static final class BuilderImpl extends OsisResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<PipelineEndpoint> pipelineEndpoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPipelineEndpointsResponse model) {
            super(model);
            nextToken(model.nextToken);
            pipelineEndpoints(model.pipelineEndpoints);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<PipelineEndpoint.Builder> getPipelineEndpoints() {
            List<PipelineEndpoint.Builder> result = PipelineEndpointsSummaryListCopier.copyToBuilder(this.pipelineEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPipelineEndpoints(Collection<PipelineEndpoint.BuilderImpl> pipelineEndpoints) {
            this.pipelineEndpoints = PipelineEndpointsSummaryListCopier.copyFromBuilder(pipelineEndpoints);
        }

        @Override
        public final Builder pipelineEndpoints(Collection<PipelineEndpoint> pipelineEndpoints) {
            this.pipelineEndpoints = PipelineEndpointsSummaryListCopier.copy(pipelineEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineEndpoints(PipelineEndpoint... pipelineEndpoints) {
            pipelineEndpoints(Arrays.asList(pipelineEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineEndpoints(Consumer<PipelineEndpoint.Builder>... pipelineEndpoints) {
            pipelineEndpoints(Stream.of(pipelineEndpoints).map(c -> PipelineEndpoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPipelineEndpointsResponse build() {
            return new ListPipelineEndpointsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
