/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.osis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePipelineEndpointRequest extends OsisRequest implements
        ToCopyableBuilder<CreatePipelineEndpointRequest.Builder, CreatePipelineEndpointRequest> {
    private static final SdkField<String> PIPELINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineArn").getter(getter(CreatePipelineEndpointRequest::pipelineArn))
            .setter(setter(Builder::pipelineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineArn").build()).build();

    private static final SdkField<PipelineEndpointVpcOptions> VPC_OPTIONS_FIELD = SdkField
            .<PipelineEndpointVpcOptions> builder(MarshallingType.SDK_POJO).memberName("VpcOptions")
            .getter(getter(CreatePipelineEndpointRequest::vpcOptions)).setter(setter(Builder::vpcOptions))
            .constructor(PipelineEndpointVpcOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ARN_FIELD,
            VPC_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String pipelineArn;

    private final PipelineEndpointVpcOptions vpcOptions;

    private CreatePipelineEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineArn = builder.pipelineArn;
        this.vpcOptions = builder.vpcOptions;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the pipeline to create the endpoint for.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the pipeline to create the endpoint for.
     */
    public final String pipelineArn() {
        return pipelineArn;
    }

    /**
     * <p>
     * Container for the VPC configuration for the pipeline endpoint, including subnet IDs and security group IDs.
     * </p>
     * 
     * @return Container for the VPC configuration for the pipeline endpoint, including subnet IDs and security group
     *         IDs.
     */
    public final PipelineEndpointVpcOptions vpcOptions() {
        return vpcOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(vpcOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePipelineEndpointRequest)) {
            return false;
        }
        CreatePipelineEndpointRequest other = (CreatePipelineEndpointRequest) obj;
        return Objects.equals(pipelineArn(), other.pipelineArn()) && Objects.equals(vpcOptions(), other.vpcOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePipelineEndpointRequest").add("PipelineArn", pipelineArn())
                .add("VpcOptions", vpcOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PipelineArn":
            return Optional.ofNullable(clazz.cast(pipelineArn()));
        case "VpcOptions":
            return Optional.ofNullable(clazz.cast(vpcOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PipelineArn", PIPELINE_ARN_FIELD);
        map.put("VpcOptions", VPC_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePipelineEndpointRequest, T> g) {
        return obj -> g.apply((CreatePipelineEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OsisRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePipelineEndpointRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the pipeline to create the endpoint for.
         * </p>
         * 
         * @param pipelineArn
         *        The Amazon Resource Name (ARN) of the pipeline to create the endpoint for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineArn(String pipelineArn);

        /**
         * <p>
         * Container for the VPC configuration for the pipeline endpoint, including subnet IDs and security group IDs.
         * </p>
         * 
         * @param vpcOptions
         *        Container for the VPC configuration for the pipeline endpoint, including subnet IDs and security group
         *        IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcOptions(PipelineEndpointVpcOptions vpcOptions);

        /**
         * <p>
         * Container for the VPC configuration for the pipeline endpoint, including subnet IDs and security group IDs.
         * </p>
         * This is a convenience method that creates an instance of the {@link PipelineEndpointVpcOptions.Builder}
         * avoiding the need to create one manually via {@link PipelineEndpointVpcOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipelineEndpointVpcOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #vpcOptions(PipelineEndpointVpcOptions)}.
         * 
         * @param vpcOptions
         *        a consumer that will call methods on {@link PipelineEndpointVpcOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcOptions(PipelineEndpointVpcOptions)
         */
        default Builder vpcOptions(Consumer<PipelineEndpointVpcOptions.Builder> vpcOptions) {
            return vpcOptions(PipelineEndpointVpcOptions.builder().applyMutation(vpcOptions).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OsisRequest.BuilderImpl implements Builder {
        private String pipelineArn;

        private PipelineEndpointVpcOptions vpcOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePipelineEndpointRequest model) {
            super(model);
            pipelineArn(model.pipelineArn);
            vpcOptions(model.vpcOptions);
        }

        public final String getPipelineArn() {
            return pipelineArn;
        }

        public final void setPipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
        }

        @Override
        public final Builder pipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
            return this;
        }

        public final PipelineEndpointVpcOptions.Builder getVpcOptions() {
            return vpcOptions != null ? vpcOptions.toBuilder() : null;
        }

        public final void setVpcOptions(PipelineEndpointVpcOptions.BuilderImpl vpcOptions) {
            this.vpcOptions = vpcOptions != null ? vpcOptions.build() : null;
        }

        @Override
        public final Builder vpcOptions(PipelineEndpointVpcOptions vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePipelineEndpointRequest build() {
            return new CreatePipelineEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
