/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.osis.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The progress details of a pipeline configuration change.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChangeProgressStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<ChangeProgressStatus.Builder, ChangeProgressStatus> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(ChangeProgressStatus::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ChangeProgressStatus::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Integer> TOTAL_NUMBER_OF_STAGES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalNumberOfStages").getter(getter(ChangeProgressStatus::totalNumberOfStages))
            .setter(setter(Builder::totalNumberOfStages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNumberOfStages").build())
            .build();

    private static final SdkField<List<ChangeProgressStage>> CHANGE_PROGRESS_STAGES_FIELD = SdkField
            .<List<ChangeProgressStage>> builder(MarshallingType.LIST)
            .memberName("ChangeProgressStages")
            .getter(getter(ChangeProgressStatus::changeProgressStages))
            .setter(setter(Builder::changeProgressStages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeProgressStages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChangeProgressStage> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChangeProgressStage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD,
            STATUS_FIELD, TOTAL_NUMBER_OF_STAGES_FIELD, CHANGE_PROGRESS_STAGES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant startTime;

    private final String status;

    private final Integer totalNumberOfStages;

    private final List<ChangeProgressStage> changeProgressStages;

    private ChangeProgressStatus(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.status = builder.status;
        this.totalNumberOfStages = builder.totalNumberOfStages;
        this.changeProgressStages = builder.changeProgressStages;
    }

    /**
     * <p>
     * The time at which the configuration change is made on the pipeline.
     * </p>
     * 
     * @return The time at which the configuration change is made on the pipeline.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The overall status of the pipeline configuration change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChangeProgressStatuses#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The overall status of the pipeline configuration change.
     * @see ChangeProgressStatuses
     */
    public final ChangeProgressStatuses status() {
        return ChangeProgressStatuses.fromValue(status);
    }

    /**
     * <p>
     * The overall status of the pipeline configuration change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChangeProgressStatuses#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The overall status of the pipeline configuration change.
     * @see ChangeProgressStatuses
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The total number of stages required for the pipeline configuration change.
     * </p>
     * 
     * @return The total number of stages required for the pipeline configuration change.
     */
    public final Integer totalNumberOfStages() {
        return totalNumberOfStages;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChangeProgressStages property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasChangeProgressStages() {
        return changeProgressStages != null && !(changeProgressStages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the stages that the pipeline is going through to perform the configuration change.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChangeProgressStages} method.
     * </p>
     * 
     * @return Information about the stages that the pipeline is going through to perform the configuration change.
     */
    public final List<ChangeProgressStage> changeProgressStages() {
        return changeProgressStages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(totalNumberOfStages());
        hashCode = 31 * hashCode + Objects.hashCode(hasChangeProgressStages() ? changeProgressStages() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeProgressStatus)) {
            return false;
        }
        ChangeProgressStatus other = (ChangeProgressStatus) obj;
        return Objects.equals(startTime(), other.startTime()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(totalNumberOfStages(), other.totalNumberOfStages())
                && hasChangeProgressStages() == other.hasChangeProgressStages()
                && Objects.equals(changeProgressStages(), other.changeProgressStages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChangeProgressStatus").add("StartTime", startTime()).add("Status", statusAsString())
                .add("TotalNumberOfStages", totalNumberOfStages())
                .add("ChangeProgressStages", hasChangeProgressStages() ? changeProgressStages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "TotalNumberOfStages":
            return Optional.ofNullable(clazz.cast(totalNumberOfStages()));
        case "ChangeProgressStages":
            return Optional.ofNullable(clazz.cast(changeProgressStages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StartTime", START_TIME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("TotalNumberOfStages", TOTAL_NUMBER_OF_STAGES_FIELD);
        map.put("ChangeProgressStages", CHANGE_PROGRESS_STAGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChangeProgressStatus, T> g) {
        return obj -> g.apply((ChangeProgressStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChangeProgressStatus> {
        /**
         * <p>
         * The time at which the configuration change is made on the pipeline.
         * </p>
         * 
         * @param startTime
         *        The time at which the configuration change is made on the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The overall status of the pipeline configuration change.
         * </p>
         * 
         * @param status
         *        The overall status of the pipeline configuration change.
         * @see ChangeProgressStatuses
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeProgressStatuses
         */
        Builder status(String status);

        /**
         * <p>
         * The overall status of the pipeline configuration change.
         * </p>
         * 
         * @param status
         *        The overall status of the pipeline configuration change.
         * @see ChangeProgressStatuses
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeProgressStatuses
         */
        Builder status(ChangeProgressStatuses status);

        /**
         * <p>
         * The total number of stages required for the pipeline configuration change.
         * </p>
         * 
         * @param totalNumberOfStages
         *        The total number of stages required for the pipeline configuration change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalNumberOfStages(Integer totalNumberOfStages);

        /**
         * <p>
         * Information about the stages that the pipeline is going through to perform the configuration change.
         * </p>
         * 
         * @param changeProgressStages
         *        Information about the stages that the pipeline is going through to perform the configuration change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeProgressStages(Collection<ChangeProgressStage> changeProgressStages);

        /**
         * <p>
         * Information about the stages that the pipeline is going through to perform the configuration change.
         * </p>
         * 
         * @param changeProgressStages
         *        Information about the stages that the pipeline is going through to perform the configuration change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeProgressStages(ChangeProgressStage... changeProgressStages);

        /**
         * <p>
         * Information about the stages that the pipeline is going through to perform the configuration change.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.osis.model.ChangeProgressStage.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.osis.model.ChangeProgressStage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.osis.model.ChangeProgressStage.Builder#build()} is called immediately
         * and its result is passed to {@link #changeProgressStages(List<ChangeProgressStage>)}.
         * 
         * @param changeProgressStages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.osis.model.ChangeProgressStage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #changeProgressStages(java.util.Collection<ChangeProgressStage>)
         */
        Builder changeProgressStages(Consumer<ChangeProgressStage.Builder>... changeProgressStages);
    }

    static final class BuilderImpl implements Builder {
        private Instant startTime;

        private String status;

        private Integer totalNumberOfStages;

        private List<ChangeProgressStage> changeProgressStages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeProgressStatus model) {
            startTime(model.startTime);
            status(model.status);
            totalNumberOfStages(model.totalNumberOfStages);
            changeProgressStages(model.changeProgressStages);
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChangeProgressStatuses status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getTotalNumberOfStages() {
            return totalNumberOfStages;
        }

        public final void setTotalNumberOfStages(Integer totalNumberOfStages) {
            this.totalNumberOfStages = totalNumberOfStages;
        }

        @Override
        public final Builder totalNumberOfStages(Integer totalNumberOfStages) {
            this.totalNumberOfStages = totalNumberOfStages;
            return this;
        }

        public final List<ChangeProgressStage.Builder> getChangeProgressStages() {
            List<ChangeProgressStage.Builder> result = ChangeProgressStageListCopier.copyToBuilder(this.changeProgressStages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChangeProgressStages(Collection<ChangeProgressStage.BuilderImpl> changeProgressStages) {
            this.changeProgressStages = ChangeProgressStageListCopier.copyFromBuilder(changeProgressStages);
        }

        @Override
        public final Builder changeProgressStages(Collection<ChangeProgressStage> changeProgressStages) {
            this.changeProgressStages = ChangeProgressStageListCopier.copy(changeProgressStages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeProgressStages(ChangeProgressStage... changeProgressStages) {
            changeProgressStages(Arrays.asList(changeProgressStages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeProgressStages(Consumer<ChangeProgressStage.Builder>... changeProgressStages) {
            changeProgressStages(Stream.of(changeProgressStages).map(c -> ChangeProgressStage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ChangeProgressStatus build() {
            return new ChangeProgressStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
