/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.osis;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.osis.model.AccessDeniedException;
import software.amazon.awssdk.services.osis.model.ConflictException;
import software.amazon.awssdk.services.osis.model.CreatePipelineEndpointRequest;
import software.amazon.awssdk.services.osis.model.CreatePipelineEndpointResponse;
import software.amazon.awssdk.services.osis.model.CreatePipelineRequest;
import software.amazon.awssdk.services.osis.model.CreatePipelineResponse;
import software.amazon.awssdk.services.osis.model.DeletePipelineEndpointRequest;
import software.amazon.awssdk.services.osis.model.DeletePipelineEndpointResponse;
import software.amazon.awssdk.services.osis.model.DeletePipelineRequest;
import software.amazon.awssdk.services.osis.model.DeletePipelineResponse;
import software.amazon.awssdk.services.osis.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.osis.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.osis.model.DisabledOperationException;
import software.amazon.awssdk.services.osis.model.GetPipelineBlueprintRequest;
import software.amazon.awssdk.services.osis.model.GetPipelineBlueprintResponse;
import software.amazon.awssdk.services.osis.model.GetPipelineChangeProgressRequest;
import software.amazon.awssdk.services.osis.model.GetPipelineChangeProgressResponse;
import software.amazon.awssdk.services.osis.model.GetPipelineRequest;
import software.amazon.awssdk.services.osis.model.GetPipelineResponse;
import software.amazon.awssdk.services.osis.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.osis.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.osis.model.InternalException;
import software.amazon.awssdk.services.osis.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.osis.model.LimitExceededException;
import software.amazon.awssdk.services.osis.model.ListPipelineBlueprintsRequest;
import software.amazon.awssdk.services.osis.model.ListPipelineBlueprintsResponse;
import software.amazon.awssdk.services.osis.model.ListPipelineEndpointConnectionsRequest;
import software.amazon.awssdk.services.osis.model.ListPipelineEndpointConnectionsResponse;
import software.amazon.awssdk.services.osis.model.ListPipelineEndpointsRequest;
import software.amazon.awssdk.services.osis.model.ListPipelineEndpointsResponse;
import software.amazon.awssdk.services.osis.model.ListPipelinesRequest;
import software.amazon.awssdk.services.osis.model.ListPipelinesResponse;
import software.amazon.awssdk.services.osis.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.osis.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.osis.model.OsisException;
import software.amazon.awssdk.services.osis.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.osis.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.osis.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.osis.model.ResourceNotFoundException;
import software.amazon.awssdk.services.osis.model.RevokePipelineEndpointConnectionsRequest;
import software.amazon.awssdk.services.osis.model.RevokePipelineEndpointConnectionsResponse;
import software.amazon.awssdk.services.osis.model.StartPipelineRequest;
import software.amazon.awssdk.services.osis.model.StartPipelineResponse;
import software.amazon.awssdk.services.osis.model.StopPipelineRequest;
import software.amazon.awssdk.services.osis.model.StopPipelineResponse;
import software.amazon.awssdk.services.osis.model.TagResourceRequest;
import software.amazon.awssdk.services.osis.model.TagResourceResponse;
import software.amazon.awssdk.services.osis.model.UntagResourceRequest;
import software.amazon.awssdk.services.osis.model.UntagResourceResponse;
import software.amazon.awssdk.services.osis.model.UpdatePipelineRequest;
import software.amazon.awssdk.services.osis.model.UpdatePipelineResponse;
import software.amazon.awssdk.services.osis.model.ValidatePipelineRequest;
import software.amazon.awssdk.services.osis.model.ValidatePipelineResponse;
import software.amazon.awssdk.services.osis.model.ValidationException;
import software.amazon.awssdk.services.osis.paginators.ListPipelineEndpointConnectionsIterable;
import software.amazon.awssdk.services.osis.paginators.ListPipelineEndpointsIterable;
import software.amazon.awssdk.services.osis.paginators.ListPipelinesIterable;

/**
 * Service client for accessing Amazon OpenSearch Ingestion. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Use the Amazon OpenSearch Ingestion API to create and manage ingestion pipelines. OpenSearch Ingestion is a fully
 * managed data collector that delivers real-time log and trace data to OpenSearch Service domains. For more
 * information, see <a
 * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ingestion.html">Getting data into your
 * cluster using OpenSearch Ingestion</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface OsisClient extends AwsClient {
    String SERVICE_NAME = "osis";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "osis";

    /**
     * <p>
     * Creates an OpenSearch Ingestion pipeline. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/creating-pipeline.html">Creating
     * Amazon OpenSearch Ingestion pipelines</a>.
     * </p>
     *
     * @param createPipelineRequest
     * @return Result of the CreatePipeline operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws LimitExceededException
     *         You attempted to create more than the allowed number of tags.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws ResourceAlreadyExistsException
     *         You attempted to create a resource that already exists.
     * @throws ResourceNotFoundException
     *         You attempted to access or delete a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.CreatePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/CreatePipeline" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePipelineResponse createPipeline(CreatePipelineRequest createPipelineRequest) throws DisabledOperationException,
            LimitExceededException, ValidationException, InternalException, AccessDeniedException,
            ResourceAlreadyExistsException, ResourceNotFoundException, AwsServiceException, SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an OpenSearch Ingestion pipeline. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/creating-pipeline.html">Creating
     * Amazon OpenSearch Ingestion pipelines</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePipelineRequest.Builder} avoiding the need to
     * create one manually via {@link CreatePipelineRequest#builder()}
     * </p>
     *
     * @param createPipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.osis.model.CreatePipelineRequest.Builder} to create a request.
     * @return Result of the CreatePipeline operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws LimitExceededException
     *         You attempted to create more than the allowed number of tags.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws ResourceAlreadyExistsException
     *         You attempted to create a resource that already exists.
     * @throws ResourceNotFoundException
     *         You attempted to access or delete a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.CreatePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/CreatePipeline" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePipelineResponse createPipeline(Consumer<CreatePipelineRequest.Builder> createPipelineRequest)
            throws DisabledOperationException, LimitExceededException, ValidationException, InternalException,
            AccessDeniedException, ResourceAlreadyExistsException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OsisException {
        return createPipeline(CreatePipelineRequest.builder().applyMutation(createPipelineRequest).build());
    }

    /**
     * <p>
     * Creates a VPC endpoint for an OpenSearch Ingestion pipeline. Pipeline endpoints allow you to ingest data from
     * your VPC into pipelines that you have access to.
     * </p>
     *
     * @param createPipelineEndpointRequest
     * @return Result of the CreatePipelineEndpoint operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws LimitExceededException
     *         You attempted to create more than the allowed number of tags.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws ResourceNotFoundException
     *         You attempted to access or delete a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.CreatePipelineEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/CreatePipelineEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CreatePipelineEndpointResponse createPipelineEndpoint(CreatePipelineEndpointRequest createPipelineEndpointRequest)
            throws DisabledOperationException, LimitExceededException, ValidationException, InternalException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a VPC endpoint for an OpenSearch Ingestion pipeline. Pipeline endpoints allow you to ingest data from
     * your VPC into pipelines that you have access to.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePipelineEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePipelineEndpointRequest#builder()}
     * </p>
     *
     * @param createPipelineEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.osis.model.CreatePipelineEndpointRequest.Builder} to create a
     *        request.
     * @return Result of the CreatePipelineEndpoint operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws LimitExceededException
     *         You attempted to create more than the allowed number of tags.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws ResourceNotFoundException
     *         You attempted to access or delete a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.CreatePipelineEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/CreatePipelineEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CreatePipelineEndpointResponse createPipelineEndpoint(
            Consumer<CreatePipelineEndpointRequest.Builder> createPipelineEndpointRequest) throws DisabledOperationException,
            LimitExceededException, ValidationException, InternalException, AccessDeniedException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, OsisException {
        return createPipelineEndpoint(CreatePipelineEndpointRequest.builder().applyMutation(createPipelineEndpointRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an OpenSearch Ingestion pipeline. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/delete-pipeline.html">Deleting Amazon
     * OpenSearch Ingestion pipelines</a>.
     * </p>
     *
     * @param deletePipelineRequest
     * @return Result of the DeletePipeline operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws ResourceNotFoundException
     *         You attempted to access or delete a resource that does not exist.
     * @throws ConflictException
     *         The client attempted to remove a resource that is currently in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.DeletePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/DeletePipeline" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePipelineResponse deletePipeline(DeletePipelineRequest deletePipelineRequest) throws DisabledOperationException,
            ValidationException, InternalException, AccessDeniedException, ResourceNotFoundException, ConflictException,
            AwsServiceException, SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an OpenSearch Ingestion pipeline. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/delete-pipeline.html">Deleting Amazon
     * OpenSearch Ingestion pipelines</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePipelineRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePipelineRequest#builder()}
     * </p>
     *
     * @param deletePipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.osis.model.DeletePipelineRequest.Builder} to create a request.
     * @return Result of the DeletePipeline operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws ResourceNotFoundException
     *         You attempted to access or delete a resource that does not exist.
     * @throws ConflictException
     *         The client attempted to remove a resource that is currently in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.DeletePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/DeletePipeline" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePipelineResponse deletePipeline(Consumer<DeletePipelineRequest.Builder> deletePipelineRequest)
            throws DisabledOperationException, ValidationException, InternalException, AccessDeniedException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, OsisException {
        return deletePipeline(DeletePipelineRequest.builder().applyMutation(deletePipelineRequest).build());
    }

    /**
     * <p>
     * Deletes a VPC endpoint for an OpenSearch Ingestion pipeline.
     * </p>
     *
     * @param deletePipelineEndpointRequest
     * @return Result of the DeletePipelineEndpoint operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.DeletePipelineEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/DeletePipelineEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default DeletePipelineEndpointResponse deletePipelineEndpoint(DeletePipelineEndpointRequest deletePipelineEndpointRequest)
            throws DisabledOperationException, ValidationException, InternalException, AccessDeniedException,
            AwsServiceException, SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a VPC endpoint for an OpenSearch Ingestion pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePipelineEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link DeletePipelineEndpointRequest#builder()}
     * </p>
     *
     * @param deletePipelineEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.osis.model.DeletePipelineEndpointRequest.Builder} to create a
     *        request.
     * @return Result of the DeletePipelineEndpoint operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.DeletePipelineEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/DeletePipelineEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default DeletePipelineEndpointResponse deletePipelineEndpoint(
            Consumer<DeletePipelineEndpointRequest.Builder> deletePipelineEndpointRequest) throws DisabledOperationException,
            ValidationException, InternalException, AccessDeniedException, AwsServiceException, SdkClientException, OsisException {
        return deletePipelineEndpoint(DeletePipelineEndpointRequest.builder().applyMutation(deletePipelineEndpointRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a resource-based policy from an OpenSearch Ingestion resource.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws LimitExceededException
     *         You attempted to create more than the allowed number of tags.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws ResourceNotFoundException
     *         You attempted to access or delete a resource that does not exist.
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/DeleteResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest)
            throws DisabledOperationException, LimitExceededException, ValidationException, InternalException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a resource-based policy from an OpenSearch Ingestion resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourcePolicyRequest#builder()}
     * </p>
     *
     * @param deleteResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.osis.model.DeleteResourcePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws LimitExceededException
     *         You attempted to create more than the allowed number of tags.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws ResourceNotFoundException
     *         You attempted to access or delete a resource that does not exist.
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/DeleteResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteResourcePolicyResponse deleteResourcePolicy(
            Consumer<DeleteResourcePolicyRequest.Builder> deleteResourcePolicyRequest) throws DisabledOperationException,
            LimitExceededException, ValidationException, InternalException, ResourceNotFoundException, AccessDeniedException,
            AwsServiceException, SdkClientException, OsisException {
        return deleteResourcePolicy(DeleteResourcePolicyRequest.builder().applyMutation(deleteResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an OpenSearch Ingestion pipeline.
     * </p>
     *
     * @param getPipelineRequest
     * @return Result of the GetPipeline operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws ResourceNotFoundException
     *         You attempted to access or delete a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.GetPipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/GetPipeline" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPipelineResponse getPipeline(GetPipelineRequest getPipelineRequest) throws DisabledOperationException,
            ValidationException, InternalException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an OpenSearch Ingestion pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPipelineRequest.Builder} avoiding the need to
     * create one manually via {@link GetPipelineRequest#builder()}
     * </p>
     *
     * @param getPipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.osis.model.GetPipelineRequest.Builder} to create a request.
     * @return Result of the GetPipeline operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws ResourceNotFoundException
     *         You attempted to access or delete a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.GetPipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/GetPipeline" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPipelineResponse getPipeline(Consumer<GetPipelineRequest.Builder> getPipelineRequest)
            throws DisabledOperationException, ValidationException, InternalException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OsisException {
        return getPipeline(GetPipelineRequest.builder().applyMutation(getPipelineRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a specific blueprint for OpenSearch Ingestion. Blueprints are templates for the
     * configuration needed for a <code>CreatePipeline</code> request. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/creating-pipeline.html#pipeline-blueprint"
     * >Using blueprints to create a pipeline</a>.
     * </p>
     *
     * @param getPipelineBlueprintRequest
     * @return Result of the GetPipelineBlueprint operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws ResourceNotFoundException
     *         You attempted to access or delete a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.GetPipelineBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/GetPipelineBlueprint" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPipelineBlueprintResponse getPipelineBlueprint(GetPipelineBlueprintRequest getPipelineBlueprintRequest)
            throws DisabledOperationException, AccessDeniedException, InternalException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a specific blueprint for OpenSearch Ingestion. Blueprints are templates for the
     * configuration needed for a <code>CreatePipeline</code> request. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/creating-pipeline.html#pipeline-blueprint"
     * >Using blueprints to create a pipeline</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPipelineBlueprintRequest.Builder} avoiding the
     * need to create one manually via {@link GetPipelineBlueprintRequest#builder()}
     * </p>
     *
     * @param getPipelineBlueprintRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.osis.model.GetPipelineBlueprintRequest.Builder} to create a
     *        request.
     * @return Result of the GetPipelineBlueprint operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws ResourceNotFoundException
     *         You attempted to access or delete a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.GetPipelineBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/GetPipelineBlueprint" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPipelineBlueprintResponse getPipelineBlueprint(
            Consumer<GetPipelineBlueprintRequest.Builder> getPipelineBlueprintRequest) throws DisabledOperationException,
            AccessDeniedException, InternalException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OsisException {
        return getPipelineBlueprint(GetPipelineBlueprintRequest.builder().applyMutation(getPipelineBlueprintRequest).build());
    }

    /**
     * <p>
     * Returns progress information for the current change happening on an OpenSearch Ingestion pipeline. Currently,
     * this operation only returns information when a pipeline is being created.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/creating-pipeline.html#get-pipeline-progress"
     * >Tracking the status of pipeline creation</a>.
     * </p>
     *
     * @param getPipelineChangeProgressRequest
     * @return Result of the GetPipelineChangeProgress operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws ResourceNotFoundException
     *         You attempted to access or delete a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.GetPipelineChangeProgress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/GetPipelineChangeProgress"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPipelineChangeProgressResponse getPipelineChangeProgress(
            GetPipelineChangeProgressRequest getPipelineChangeProgressRequest) throws DisabledOperationException,
            ValidationException, InternalException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns progress information for the current change happening on an OpenSearch Ingestion pipeline. Currently,
     * this operation only returns information when a pipeline is being created.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/creating-pipeline.html#get-pipeline-progress"
     * >Tracking the status of pipeline creation</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPipelineChangeProgressRequest.Builder} avoiding
     * the need to create one manually via {@link GetPipelineChangeProgressRequest#builder()}
     * </p>
     *
     * @param getPipelineChangeProgressRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.osis.model.GetPipelineChangeProgressRequest.Builder} to create a
     *        request.
     * @return Result of the GetPipelineChangeProgress operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws ResourceNotFoundException
     *         You attempted to access or delete a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.GetPipelineChangeProgress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/GetPipelineChangeProgress"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPipelineChangeProgressResponse getPipelineChangeProgress(
            Consumer<GetPipelineChangeProgressRequest.Builder> getPipelineChangeProgressRequest)
            throws DisabledOperationException, ValidationException, InternalException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OsisException {
        return getPipelineChangeProgress(GetPipelineChangeProgressRequest.builder()
                .applyMutation(getPipelineChangeProgressRequest).build());
    }

    /**
     * <p>
     * Retrieves the resource-based policy attached to an OpenSearch Ingestion resource.
     * </p>
     *
     * @param getResourcePolicyRequest
     * @return Result of the GetResourcePolicy operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws LimitExceededException
     *         You attempted to create more than the allowed number of tags.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws ResourceNotFoundException
     *         You attempted to access or delete a resource that does not exist.
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/GetResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResourcePolicyResponse getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest)
            throws DisabledOperationException, LimitExceededException, ValidationException, InternalException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the resource-based policy attached to an OpenSearch Ingestion resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetResourcePolicyRequest#builder()}
     * </p>
     *
     * @param getResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.osis.model.GetResourcePolicyRequest.Builder} to create a request.
     * @return Result of the GetResourcePolicy operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws LimitExceededException
     *         You attempted to create more than the allowed number of tags.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws ResourceNotFoundException
     *         You attempted to access or delete a resource that does not exist.
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/GetResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResourcePolicyResponse getResourcePolicy(Consumer<GetResourcePolicyRequest.Builder> getResourcePolicyRequest)
            throws DisabledOperationException, LimitExceededException, ValidationException, InternalException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OsisException {
        return getResourcePolicy(GetResourcePolicyRequest.builder().applyMutation(getResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all available blueprints for Data Prepper. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/creating-pipeline.html#pipeline-blueprint"
     * >Using blueprints to create a pipeline</a>.
     * </p>
     *
     * @param listPipelineBlueprintsRequest
     * @return Result of the ListPipelineBlueprints operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws InvalidPaginationTokenException
     *         An invalid pagination token provided in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.ListPipelineBlueprints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/ListPipelineBlueprints" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPipelineBlueprintsResponse listPipelineBlueprints(ListPipelineBlueprintsRequest listPipelineBlueprintsRequest)
            throws DisabledOperationException, ValidationException, InternalException, AccessDeniedException,
            InvalidPaginationTokenException, AwsServiceException, SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all available blueprints for Data Prepper. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/creating-pipeline.html#pipeline-blueprint"
     * >Using blueprints to create a pipeline</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPipelineBlueprintsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPipelineBlueprintsRequest#builder()}
     * </p>
     *
     * @param listPipelineBlueprintsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.osis.model.ListPipelineBlueprintsRequest.Builder} to create a
     *        request.
     * @return Result of the ListPipelineBlueprints operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws InvalidPaginationTokenException
     *         An invalid pagination token provided in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.ListPipelineBlueprints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/ListPipelineBlueprints" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPipelineBlueprintsResponse listPipelineBlueprints(
            Consumer<ListPipelineBlueprintsRequest.Builder> listPipelineBlueprintsRequest) throws DisabledOperationException,
            ValidationException, InternalException, AccessDeniedException, InvalidPaginationTokenException, AwsServiceException,
            SdkClientException, OsisException {
        return listPipelineBlueprints(ListPipelineBlueprintsRequest.builder().applyMutation(listPipelineBlueprintsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the pipeline endpoints connected to pipelines in your account.
     * </p>
     *
     * @param listPipelineEndpointConnectionsRequest
     * @return Result of the ListPipelineEndpointConnections operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws LimitExceededException
     *         You attempted to create more than the allowed number of tags.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.ListPipelineEndpointConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/ListPipelineEndpointConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPipelineEndpointConnectionsResponse listPipelineEndpointConnections(
            ListPipelineEndpointConnectionsRequest listPipelineEndpointConnectionsRequest) throws DisabledOperationException,
            LimitExceededException, ValidationException, InternalException, AccessDeniedException, AwsServiceException,
            SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the pipeline endpoints connected to pipelines in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPipelineEndpointConnectionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListPipelineEndpointConnectionsRequest#builder()}
     * </p>
     *
     * @param listPipelineEndpointConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.osis.model.ListPipelineEndpointConnectionsRequest.Builder} to
     *        create a request.
     * @return Result of the ListPipelineEndpointConnections operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws LimitExceededException
     *         You attempted to create more than the allowed number of tags.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.ListPipelineEndpointConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/ListPipelineEndpointConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPipelineEndpointConnectionsResponse listPipelineEndpointConnections(
            Consumer<ListPipelineEndpointConnectionsRequest.Builder> listPipelineEndpointConnectionsRequest)
            throws DisabledOperationException, LimitExceededException, ValidationException, InternalException,
            AccessDeniedException, AwsServiceException, SdkClientException, OsisException {
        return listPipelineEndpointConnections(ListPipelineEndpointConnectionsRequest.builder()
                .applyMutation(listPipelineEndpointConnectionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPipelineEndpointConnections(software.amazon.awssdk.services.osis.model.ListPipelineEndpointConnectionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.osis.paginators.ListPipelineEndpointConnectionsIterable responses = client.listPipelineEndpointConnectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.osis.paginators.ListPipelineEndpointConnectionsIterable responses = client
     *             .listPipelineEndpointConnectionsPaginator(request);
     *     for (software.amazon.awssdk.services.osis.model.ListPipelineEndpointConnectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.osis.paginators.ListPipelineEndpointConnectionsIterable responses = client.listPipelineEndpointConnectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPipelineEndpointConnections(software.amazon.awssdk.services.osis.model.ListPipelineEndpointConnectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPipelineEndpointConnectionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws LimitExceededException
     *         You attempted to create more than the allowed number of tags.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.ListPipelineEndpointConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/ListPipelineEndpointConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPipelineEndpointConnectionsIterable listPipelineEndpointConnectionsPaginator(
            ListPipelineEndpointConnectionsRequest listPipelineEndpointConnectionsRequest) throws DisabledOperationException,
            LimitExceededException, ValidationException, InternalException, AccessDeniedException, AwsServiceException,
            SdkClientException, OsisException {
        return new ListPipelineEndpointConnectionsIterable(this, listPipelineEndpointConnectionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPipelineEndpointConnections(software.amazon.awssdk.services.osis.model.ListPipelineEndpointConnectionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.osis.paginators.ListPipelineEndpointConnectionsIterable responses = client.listPipelineEndpointConnectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.osis.paginators.ListPipelineEndpointConnectionsIterable responses = client
     *             .listPipelineEndpointConnectionsPaginator(request);
     *     for (software.amazon.awssdk.services.osis.model.ListPipelineEndpointConnectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.osis.paginators.ListPipelineEndpointConnectionsIterable responses = client.listPipelineEndpointConnectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPipelineEndpointConnections(software.amazon.awssdk.services.osis.model.ListPipelineEndpointConnectionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPipelineEndpointConnectionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListPipelineEndpointConnectionsRequest#builder()}
     * </p>
     *
     * @param listPipelineEndpointConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.osis.model.ListPipelineEndpointConnectionsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws LimitExceededException
     *         You attempted to create more than the allowed number of tags.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.ListPipelineEndpointConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/ListPipelineEndpointConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPipelineEndpointConnectionsIterable listPipelineEndpointConnectionsPaginator(
            Consumer<ListPipelineEndpointConnectionsRequest.Builder> listPipelineEndpointConnectionsRequest)
            throws DisabledOperationException, LimitExceededException, ValidationException, InternalException,
            AccessDeniedException, AwsServiceException, SdkClientException, OsisException {
        return listPipelineEndpointConnectionsPaginator(ListPipelineEndpointConnectionsRequest.builder()
                .applyMutation(listPipelineEndpointConnectionsRequest).build());
    }

    /**
     * <p>
     * Lists all pipeline endpoints in your account.
     * </p>
     *
     * @param listPipelineEndpointsRequest
     * @return Result of the ListPipelineEndpoints operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws LimitExceededException
     *         You attempted to create more than the allowed number of tags.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.ListPipelineEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/ListPipelineEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPipelineEndpointsResponse listPipelineEndpoints(ListPipelineEndpointsRequest listPipelineEndpointsRequest)
            throws DisabledOperationException, LimitExceededException, ValidationException, InternalException,
            AccessDeniedException, AwsServiceException, SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all pipeline endpoints in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPipelineEndpointsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPipelineEndpointsRequest#builder()}
     * </p>
     *
     * @param listPipelineEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.osis.model.ListPipelineEndpointsRequest.Builder} to create a
     *        request.
     * @return Result of the ListPipelineEndpoints operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws LimitExceededException
     *         You attempted to create more than the allowed number of tags.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.ListPipelineEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/ListPipelineEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPipelineEndpointsResponse listPipelineEndpoints(
            Consumer<ListPipelineEndpointsRequest.Builder> listPipelineEndpointsRequest) throws DisabledOperationException,
            LimitExceededException, ValidationException, InternalException, AccessDeniedException, AwsServiceException,
            SdkClientException, OsisException {
        return listPipelineEndpoints(ListPipelineEndpointsRequest.builder().applyMutation(listPipelineEndpointsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPipelineEndpoints(software.amazon.awssdk.services.osis.model.ListPipelineEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.osis.paginators.ListPipelineEndpointsIterable responses = client.listPipelineEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.osis.paginators.ListPipelineEndpointsIterable responses = client
     *             .listPipelineEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.osis.model.ListPipelineEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.osis.paginators.ListPipelineEndpointsIterable responses = client.listPipelineEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPipelineEndpoints(software.amazon.awssdk.services.osis.model.ListPipelineEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPipelineEndpointsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws LimitExceededException
     *         You attempted to create more than the allowed number of tags.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.ListPipelineEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/ListPipelineEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPipelineEndpointsIterable listPipelineEndpointsPaginator(ListPipelineEndpointsRequest listPipelineEndpointsRequest)
            throws DisabledOperationException, LimitExceededException, ValidationException, InternalException,
            AccessDeniedException, AwsServiceException, SdkClientException, OsisException {
        return new ListPipelineEndpointsIterable(this, listPipelineEndpointsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPipelineEndpoints(software.amazon.awssdk.services.osis.model.ListPipelineEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.osis.paginators.ListPipelineEndpointsIterable responses = client.listPipelineEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.osis.paginators.ListPipelineEndpointsIterable responses = client
     *             .listPipelineEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.osis.model.ListPipelineEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.osis.paginators.ListPipelineEndpointsIterable responses = client.listPipelineEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPipelineEndpoints(software.amazon.awssdk.services.osis.model.ListPipelineEndpointsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPipelineEndpointsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPipelineEndpointsRequest#builder()}
     * </p>
     *
     * @param listPipelineEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.osis.model.ListPipelineEndpointsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws LimitExceededException
     *         You attempted to create more than the allowed number of tags.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.ListPipelineEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/ListPipelineEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPipelineEndpointsIterable listPipelineEndpointsPaginator(
            Consumer<ListPipelineEndpointsRequest.Builder> listPipelineEndpointsRequest) throws DisabledOperationException,
            LimitExceededException, ValidationException, InternalException, AccessDeniedException, AwsServiceException,
            SdkClientException, OsisException {
        return listPipelineEndpointsPaginator(ListPipelineEndpointsRequest.builder().applyMutation(listPipelineEndpointsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all OpenSearch Ingestion pipelines in the current Amazon Web Services account and Region. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/list-pipeline.html">Viewing Amazon
     * OpenSearch Ingestion pipelines</a>.
     * </p>
     *
     * @param listPipelinesRequest
     * @return Result of the ListPipelines operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws InvalidPaginationTokenException
     *         An invalid pagination token provided in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.ListPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/ListPipelines" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPipelinesResponse listPipelines(ListPipelinesRequest listPipelinesRequest) throws DisabledOperationException,
            ValidationException, InternalException, AccessDeniedException, InvalidPaginationTokenException, AwsServiceException,
            SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all OpenSearch Ingestion pipelines in the current Amazon Web Services account and Region. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/list-pipeline.html">Viewing Amazon
     * OpenSearch Ingestion pipelines</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPipelinesRequest.Builder} avoiding the need to
     * create one manually via {@link ListPipelinesRequest#builder()}
     * </p>
     *
     * @param listPipelinesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.osis.model.ListPipelinesRequest.Builder} to create a request.
     * @return Result of the ListPipelines operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws InvalidPaginationTokenException
     *         An invalid pagination token provided in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.ListPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/ListPipelines" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPipelinesResponse listPipelines(Consumer<ListPipelinesRequest.Builder> listPipelinesRequest)
            throws DisabledOperationException, ValidationException, InternalException, AccessDeniedException,
            InvalidPaginationTokenException, AwsServiceException, SdkClientException, OsisException {
        return listPipelines(ListPipelinesRequest.builder().applyMutation(listPipelinesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listPipelines(software.amazon.awssdk.services.osis.model.ListPipelinesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.osis.paginators.ListPipelinesIterable responses = client.listPipelinesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.osis.paginators.ListPipelinesIterable responses = client.listPipelinesPaginator(request);
     *     for (software.amazon.awssdk.services.osis.model.ListPipelinesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.osis.paginators.ListPipelinesIterable responses = client.listPipelinesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPipelines(software.amazon.awssdk.services.osis.model.ListPipelinesRequest)} operation.</b>
     * </p>
     *
     * @param listPipelinesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws InvalidPaginationTokenException
     *         An invalid pagination token provided in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.ListPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/ListPipelines" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPipelinesIterable listPipelinesPaginator(ListPipelinesRequest listPipelinesRequest)
            throws DisabledOperationException, ValidationException, InternalException, AccessDeniedException,
            InvalidPaginationTokenException, AwsServiceException, SdkClientException, OsisException {
        return new ListPipelinesIterable(this, listPipelinesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listPipelines(software.amazon.awssdk.services.osis.model.ListPipelinesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.osis.paginators.ListPipelinesIterable responses = client.listPipelinesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.osis.paginators.ListPipelinesIterable responses = client.listPipelinesPaginator(request);
     *     for (software.amazon.awssdk.services.osis.model.ListPipelinesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.osis.paginators.ListPipelinesIterable responses = client.listPipelinesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPipelines(software.amazon.awssdk.services.osis.model.ListPipelinesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPipelinesRequest.Builder} avoiding the need to
     * create one manually via {@link ListPipelinesRequest#builder()}
     * </p>
     *
     * @param listPipelinesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.osis.model.ListPipelinesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws InvalidPaginationTokenException
     *         An invalid pagination token provided in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.ListPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/ListPipelines" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPipelinesIterable listPipelinesPaginator(Consumer<ListPipelinesRequest.Builder> listPipelinesRequest)
            throws DisabledOperationException, ValidationException, InternalException, AccessDeniedException,
            InvalidPaginationTokenException, AwsServiceException, SdkClientException, OsisException {
        return listPipelinesPaginator(ListPipelinesRequest.builder().applyMutation(listPipelinesRequest).build());
    }

    /**
     * <p>
     * Lists all resource tags associated with an OpenSearch Ingestion pipeline. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-pipeline.html">Tagging Amazon
     * OpenSearch Ingestion pipelines</a>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws ResourceNotFoundException
     *         You attempted to access or delete a resource that does not exist.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws DisabledOperationException, ValidationException, ResourceNotFoundException, InternalException,
            AccessDeniedException, AwsServiceException, SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all resource tags associated with an OpenSearch Ingestion pipeline. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-pipeline.html">Tagging Amazon
     * OpenSearch Ingestion pipelines</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.osis.model.ListTagsForResourceRequest.Builder} to create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws ResourceNotFoundException
     *         You attempted to access or delete a resource that does not exist.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws DisabledOperationException,
            ValidationException, ResourceNotFoundException, InternalException, AccessDeniedException, AwsServiceException,
            SdkClientException, OsisException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Attaches a resource-based policy to an OpenSearch Ingestion resource. Resource-based policies grant permissions
     * to principals to perform actions on the resource.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return Result of the PutResourcePolicy operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws LimitExceededException
     *         You attempted to create more than the allowed number of tags.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws ResourceNotFoundException
     *         You attempted to access or delete a resource that does not exist.
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/PutResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default PutResourcePolicyResponse putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest)
            throws DisabledOperationException, LimitExceededException, ValidationException, InternalException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches a resource-based policy to an OpenSearch Ingestion resource. Resource-based policies grant permissions
     * to principals to perform actions on the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutResourcePolicyRequest#builder()}
     * </p>
     *
     * @param putResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.osis.model.PutResourcePolicyRequest.Builder} to create a request.
     * @return Result of the PutResourcePolicy operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws LimitExceededException
     *         You attempted to create more than the allowed number of tags.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws ResourceNotFoundException
     *         You attempted to access or delete a resource that does not exist.
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/PutResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default PutResourcePolicyResponse putResourcePolicy(Consumer<PutResourcePolicyRequest.Builder> putResourcePolicyRequest)
            throws DisabledOperationException, LimitExceededException, ValidationException, InternalException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OsisException {
        return putResourcePolicy(PutResourcePolicyRequest.builder().applyMutation(putResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Revokes pipeline endpoints from specified endpoint IDs.
     * </p>
     *
     * @param revokePipelineEndpointConnectionsRequest
     * @return Result of the RevokePipelineEndpointConnections operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws LimitExceededException
     *         You attempted to create more than the allowed number of tags.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.RevokePipelineEndpointConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/RevokePipelineEndpointConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default RevokePipelineEndpointConnectionsResponse revokePipelineEndpointConnections(
            RevokePipelineEndpointConnectionsRequest revokePipelineEndpointConnectionsRequest) throws DisabledOperationException,
            LimitExceededException, ValidationException, InternalException, AccessDeniedException, AwsServiceException,
            SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Revokes pipeline endpoints from specified endpoint IDs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RevokePipelineEndpointConnectionsRequest.Builder}
     * avoiding the need to create one manually via {@link RevokePipelineEndpointConnectionsRequest#builder()}
     * </p>
     *
     * @param revokePipelineEndpointConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.osis.model.RevokePipelineEndpointConnectionsRequest.Builder} to
     *        create a request.
     * @return Result of the RevokePipelineEndpointConnections operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws LimitExceededException
     *         You attempted to create more than the allowed number of tags.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.RevokePipelineEndpointConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/RevokePipelineEndpointConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default RevokePipelineEndpointConnectionsResponse revokePipelineEndpointConnections(
            Consumer<RevokePipelineEndpointConnectionsRequest.Builder> revokePipelineEndpointConnectionsRequest)
            throws DisabledOperationException, LimitExceededException, ValidationException, InternalException,
            AccessDeniedException, AwsServiceException, SdkClientException, OsisException {
        return revokePipelineEndpointConnections(RevokePipelineEndpointConnectionsRequest.builder()
                .applyMutation(revokePipelineEndpointConnectionsRequest).build());
    }

    /**
     * <p>
     * Starts an OpenSearch Ingestion pipeline. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/pipeline--stop-start.html#pipeline--start"
     * >Starting an OpenSearch Ingestion pipeline</a>.
     * </p>
     *
     * @param startPipelineRequest
     * @return Result of the StartPipeline operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws ConflictException
     *         The client attempted to remove a resource that is currently in use.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws ResourceNotFoundException
     *         You attempted to access or delete a resource that does not exist.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.StartPipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/StartPipeline" target="_top">AWS API
     *      Documentation</a>
     */
    default StartPipelineResponse startPipeline(StartPipelineRequest startPipelineRequest) throws DisabledOperationException,
            AccessDeniedException, ConflictException, InternalException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an OpenSearch Ingestion pipeline. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/pipeline--stop-start.html#pipeline--start"
     * >Starting an OpenSearch Ingestion pipeline</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartPipelineRequest.Builder} avoiding the need to
     * create one manually via {@link StartPipelineRequest#builder()}
     * </p>
     *
     * @param startPipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.osis.model.StartPipelineRequest.Builder} to create a request.
     * @return Result of the StartPipeline operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws ConflictException
     *         The client attempted to remove a resource that is currently in use.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws ResourceNotFoundException
     *         You attempted to access or delete a resource that does not exist.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.StartPipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/StartPipeline" target="_top">AWS API
     *      Documentation</a>
     */
    default StartPipelineResponse startPipeline(Consumer<StartPipelineRequest.Builder> startPipelineRequest)
            throws DisabledOperationException, AccessDeniedException, ConflictException, InternalException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OsisException {
        return startPipeline(StartPipelineRequest.builder().applyMutation(startPipelineRequest).build());
    }

    /**
     * <p>
     * Stops an OpenSearch Ingestion pipeline. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/pipeline--stop-start.html#pipeline--stop"
     * >Stopping an OpenSearch Ingestion pipeline</a>.
     * </p>
     *
     * @param stopPipelineRequest
     * @return Result of the StopPipeline operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws ConflictException
     *         The client attempted to remove a resource that is currently in use.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws ResourceNotFoundException
     *         You attempted to access or delete a resource that does not exist.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.StopPipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/StopPipeline" target="_top">AWS API
     *      Documentation</a>
     */
    default StopPipelineResponse stopPipeline(StopPipelineRequest stopPipelineRequest) throws DisabledOperationException,
            AccessDeniedException, ConflictException, InternalException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an OpenSearch Ingestion pipeline. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/pipeline--stop-start.html#pipeline--stop"
     * >Stopping an OpenSearch Ingestion pipeline</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopPipelineRequest.Builder} avoiding the need to
     * create one manually via {@link StopPipelineRequest#builder()}
     * </p>
     *
     * @param stopPipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.osis.model.StopPipelineRequest.Builder} to create a request.
     * @return Result of the StopPipeline operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws ConflictException
     *         The client attempted to remove a resource that is currently in use.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws ResourceNotFoundException
     *         You attempted to access or delete a resource that does not exist.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.StopPipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/StopPipeline" target="_top">AWS API
     *      Documentation</a>
     */
    default StopPipelineResponse stopPipeline(Consumer<StopPipelineRequest.Builder> stopPipelineRequest)
            throws DisabledOperationException, AccessDeniedException, ConflictException, InternalException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OsisException {
        return stopPipeline(StopPipelineRequest.builder().applyMutation(stopPipelineRequest).build());
    }

    /**
     * <p>
     * Tags an OpenSearch Ingestion pipeline. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-pipeline.html">Tagging Amazon
     * OpenSearch Ingestion pipelines</a>.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws LimitExceededException
     *         You attempted to create more than the allowed number of tags.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws ResourceNotFoundException
     *         You attempted to access or delete a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws DisabledOperationException,
            LimitExceededException, ValidationException, InternalException, AccessDeniedException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tags an OpenSearch Ingestion pipeline. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-pipeline.html">Tagging Amazon
     * OpenSearch Ingestion pipelines</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.osis.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws LimitExceededException
     *         You attempted to create more than the allowed number of tags.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws ResourceNotFoundException
     *         You attempted to access or delete a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws DisabledOperationException, LimitExceededException, ValidationException, InternalException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, OsisException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from an OpenSearch Ingestion pipeline. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-pipeline.html">Tagging Amazon
     * OpenSearch Ingestion pipelines</a>.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws ResourceNotFoundException
     *         You attempted to access or delete a resource that does not exist.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws DisabledOperationException,
            ValidationException, ResourceNotFoundException, InternalException, AccessDeniedException, AwsServiceException,
            SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from an OpenSearch Ingestion pipeline. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-pipeline.html">Tagging Amazon
     * OpenSearch Ingestion pipelines</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.osis.model.UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws ResourceNotFoundException
     *         You attempted to access or delete a resource that does not exist.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws DisabledOperationException, ValidationException, ResourceNotFoundException, InternalException,
            AccessDeniedException, AwsServiceException, SdkClientException, OsisException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an OpenSearch Ingestion pipeline. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/update-pipeline.html">Updating Amazon
     * OpenSearch Ingestion pipelines</a>.
     * </p>
     *
     * @param updatePipelineRequest
     * @return Result of the UpdatePipeline operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws ResourceNotFoundException
     *         You attempted to access or delete a resource that does not exist.
     * @throws ConflictException
     *         The client attempted to remove a resource that is currently in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.UpdatePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/UpdatePipeline" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdatePipelineResponse updatePipeline(UpdatePipelineRequest updatePipelineRequest) throws DisabledOperationException,
            ValidationException, InternalException, AccessDeniedException, ResourceNotFoundException, ConflictException,
            AwsServiceException, SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an OpenSearch Ingestion pipeline. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/update-pipeline.html">Updating Amazon
     * OpenSearch Ingestion pipelines</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePipelineRequest.Builder} avoiding the need to
     * create one manually via {@link UpdatePipelineRequest#builder()}
     * </p>
     *
     * @param updatePipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.osis.model.UpdatePipelineRequest.Builder} to create a request.
     * @return Result of the UpdatePipeline operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws ResourceNotFoundException
     *         You attempted to access or delete a resource that does not exist.
     * @throws ConflictException
     *         The client attempted to remove a resource that is currently in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.UpdatePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/UpdatePipeline" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdatePipelineResponse updatePipeline(Consumer<UpdatePipelineRequest.Builder> updatePipelineRequest)
            throws DisabledOperationException, ValidationException, InternalException, AccessDeniedException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, OsisException {
        return updatePipeline(UpdatePipelineRequest.builder().applyMutation(updatePipelineRequest).build());
    }

    /**
     * <p>
     * Checks whether an OpenSearch Ingestion pipeline configuration is valid prior to creation. For more information,
     * see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/creating-pipeline.html">Creating
     * Amazon OpenSearch Ingestion pipelines</a>.
     * </p>
     *
     * @param validatePipelineRequest
     * @return Result of the ValidatePipeline operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.ValidatePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/ValidatePipeline" target="_top">AWS API
     *      Documentation</a>
     */
    default ValidatePipelineResponse validatePipeline(ValidatePipelineRequest validatePipelineRequest)
            throws DisabledOperationException, AccessDeniedException, InternalException, ValidationException,
            AwsServiceException, SdkClientException, OsisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Checks whether an OpenSearch Ingestion pipeline configuration is valid prior to creation. For more information,
     * see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/creating-pipeline.html">Creating
     * Amazon OpenSearch Ingestion pipelines</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ValidatePipelineRequest.Builder} avoiding the need
     * to create one manually via {@link ValidatePipelineRequest#builder()}
     * </p>
     *
     * @param validatePipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.osis.model.ValidatePipelineRequest.Builder} to create a request.
     * @return Result of the ValidatePipeline operation returned by the service.
     * @throws DisabledOperationException
     *         Exception is thrown when an operation has been disabled.
     * @throws AccessDeniedException
     *         You don't have permissions to access the resource.
     * @throws InternalException
     *         The request failed because of an unknown error, exception, or failure (the failure is internal to the
     *         service).
     * @throws ValidationException
     *         An exception for missing or invalid input fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OsisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OsisClient.ValidatePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/osis-2022-01-01/ValidatePipeline" target="_top">AWS API
     *      Documentation</a>
     */
    default ValidatePipelineResponse validatePipeline(Consumer<ValidatePipelineRequest.Builder> validatePipelineRequest)
            throws DisabledOperationException, AccessDeniedException, InternalException, ValidationException,
            AwsServiceException, SdkClientException, OsisException {
        return validatePipeline(ValidatePipelineRequest.builder().applyMutation(validatePipelineRequest).build());
    }

    /**
     * Create a {@link OsisClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static OsisClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link OsisClient}.
     */
    static OsisClientBuilder builder() {
        return new DefaultOsisClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default OsisServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
