/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.osis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.osis.model.OsisResponse;
import software.amazon.awssdk.services.osis.model.PipelineBlueprint;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPipelineBlueprintResponse
extends OsisResponse
implements ToCopyableBuilder<Builder, GetPipelineBlueprintResponse> {
    private static final SdkField<PipelineBlueprint> BLUEPRINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Blueprint").getter(GetPipelineBlueprintResponse.getter(GetPipelineBlueprintResponse::blueprint)).setter(GetPipelineBlueprintResponse.setter(Builder::blueprint)).constructor(PipelineBlueprint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Blueprint").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(GetPipelineBlueprintResponse.getter(GetPipelineBlueprintResponse::format)).setter(GetPipelineBlueprintResponse.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINT_FIELD, FORMAT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetPipelineBlueprintResponse.memberNameToFieldInitializer();
    private final PipelineBlueprint blueprint;
    private final String format;

    private GetPipelineBlueprintResponse(BuilderImpl builder) {
        super(builder);
        this.blueprint = builder.blueprint;
        this.format = builder.format;
    }

    public final PipelineBlueprint blueprint() {
        return this.blueprint;
    }

    public final String format() {
        return this.format;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprint());
        hashCode = 31 * hashCode + Objects.hashCode(this.format());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPipelineBlueprintResponse)) {
            return false;
        }
        GetPipelineBlueprintResponse other = (GetPipelineBlueprintResponse)((Object)obj);
        return Objects.equals(this.blueprint(), other.blueprint()) && Objects.equals(this.format(), other.format());
    }

    public final String toString() {
        return ToString.builder((String)"GetPipelineBlueprintResponse").add("Blueprint", (Object)this.blueprint()).add("Format", (Object)this.format()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Blueprint": {
                return Optional.ofNullable(clazz.cast(this.blueprint()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.format()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Blueprint", BLUEPRINT_FIELD);
        map.put("Format", FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPipelineBlueprintResponse, T> g) {
        return obj -> g.apply((GetPipelineBlueprintResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OsisResponse.BuilderImpl
    implements Builder {
        private PipelineBlueprint blueprint;
        private String format;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPipelineBlueprintResponse model) {
            super(model);
            this.blueprint(model.blueprint);
            this.format(model.format);
        }

        public final PipelineBlueprint.Builder getBlueprint() {
            return this.blueprint != null ? this.blueprint.toBuilder() : null;
        }

        public final void setBlueprint(PipelineBlueprint.BuilderImpl blueprint) {
            this.blueprint = blueprint != null ? blueprint.build() : null;
        }

        @Override
        public final Builder blueprint(PipelineBlueprint blueprint) {
            this.blueprint = blueprint;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public GetPipelineBlueprintResponse build() {
            return new GetPipelineBlueprintResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OsisResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPipelineBlueprintResponse> {
        public Builder blueprint(PipelineBlueprint var1);

        default public Builder blueprint(Consumer<PipelineBlueprint.Builder> blueprint) {
            return this.blueprint((PipelineBlueprint)((PipelineBlueprint.Builder)PipelineBlueprint.builder().applyMutation(blueprint)).build());
        }

        public Builder format(String var1);
    }
}

