/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.osis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.osis.model.BufferOptions;
import software.amazon.awssdk.services.osis.model.EncryptionAtRestOptions;
import software.amazon.awssdk.services.osis.model.LogPublishingOptions;
import software.amazon.awssdk.services.osis.model.OsisRequest;
import software.amazon.awssdk.services.osis.model.Tag;
import software.amazon.awssdk.services.osis.model.TagListCopier;
import software.amazon.awssdk.services.osis.model.VpcOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePipelineRequest
extends OsisRequest
implements ToCopyableBuilder<Builder, CreatePipelineRequest> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineName").getter(CreatePipelineRequest.getter(CreatePipelineRequest::pipelineName)).setter(CreatePipelineRequest.setter(Builder::pipelineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineName").build()}).build();
    private static final SdkField<Integer> MIN_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinUnits").getter(CreatePipelineRequest.getter(CreatePipelineRequest::minUnits)).setter(CreatePipelineRequest.setter(Builder::minUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinUnits").build()}).build();
    private static final SdkField<Integer> MAX_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxUnits").getter(CreatePipelineRequest.getter(CreatePipelineRequest::maxUnits)).setter(CreatePipelineRequest.setter(Builder::maxUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxUnits").build()}).build();
    private static final SdkField<String> PIPELINE_CONFIGURATION_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineConfigurationBody").getter(CreatePipelineRequest.getter(CreatePipelineRequest::pipelineConfigurationBody)).setter(CreatePipelineRequest.setter(Builder::pipelineConfigurationBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineConfigurationBody").build()}).build();
    private static final SdkField<LogPublishingOptions> LOG_PUBLISHING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LogPublishingOptions").getter(CreatePipelineRequest.getter(CreatePipelineRequest::logPublishingOptions)).setter(CreatePipelineRequest.setter(Builder::logPublishingOptions)).constructor(LogPublishingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPublishingOptions").build()}).build();
    private static final SdkField<VpcOptions> VPC_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcOptions").getter(CreatePipelineRequest.getter(CreatePipelineRequest::vpcOptions)).setter(CreatePipelineRequest.setter(Builder::vpcOptions)).constructor(VpcOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcOptions").build()}).build();
    private static final SdkField<BufferOptions> BUFFER_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BufferOptions").getter(CreatePipelineRequest.getter(CreatePipelineRequest::bufferOptions)).setter(CreatePipelineRequest.setter(Builder::bufferOptions)).constructor(BufferOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BufferOptions").build()}).build();
    private static final SdkField<EncryptionAtRestOptions> ENCRYPTION_AT_REST_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionAtRestOptions").getter(CreatePipelineRequest.getter(CreatePipelineRequest::encryptionAtRestOptions)).setter(CreatePipelineRequest.setter(Builder::encryptionAtRestOptions)).constructor(EncryptionAtRestOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionAtRestOptions").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreatePipelineRequest.getter(CreatePipelineRequest::tags)).setter(CreatePipelineRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD, MIN_UNITS_FIELD, MAX_UNITS_FIELD, PIPELINE_CONFIGURATION_BODY_FIELD, LOG_PUBLISHING_OPTIONS_FIELD, VPC_OPTIONS_FIELD, BUFFER_OPTIONS_FIELD, ENCRYPTION_AT_REST_OPTIONS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreatePipelineRequest.memberNameToFieldInitializer();
    private final String pipelineName;
    private final Integer minUnits;
    private final Integer maxUnits;
    private final String pipelineConfigurationBody;
    private final LogPublishingOptions logPublishingOptions;
    private final VpcOptions vpcOptions;
    private final BufferOptions bufferOptions;
    private final EncryptionAtRestOptions encryptionAtRestOptions;
    private final List<Tag> tags;

    private CreatePipelineRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.minUnits = builder.minUnits;
        this.maxUnits = builder.maxUnits;
        this.pipelineConfigurationBody = builder.pipelineConfigurationBody;
        this.logPublishingOptions = builder.logPublishingOptions;
        this.vpcOptions = builder.vpcOptions;
        this.bufferOptions = builder.bufferOptions;
        this.encryptionAtRestOptions = builder.encryptionAtRestOptions;
        this.tags = builder.tags;
    }

    public final String pipelineName() {
        return this.pipelineName;
    }

    public final Integer minUnits() {
        return this.minUnits;
    }

    public final Integer maxUnits() {
        return this.maxUnits;
    }

    public final String pipelineConfigurationBody() {
        return this.pipelineConfigurationBody;
    }

    public final LogPublishingOptions logPublishingOptions() {
        return this.logPublishingOptions;
    }

    public final VpcOptions vpcOptions() {
        return this.vpcOptions;
    }

    public final BufferOptions bufferOptions() {
        return this.bufferOptions;
    }

    public final EncryptionAtRestOptions encryptionAtRestOptions() {
        return this.encryptionAtRestOptions;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.minUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineConfigurationBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.logPublishingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.bufferOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionAtRestOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePipelineRequest)) {
            return false;
        }
        CreatePipelineRequest other = (CreatePipelineRequest)((Object)obj);
        return Objects.equals(this.pipelineName(), other.pipelineName()) && Objects.equals(this.minUnits(), other.minUnits()) && Objects.equals(this.maxUnits(), other.maxUnits()) && Objects.equals(this.pipelineConfigurationBody(), other.pipelineConfigurationBody()) && Objects.equals(this.logPublishingOptions(), other.logPublishingOptions()) && Objects.equals(this.vpcOptions(), other.vpcOptions()) && Objects.equals(this.bufferOptions(), other.bufferOptions()) && Objects.equals(this.encryptionAtRestOptions(), other.encryptionAtRestOptions()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePipelineRequest").add("PipelineName", (Object)this.pipelineName()).add("MinUnits", (Object)this.minUnits()).add("MaxUnits", (Object)this.maxUnits()).add("PipelineConfigurationBody", (Object)this.pipelineConfigurationBody()).add("LogPublishingOptions", (Object)this.logPublishingOptions()).add("VpcOptions", (Object)this.vpcOptions()).add("BufferOptions", (Object)this.bufferOptions()).add("EncryptionAtRestOptions", (Object)this.encryptionAtRestOptions()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PipelineName": {
                return Optional.ofNullable(clazz.cast(this.pipelineName()));
            }
            case "MinUnits": {
                return Optional.ofNullable(clazz.cast(this.minUnits()));
            }
            case "MaxUnits": {
                return Optional.ofNullable(clazz.cast(this.maxUnits()));
            }
            case "PipelineConfigurationBody": {
                return Optional.ofNullable(clazz.cast(this.pipelineConfigurationBody()));
            }
            case "LogPublishingOptions": {
                return Optional.ofNullable(clazz.cast(this.logPublishingOptions()));
            }
            case "VpcOptions": {
                return Optional.ofNullable(clazz.cast(this.vpcOptions()));
            }
            case "BufferOptions": {
                return Optional.ofNullable(clazz.cast(this.bufferOptions()));
            }
            case "EncryptionAtRestOptions": {
                return Optional.ofNullable(clazz.cast(this.encryptionAtRestOptions()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PipelineName", PIPELINE_NAME_FIELD);
        map.put("MinUnits", MIN_UNITS_FIELD);
        map.put("MaxUnits", MAX_UNITS_FIELD);
        map.put("PipelineConfigurationBody", PIPELINE_CONFIGURATION_BODY_FIELD);
        map.put("LogPublishingOptions", LOG_PUBLISHING_OPTIONS_FIELD);
        map.put("VpcOptions", VPC_OPTIONS_FIELD);
        map.put("BufferOptions", BUFFER_OPTIONS_FIELD);
        map.put("EncryptionAtRestOptions", ENCRYPTION_AT_REST_OPTIONS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePipelineRequest, T> g) {
        return obj -> g.apply((CreatePipelineRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OsisRequest.BuilderImpl
    implements Builder {
        private String pipelineName;
        private Integer minUnits;
        private Integer maxUnits;
        private String pipelineConfigurationBody;
        private LogPublishingOptions logPublishingOptions;
        private VpcOptions vpcOptions;
        private BufferOptions bufferOptions;
        private EncryptionAtRestOptions encryptionAtRestOptions;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePipelineRequest model) {
            super(model);
            this.pipelineName(model.pipelineName);
            this.minUnits(model.minUnits);
            this.maxUnits(model.maxUnits);
            this.pipelineConfigurationBody(model.pipelineConfigurationBody);
            this.logPublishingOptions(model.logPublishingOptions);
            this.vpcOptions(model.vpcOptions);
            this.bufferOptions(model.bufferOptions);
            this.encryptionAtRestOptions(model.encryptionAtRestOptions);
            this.tags(model.tags);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final Integer getMinUnits() {
            return this.minUnits;
        }

        public final void setMinUnits(Integer minUnits) {
            this.minUnits = minUnits;
        }

        @Override
        public final Builder minUnits(Integer minUnits) {
            this.minUnits = minUnits;
            return this;
        }

        public final Integer getMaxUnits() {
            return this.maxUnits;
        }

        public final void setMaxUnits(Integer maxUnits) {
            this.maxUnits = maxUnits;
        }

        @Override
        public final Builder maxUnits(Integer maxUnits) {
            this.maxUnits = maxUnits;
            return this;
        }

        public final String getPipelineConfigurationBody() {
            return this.pipelineConfigurationBody;
        }

        public final void setPipelineConfigurationBody(String pipelineConfigurationBody) {
            this.pipelineConfigurationBody = pipelineConfigurationBody;
        }

        @Override
        public final Builder pipelineConfigurationBody(String pipelineConfigurationBody) {
            this.pipelineConfigurationBody = pipelineConfigurationBody;
            return this;
        }

        public final LogPublishingOptions.Builder getLogPublishingOptions() {
            return this.logPublishingOptions != null ? this.logPublishingOptions.toBuilder() : null;
        }

        public final void setLogPublishingOptions(LogPublishingOptions.BuilderImpl logPublishingOptions) {
            this.logPublishingOptions = logPublishingOptions != null ? logPublishingOptions.build() : null;
        }

        @Override
        public final Builder logPublishingOptions(LogPublishingOptions logPublishingOptions) {
            this.logPublishingOptions = logPublishingOptions;
            return this;
        }

        public final VpcOptions.Builder getVpcOptions() {
            return this.vpcOptions != null ? this.vpcOptions.toBuilder() : null;
        }

        public final void setVpcOptions(VpcOptions.BuilderImpl vpcOptions) {
            this.vpcOptions = vpcOptions != null ? vpcOptions.build() : null;
        }

        @Override
        public final Builder vpcOptions(VpcOptions vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        public final BufferOptions.Builder getBufferOptions() {
            return this.bufferOptions != null ? this.bufferOptions.toBuilder() : null;
        }

        public final void setBufferOptions(BufferOptions.BuilderImpl bufferOptions) {
            this.bufferOptions = bufferOptions != null ? bufferOptions.build() : null;
        }

        @Override
        public final Builder bufferOptions(BufferOptions bufferOptions) {
            this.bufferOptions = bufferOptions;
            return this;
        }

        public final EncryptionAtRestOptions.Builder getEncryptionAtRestOptions() {
            return this.encryptionAtRestOptions != null ? this.encryptionAtRestOptions.toBuilder() : null;
        }

        public final void setEncryptionAtRestOptions(EncryptionAtRestOptions.BuilderImpl encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions != null ? encryptionAtRestOptions.build() : null;
        }

        @Override
        public final Builder encryptionAtRestOptions(EncryptionAtRestOptions encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePipelineRequest build() {
            return new CreatePipelineRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OsisRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePipelineRequest> {
        public Builder pipelineName(String var1);

        public Builder minUnits(Integer var1);

        public Builder maxUnits(Integer var1);

        public Builder pipelineConfigurationBody(String var1);

        public Builder logPublishingOptions(LogPublishingOptions var1);

        default public Builder logPublishingOptions(Consumer<LogPublishingOptions.Builder> logPublishingOptions) {
            return this.logPublishingOptions((LogPublishingOptions)((LogPublishingOptions.Builder)LogPublishingOptions.builder().applyMutation(logPublishingOptions)).build());
        }

        public Builder vpcOptions(VpcOptions var1);

        default public Builder vpcOptions(Consumer<VpcOptions.Builder> vpcOptions) {
            return this.vpcOptions((VpcOptions)((VpcOptions.Builder)VpcOptions.builder().applyMutation(vpcOptions)).build());
        }

        public Builder bufferOptions(BufferOptions var1);

        default public Builder bufferOptions(Consumer<BufferOptions.Builder> bufferOptions) {
            return this.bufferOptions((BufferOptions)((BufferOptions.Builder)BufferOptions.builder().applyMutation(bufferOptions)).build());
        }

        public Builder encryptionAtRestOptions(EncryptionAtRestOptions var1);

        default public Builder encryptionAtRestOptions(Consumer<EncryptionAtRestOptions.Builder> encryptionAtRestOptions) {
            return this.encryptionAtRestOptions((EncryptionAtRestOptions)((EncryptionAtRestOptions.Builder)EncryptionAtRestOptions.builder().applyMutation(encryptionAtRestOptions)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

