/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.osis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.osis.model.OsisResponse;
import software.amazon.awssdk.services.osis.model.PipelineBlueprintSummary;
import software.amazon.awssdk.services.osis.model.PipelineBlueprintsSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPipelineBlueprintsResponse
extends OsisResponse
implements ToCopyableBuilder<Builder, ListPipelineBlueprintsResponse> {
    private static final SdkField<List<PipelineBlueprintSummary>> BLUEPRINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Blueprints").getter(ListPipelineBlueprintsResponse.getter(ListPipelineBlueprintsResponse::blueprints)).setter(ListPipelineBlueprintsResponse.setter(Builder::blueprints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Blueprints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PipelineBlueprintSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Blueprints", BLUEPRINTS_FIELD);
        }
    });
    private final List<PipelineBlueprintSummary> blueprints;

    private ListPipelineBlueprintsResponse(BuilderImpl builder) {
        super(builder);
        this.blueprints = builder.blueprints;
    }

    public final boolean hasBlueprints() {
        return this.blueprints != null && !(this.blueprints instanceof SdkAutoConstructList);
    }

    public final List<PipelineBlueprintSummary> blueprints() {
        return this.blueprints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlueprints() ? this.blueprints() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPipelineBlueprintsResponse)) {
            return false;
        }
        ListPipelineBlueprintsResponse other = (ListPipelineBlueprintsResponse)((Object)obj);
        return this.hasBlueprints() == other.hasBlueprints() && Objects.equals(this.blueprints(), other.blueprints());
    }

    public final String toString() {
        return ToString.builder((String)"ListPipelineBlueprintsResponse").add("Blueprints", this.hasBlueprints() ? this.blueprints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Blueprints": {
                return Optional.ofNullable(clazz.cast(this.blueprints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListPipelineBlueprintsResponse, T> g) {
        return obj -> g.apply((ListPipelineBlueprintsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OsisResponse.BuilderImpl
    implements Builder {
        private List<PipelineBlueprintSummary> blueprints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPipelineBlueprintsResponse model) {
            super(model);
            this.blueprints(model.blueprints);
        }

        public final List<PipelineBlueprintSummary.Builder> getBlueprints() {
            List<PipelineBlueprintSummary.Builder> result = PipelineBlueprintsSummaryListCopier.copyToBuilder(this.blueprints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlueprints(Collection<PipelineBlueprintSummary.BuilderImpl> blueprints) {
            this.blueprints = PipelineBlueprintsSummaryListCopier.copyFromBuilder(blueprints);
        }

        @Override
        public final Builder blueprints(Collection<PipelineBlueprintSummary> blueprints) {
            this.blueprints = PipelineBlueprintsSummaryListCopier.copy(blueprints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blueprints(PipelineBlueprintSummary ... blueprints) {
            this.blueprints(Arrays.asList(blueprints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blueprints(Consumer<PipelineBlueprintSummary.Builder> ... blueprints) {
            this.blueprints(Stream.of(blueprints).map(c -> (PipelineBlueprintSummary)((PipelineBlueprintSummary.Builder)PipelineBlueprintSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPipelineBlueprintsResponse build() {
            return new ListPipelineBlueprintsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OsisResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPipelineBlueprintsResponse> {
        public Builder blueprints(Collection<PipelineBlueprintSummary> var1);

        public Builder blueprints(PipelineBlueprintSummary ... var1);

        public Builder blueprints(Consumer<PipelineBlueprintSummary.Builder> ... var1);
    }
}

