/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.osis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipelineBlueprintSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PipelineBlueprintSummary> {
    private static final SdkField<String> BLUEPRINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BlueprintName").getter(PipelineBlueprintSummary.getter(PipelineBlueprintSummary::blueprintName)).setter(PipelineBlueprintSummary.setter(Builder::blueprintName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlueprintName").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(PipelineBlueprintSummary.getter(PipelineBlueprintSummary::displayName)).setter(PipelineBlueprintSummary.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> DISPLAY_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayDescription").getter(PipelineBlueprintSummary.getter(PipelineBlueprintSummary::displayDescription)).setter(PipelineBlueprintSummary.setter(Builder::displayDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayDescription").build()}).build();
    private static final SdkField<String> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Service").getter(PipelineBlueprintSummary.getter(PipelineBlueprintSummary::service)).setter(PipelineBlueprintSummary.setter(Builder::service)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build()}).build();
    private static final SdkField<String> USE_CASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UseCase").getter(PipelineBlueprintSummary.getter(PipelineBlueprintSummary::useCase)).setter(PipelineBlueprintSummary.setter(Builder::useCase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseCase").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINT_NAME_FIELD, DISPLAY_NAME_FIELD, DISPLAY_DESCRIPTION_FIELD, SERVICE_FIELD, USE_CASE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String blueprintName;
    private final String displayName;
    private final String displayDescription;
    private final String service;
    private final String useCase;

    private PipelineBlueprintSummary(BuilderImpl builder) {
        this.blueprintName = builder.blueprintName;
        this.displayName = builder.displayName;
        this.displayDescription = builder.displayDescription;
        this.service = builder.service;
        this.useCase = builder.useCase;
    }

    public final String blueprintName() {
        return this.blueprintName;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String displayDescription() {
        return this.displayDescription;
    }

    public final String service() {
        return this.service;
    }

    public final String useCase() {
        return this.useCase;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintName());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.service());
        hashCode = 31 * hashCode + Objects.hashCode(this.useCase());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineBlueprintSummary)) {
            return false;
        }
        PipelineBlueprintSummary other = (PipelineBlueprintSummary)obj;
        return Objects.equals(this.blueprintName(), other.blueprintName()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.displayDescription(), other.displayDescription()) && Objects.equals(this.service(), other.service()) && Objects.equals(this.useCase(), other.useCase());
    }

    public final String toString() {
        return ToString.builder((String)"PipelineBlueprintSummary").add("BlueprintName", (Object)this.blueprintName()).add("DisplayName", (Object)this.displayName()).add("DisplayDescription", (Object)this.displayDescription()).add("Service", (Object)this.service()).add("UseCase", (Object)this.useCase()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlueprintName": {
                return Optional.ofNullable(clazz.cast(this.blueprintName()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "DisplayDescription": {
                return Optional.ofNullable(clazz.cast(this.displayDescription()));
            }
            case "Service": {
                return Optional.ofNullable(clazz.cast(this.service()));
            }
            case "UseCase": {
                return Optional.ofNullable(clazz.cast(this.useCase()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipelineBlueprintSummary, T> g) {
        return obj -> g.apply((PipelineBlueprintSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String blueprintName;
        private String displayName;
        private String displayDescription;
        private String service;
        private String useCase;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineBlueprintSummary model) {
            this.blueprintName(model.blueprintName);
            this.displayName(model.displayName);
            this.displayDescription(model.displayDescription);
            this.service(model.service);
            this.useCase(model.useCase);
        }

        public final String getBlueprintName() {
            return this.blueprintName;
        }

        public final void setBlueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
        }

        @Override
        public final Builder blueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDisplayDescription() {
            return this.displayDescription;
        }

        public final void setDisplayDescription(String displayDescription) {
            this.displayDescription = displayDescription;
        }

        @Override
        public final Builder displayDescription(String displayDescription) {
            this.displayDescription = displayDescription;
            return this;
        }

        public final String getService() {
            return this.service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final String getUseCase() {
            return this.useCase;
        }

        public final void setUseCase(String useCase) {
            this.useCase = useCase;
        }

        @Override
        public final Builder useCase(String useCase) {
            this.useCase = useCase;
            return this;
        }

        public PipelineBlueprintSummary build() {
            return new PipelineBlueprintSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PipelineBlueprintSummary> {
        public Builder blueprintName(String var1);

        public Builder displayName(String var1);

        public Builder displayDescription(String var1);

        public Builder service(String var1);

        public Builder useCase(String var1);
    }
}

